/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.client;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.management.network.Network;
import com.microsoft.azure.management.resources.Deployment;
import com.microsoft.azure.management.resources.DeploymentMode;
import com.microsoft.azure.management.resources.DeploymentOperation;
import com.microsoft.azure.management.resources.Provider;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.netflix.spinnaker.clouddriver.azure.client.AzureBaseClient;
import com.netflix.spinnaker.clouddriver.azure.common.AzureUtilities;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureResourceManagerClient
extends AzureBaseClient {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AzureResourceManagerClient(String subscriptionId, ApplicationTokenCredentials credentials, String userAgentApplicationName) {
        super(subscriptionId, userAgentApplicationName, credentials);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Generated
    public AzureResourceManagerClient(String subscriptionId, ApplicationTokenCredentials credentials) {
        this(subscriptionId, credentials, "");
    }

    public Deployment createResourceFromTemplate(String template, String resourceGroupName, String region, String resourceName, String resourceType, Map<String, Object> templateParams) {
        String deploymentName = DefaultGroovyMethods.join((Iterable)ScriptBytecodeAdapter.createList((Object[])new Object[]{resourceName, resourceType, "deployment"}), (String)AzureUtilities.getNAME_SEPARATOR());
        if (!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getAt(templateParams, (Object)"location"))) {
            String string = region;
            DefaultGroovyMethods.putAt(templateParams, (Object)"location", (Object)string);
        }
        return this.createTemplateDeployment(resourceGroupName, DeploymentMode.INCREMENTAL, deploymentName, template, templateParams);
    }

    public ResourceGroup createResourceGroup(String resourceGroupName, String region) {
        ResourceGroup resourceGroup = (ResourceGroup)ScriptBytecodeAdapter.castToType((Object)((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.Blank)this.getAzure().resourceGroups().define(resourceGroupName)).withRegion(region)).create(), ResourceGroup.class);
        try {
            return resourceGroup;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resourceGroupName, region}, new String[]{"Unable to create Resource Group ", " in region ", ""})), (Throwable)ScriptBytecodeAdapter.castToType((Object)e, Throwable.class));
        }
    }

    public ResourceGroup initializeResourceGroupAndVNet(String resourceGroupName, String virtualNetworkName, String region) {
        ResourceGroup resourceGroup;
        ResourceGroup resourceGroup2;
        ResourceGroup resourceGroup3 = null;
        resourceGroup3 = !this.resourceGroupExists(resourceGroupName) ? (resourceGroup2 = this.createResourceGroup(resourceGroupName, region)) : (resourceGroup = this.getResourceGroup(resourceGroupName));
        if (DefaultTypeTransformation.booleanUnbox((Object)virtualNetworkName)) {
            this.initializeResourceGroupVNet(resourceGroupName, virtualNetworkName, region);
        }
        return resourceGroup3;
    }

    public boolean resourceGroupExists(String resourceGroupName) {
        return this.getAzure().resourceGroups().contain(resourceGroupName);
    }

    private ResourceGroup getResourceGroup(String resourceGroupName) {
        return (ResourceGroup)ScriptBytecodeAdapter.castToType((Object)this.getAzure().resourceGroups().getByName(resourceGroupName), ResourceGroup.class);
    }

    /*
     * WARNING - void declaration
     */
    public List<DeploymentOperation> getDeploymentOperations(String resourceGroupName, String deploymentName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference deploymentName2 = new Reference((Object)var2_2);
        public final class _getDeploymentOperations_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference deploymentName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDeploymentOperations_closure1(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference deploymentName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.deploymentName = reference = deploymentName;
            }

            public Object doCall(Object it) {
                PagedList list = ((Deployment)((AzureResourceManagerClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().deployments().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.deploymentName.get()))).deploymentOperations().list();
                list.loadAll();
                return list;
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getDeploymentName() {
                return ShortTypeHandling.castToString((Object)this.deploymentName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDeploymentOperations_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (List)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _getDeploymentOperations_closure1(this, this, resourceGroupName2, deploymentName2)), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public Deployment getDeployment(String resourceGroupName, String deploymentName) {
        void var2_2;
        Reference resourceGroupName2 = new Reference((Object)resourceGroupName);
        Reference deploymentName2 = new Reference((Object)var2_2);
        public final class _getDeployment_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceGroupName;
            private /* synthetic */ Reference deploymentName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getDeployment_closure2(Object _outerInstance, Object _thisObject, Reference resourceGroupName, Reference deploymentName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.resourceGroupName = reference2 = resourceGroupName;
                this.deploymentName = reference = deploymentName;
            }

            public Object doCall(Object it) {
                return ((AzureResourceManagerClient)((AzureBaseClient)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AzureBaseClient.class))).getAzure().deployments().getByResourceGroup(ShortTypeHandling.castToString((Object)this.resourceGroupName.get()), ShortTypeHandling.castToString((Object)this.deploymentName.get()));
            }

            @Generated
            public String getResourceGroupName() {
                return ShortTypeHandling.castToString((Object)this.resourceGroupName.get());
            }

            @Generated
            public String getDeploymentName() {
                return ShortTypeHandling.castToString((Object)this.deploymentName.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getDeployment_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Deployment)ScriptBytecodeAdapter.castToType(AzureBaseClient.executeOp(new _getDeployment_closure2(this, this, resourceGroupName2, deploymentName2)), Deployment.class);
    }

    public void healthCheck() {
        try {
            this.getAzure().genericResources().list();
        }
        catch (Exception e) {
            throw (Throwable)new Exception("Unable to ping Azure", e);
        }
    }

    private void initializeResourceGroupVNet(String resourceGroupName, String virtualNetworkName, String region) {
        Network vNet;
        block6: {
            vNet = null;
            try {
                Object object = this.getAzure().networks().getByResourceGroup(resourceGroupName, virtualNetworkName);
                vNet = (Network)ScriptBytecodeAdapter.castToType((Object)object, Network.class);
            }
            catch (CloudException ignore) {
                Object v0;
                if (log.isWarnEnabled()) {
                    log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{virtualNetworkName}, new String[]{"Failed to locate Azure Virtual Network ", ""})));
                    v0 = null;
                    break block6;
                }
                v0 = null;
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox(vNet)) {
            ((Network.DefinitionStages.WithCreate)((Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)this.getAzure().networks().define(virtualNetworkName)).withRegion(region)).withExistingResourceGroup(resourceGroupName)).create();
        }
    }

    private Deployment createTemplateDeployment(String resourceGroupName, DeploymentMode deploymentMode, String deploymentName, String template, Map<String, Object> templateParameters) {
        try {
            String parameters = AzureUtilities.convertParametersToTemplateJSON(AzureBaseClient.getMapper(), templateParameters);
            Deployment deployment = (Deployment)ScriptBytecodeAdapter.castToType((Object)((Deployment.DefinitionStages.WithTemplate)((Deployment.DefinitionStages.Blank)this.getAzure().deployments().define(deploymentName)).withExistingResourceGroup(resourceGroupName)).withTemplate(template).withParameters(parameters).withMode(deploymentMode).create(), Deployment.class);
            return deployment;
        }
        catch (Throwable e) {
            Object v0;
            if (log.isErrorEnabled()) {
                log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Exception occured during deployment ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            throw e;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            AzureResourceManagerClient.logDeploymentTemplate(deploymentName, template, templateParameters);
        }
    }

    public static void logDeploymentTemplate(String deploymentName, String template, Map<String, Object> parameters) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info("Template for deployment {}: {}\nTemplate Parameters: {}", new Object[]{deploymentName, template, DefaultGroovyMethods.toMapString(parameters)});
            v0 = null;
        } else {
            v0 = null;
        }
    }

    public void registerProvider(String namespace) {
        block8: {
            try {
                Object v1;
                Object v0;
                Provider provider = (Provider)ScriptBytecodeAdapter.castToType((Object)this.getAzure().providers().getByName(namespace), Provider.class);
                if (!ScriptBytecodeAdapter.compareNotEqual((Object)provider.registrationState(), (Object)"Registered")) break block8;
                if (log.isInfoEnabled()) {
                    log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{namespace}, new String[]{"Registering Azure provider: ", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
                this.getAzure().providers().register(namespace);
                if (log.isInfoEnabled()) {
                    log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{namespace}, new String[]{"Azure provider ", " registered"})));
                    v1 = null;
                    break block8;
                }
                v1 = null;
            }
            catch (Exception e) {
                Object v2;
                if (log.isErrorEnabled()) {
                    log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{namespace}, new String[]{"Unable to register Azure Provider: ", ""})), (Throwable)e);
                    v2 = null;
                    break block8;
                }
                v2 = null;
            }
        }
    }

    @Override
    public String getProviderNamespace() {
        return "Microsoft.Resources";
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureResourceManagerClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public Deployment createResourceFromTemplate(String template, String resourceGroupName, String region, String resourceName, String resourceType) {
        return this.createResourceFromTemplate(template, resourceGroupName, region, resourceName, resourceType, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.clouddriver.azure.client.AzureResourceManagerClient");
    }
}

