/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.azure.resources.common.AzureResourceOpsDescription;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class AzureUtilities
implements GroovyObject {
    private static final String PATH_SEPARATOR;
    private static final String NAME_SEPARATOR;
    private static final String VNET_NAME_PREFIX = "vnet-";
    private static final String SUBNET_NAME_PREFIX = "subnet-";
    private static final String PUBLICIP_NAME_PREFIX = "pip-";
    private static final String LBFRONTEND_NAME_PREFIX = "fe-";
    private static final String LBBACKEND_NAME_PREFIX = "be-";
    private static final String DNS_NAME_PREFIX = "dns-";
    private static final String IPCONFIG_NAME_PREFIX = "ipc-";
    private static final String NETWORK_INTERFACE_PREFIX = "nic-";
    private static final Pattern IPV4_PREFIX_REGEX;
    private static final String LB_NAME_PREFIX = "lb-";
    private static final String INBOUND_NATPOOL_PREFIX = "np-";
    private static final String VNET_DEFAULT_ADDRESS_PREFIX = "10.0.0.0/8";
    private static final int SUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH = 24;
    private static final int PROVIDER_TYPE_INDEX_IN_RESOURCEID = 6;
    private static final String AZURE_CUSTOM_SCRIPT_EXT_TYPE_LINUX = "CustomScript";
    private static final String AZURE_CUSTOM_SCRIPT_EXT_VERSION_LINUX = "2.0";
    private static final String AZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_LINUX = "Microsoft.Azure.Extensions";
    private static final String AZURE_CUSTOM_SCRIPT_EXT_TYPE_WINDOWS = "CustomScriptExtension";
    private static final String AZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_WINDOWS = "Microsoft.Compute";
    private static final String AZURE_CUSTOM_SCRIPT_EXT_VERSION_WINDOWS = "1.8";
    private static final String AZURE_HEALTH_EXT_TYPE = "ApplicationHealthWindows";
    private static final String AZURE_HEALTH_EXT_VERSION = "1.0";
    private static final String AZURE_HEALTH_EXT_PUBLISHER = "Microsoft.ManagedServices";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AzureUtilities() {
        MetaClass metaClass;
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String getResourceGroupName(AzureResourceOpsDescription description) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)description, null)) {
            return ShortTypeHandling.castToString(null);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)description), (Object)NAME_SEPARATOR), callSiteArray[3].callGroovyObjectGetProperty((Object)description)));
    }

    public static String getVirtualNetworkName(String resourceGroupName) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)resourceGroupName, null)) {
            return ShortTypeHandling.castToString(null);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[4].call((Object)VNET_NAME_PREFIX, (Object)resourceGroupName));
    }

    public static String getSubnetName(String virtualNetworkName, String addressPrefix) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareEqual((Object)virtualNetworkName, null) || ScriptBytecodeAdapter.compareEqual((Object)addressPrefix, null) : ScriptBytecodeAdapter.compareEqual((Object)virtualNetworkName, null) || ScriptBytecodeAdapter.compareEqual((Object)addressPrefix, null)) {
            return ShortTypeHandling.castToString(null);
        }
        String addressPrefixSanitized = ShortTypeHandling.castToString((Object)callSiteArray[5].call((Object)addressPrefix, (Object)"[\\./]", (Object)"_"));
        return ShortTypeHandling.castToString((Object)callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call((Object)virtualNetworkName, (Object)NAME_SEPARATOR), (Object)SUBNET_NAME_PREFIX), (Object)addressPrefixSanitized));
    }

    public static String getResourceGroupName(String appName, String region) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? ScriptBytecodeAdapter.compareEqual((Object)appName, null) || ScriptBytecodeAdapter.compareEqual((Object)region, null) : ScriptBytecodeAdapter.compareEqual((Object)appName, null) || ScriptBytecodeAdapter.compareEqual((Object)region, null)) {
            return ShortTypeHandling.castToString(null);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[9].call(callSiteArray[10].call((Object)appName, (Object)NAME_SEPARATOR), callSiteArray[11].call(callSiteArray[12].call((Object)region, (Object)" ", (Object)""))));
    }

    public static String getResourceGroupNameFromResourceId(String resourceId) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)resourceId, null)) {
            return ShortTypeHandling.castToString(null);
        }
        Object parts = callSiteArray[13].call((Object)resourceId, (Object)PATH_SEPARATOR);
        public final class _getResourceGroupNameFromResourceId_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getResourceGroupNameFromResourceId_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getResourceGroupNameFromResourceId_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getResourceGroupNameFromResourceId_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)it, (Object)"resourceGroups");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getResourceGroupNameFromResourceId_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getResourceGroupNameFromResourceId_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_getResourceGroupNameFromResourceId_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getResourceGroupNameFromResourceId_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object idx = callSiteArray[14].call(parts, (Object)new _getResourceGroupNameFromResourceId_closure1(AzureUtilities.class, AzureUtilities.class));
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)idx, (Object)0)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[15].call(parts, callSiteArray[16].call(idx, (Object)1)));
        }
        return ShortTypeHandling.castToString(null);
    }

    public static String getAppNameFromAzureResourceName(String azureResourceName) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)azureResourceName, null)) {
            return ShortTypeHandling.castToString(null);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[17].call(callSiteArray[18].call((Object)azureResourceName, (Object)NAME_SEPARATOR)));
    }

    public static String getNameFromResourceId(String resourceId) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)resourceId, null)) {
            return ShortTypeHandling.castToString(null);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[19].call(callSiteArray[20].call((Object)resourceId, (Object)PATH_SEPARATOR)));
    }

    public static String getResourceNameFromId(String id) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)id, null)) {
            return ShortTypeHandling.castToString(null);
        }
        Object vals = callSiteArray[21].call((Object)id, (Object)PATH_SEPARATOR);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[22].callGetProperty(vals), (Object)callSiteArray[23].call((Object)PROVIDER_TYPE_INDEX_IN_RESOURCEID, (Object)2))) {
                return ShortTypeHandling.castToString((Object)callSiteArray[24].call(vals, callSiteArray[25].call((Object)PROVIDER_TYPE_INDEX_IN_RESOURCEID, (Object)2)));
            }
            return ShortTypeHandling.castToString(null);
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[26].callGetProperty(vals), (Object)(PROVIDER_TYPE_INDEX_IN_RESOURCEID + 2))) {
            return ShortTypeHandling.castToString((Object)callSiteArray[27].call(vals, (Object)(PROVIDER_TYPE_INDEX_IN_RESOURCEID + 2)));
        }
        return ShortTypeHandling.castToString(null);
    }

    public static String getResourceTypeFromId(String id) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)id, null)) {
            return ShortTypeHandling.castToString(null);
        }
        Object vals = callSiteArray[28].call((Object)id, (Object)PATH_SEPARATOR);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[29].callGetProperty(vals), (Object)callSiteArray[30].call((Object)PROVIDER_TYPE_INDEX_IN_RESOURCEID, (Object)1))) {
                return ShortTypeHandling.castToString((Object)callSiteArray[31].call(vals, callSiteArray[32].call((Object)PROVIDER_TYPE_INDEX_IN_RESOURCEID, (Object)1)));
            }
            return ShortTypeHandling.castToString(null);
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[33].callGetProperty(vals), (Object)(PROVIDER_TYPE_INDEX_IN_RESOURCEID + 1))) {
            return ShortTypeHandling.castToString((Object)callSiteArray[34].call(vals, (Object)(PROVIDER_TYPE_INDEX_IN_RESOURCEID + 1)));
        }
        return ShortTypeHandling.castToString(null);
    }

    private static boolean validateIpv4PrefixMatch(Matcher matchResult) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].call((Object)matchResult))) {
            return false;
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[36].call((Object)matchResult, (Object)"length"), Integer.TYPE)) > 32 : DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[37].call((Object)matchResult, (Object)"length"), Integer.TYPE)) > 32) {
            return false;
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (i < 4) {
                if (DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[38].call((Object)matchResult, (Object)new GStringImpl(new Object[]{i}, new String[]{"addr", ""})), Integer.TYPE)) > 255) {
                    return false;
                }
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[39].call((Object)n));
            }
        } else {
            int i = 0;
            while (i < 4) {
                if (DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[40].call((Object)matchResult, (Object)new GStringImpl(new Object[]{i}, new String[]{"addr", ""})), Integer.TYPE)) > 255) {
                    return false;
                }
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
        }
        return true;
    }

    public static int convertIpv4PrefixToInt(String addrPrefix) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)addrPrefix)) {
            return -1;
        }
        Object matchResult = callSiteArray[41].call((Object)IPV4_PREFIX_REGEX, (Object)addrPrefix);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].callStatic(AzureUtilities.class, matchResult))) {
            return -1;
        }
        return DefaultTypeTransformation.intUnbox((Object)callSiteArray[43].callStatic(AzureUtilities.class, matchResult, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[44].call(matchResult, (Object)"length"), Integer.TYPE)), Integer.TYPE)));
    }

    public static int getSubnetRangeMax(String vnetAddressPrefix, int subnetAddressPrefixLength) {
        int n;
        int n2;
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)vnetAddressPrefix)) {
            return 0;
        }
        Object matchResult = callSiteArray[45].call((Object)IPV4_PREFIX_REGEX, (Object)vnetAddressPrefix);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].callStatic(AzureUtilities.class, matchResult))) {
            return 0;
        }
        int vnetAddrPrefixLength = 0;
        vnetAddrPrefixLength = !BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (n2 = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[47].call(matchResult, (Object)"length"), Integer.TYPE))) : (n = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[48].call(matchResult, (Object)"length"), Integer.TYPE)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? vnetAddrPrefixLength >= subnetAddressPrefixLength : vnetAddrPrefixLength >= subnetAddressPrefixLength) {
            return 0;
        }
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.intUnbox((Object)callSiteArray[49].call((Object)1, callSiteArray[50].call((Object)subnetAddressPrefixLength, (Object)vnetAddrPrefixLength)));
        }
        return 1 << subnetAddressPrefixLength - vnetAddrPrefixLength;
    }

    public static int getAddressPrefixLength(String addrPrefix) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)addrPrefix)) {
            return 0;
        }
        Object matchResult = callSiteArray[51].call((Object)IPV4_PREFIX_REGEX, (Object)addrPrefix);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[52].callStatic(AzureUtilities.class, matchResult))) {
            return 0;
        }
        return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[53].call(matchResult, (Object)"length"), Integer.TYPE));
    }

    public static int convertIpv4PrefixToInt(Matcher matchResult, int length) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        int lengthMask = 0;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[54].call((Object)-1, callSiteArray[55].call((Object)32, (Object)length));
            lengthMask = DefaultTypeTransformation.intUnbox((Object)object);
        } else {
            Object object = callSiteArray[56].call((Object)-1, (Object)(32 - length));
            lengthMask = DefaultTypeTransformation.intUnbox((Object)object);
        }
        int val = 0;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (i < 4) {
                val = DefaultTypeTransformation.intUnbox((Object)callSiteArray[57].call((Object)val, callSiteArray[58].call((Object)DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[59].call((Object)matchResult, (Object)new GStringImpl(new Object[]{i}, new String[]{"addr", ""})), Integer.TYPE)), callSiteArray[60].call((Object)i, (Object)8))));
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[61].call((Object)n));
            }
        } else {
            int i = 0;
            while (i < 4) {
                int cfr_ignored_0 = val | DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[62].call((Object)matchResult, (Object)new GStringImpl(new Object[]{i}, new String[]{"addr", ""})), Integer.TYPE)) << i * 8;
                int n = i;
                int cfr_ignored_1 = n + 1;
            }
        }
        val = !BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? DefaultTypeTransformation.intUnbox((Object)callSiteArray[63].call((Object)val, (Object)lengthMask)) : val & lengthMask;
        return val;
    }

    public static String convertIntToIpv4Prefix(int prefix, int length) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        int lowMask = 255;
        int[] addr = new int[4];
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[64].callGetProperty((Object)addr))) {
                Object object = callSiteArray[65].call(callSiteArray[66].call((Object)prefix, callSiteArray[67].call((Object)i, (Object)8)), (Object)lowMask);
                callSiteArray[68].call((Object)addr, (Object)i, object);
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[69].call((Object)n));
            }
        } else {
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[70].callGetProperty((Object)addr))) {
                int n = prefix >>> i * 8 & lowMask;
                BytecodeInterface8.intArraySet((int[])addr, (int)i, (int)n);
                int n2 = i;
                int cfr_ignored_0 = n2 + 1;
            }
        }
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[71].call((Object)addr, (Object)3), callSiteArray[72].call((Object)addr, (Object)2), callSiteArray[73].call((Object)addr, (Object)1), callSiteArray[74].call((Object)addr, (Object)0), length}, new String[]{"", ".", ".", ".", "/", ""}));
        }
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{BytecodeInterface8.intArrayGet((int[])addr, (int)3), BytecodeInterface8.intArrayGet((int[])addr, (int)2), BytecodeInterface8.intArrayGet((int[])addr, (int)1), BytecodeInterface8.intArrayGet((int[])addr, (int)0), length}, new String[]{"", ".", ".", ".", "/", ""}));
    }

    public static int compareIpv4AddrPrefixes(String leftAddrPrefix, String rightAddrPrefix) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        Object leftMatchResult = callSiteArray[75].call((Object)IPV4_PREFIX_REGEX, (Object)leftAddrPrefix);
        Object rightMatchResult = callSiteArray[76].call((Object)IPV4_PREFIX_REGEX, (Object)rightAddrPrefix);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[77].callStatic(AzureUtilities.class, leftMatchResult))) {
            throw (Throwable)callSiteArray[78].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{leftAddrPrefix}, new String[]{"Invalid IPv4 address prefix: ", ""}));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[79].callStatic(AzureUtilities.class, rightMatchResult))) {
            throw (Throwable)callSiteArray[80].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{rightAddrPrefix}, new String[]{"Invalid IPv4 address prefix: ", ""}));
        }
        int length = DefaultTypeTransformation.intUnbox((Object)callSiteArray[81].call(Math.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[82].call(leftMatchResult, (Object)"length"), Integer.TYPE)), Integer.TYPE), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[83].call(rightMatchResult, (Object)"length"), Integer.TYPE)), Integer.TYPE)));
        int leftNum = DefaultTypeTransformation.intUnbox((Object)callSiteArray[84].callStatic(AzureUtilities.class, leftMatchResult, (Object)length));
        int rightNum = DefaultTypeTransformation.intUnbox((Object)callSiteArray[85].callStatic(AzureUtilities.class, rightMatchResult, (Object)length));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (leftNum < 0 && rightNum >= 0) {
                return 1;
            }
            if (rightNum < 0 && leftNum >= 0) {
                return -1;
            }
            return DefaultTypeTransformation.intUnbox((Object)callSiteArray[86].call((Object)leftNum, (Object)rightNum));
        }
        if (leftNum < 0 && rightNum >= 0) {
            return 1;
        }
        if (rightNum < 0 && leftNum >= 0) {
            return -1;
        }
        return leftNum - rightNum;
    }

    public static String getNextSubnet(String vnetAddrPrefix, String subnetAddrPrefix) {
        int n;
        int n2;
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)subnetAddrPrefix)) {
            Object vnetMatchResult = callSiteArray[87].call((Object)IPV4_PREFIX_REGEX, (Object)vnetAddrPrefix);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[88].call(vnetMatchResult))) {
                int adjustedLength = 0;
                if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    Object object = callSiteArray[89].call(Math.class, callSiteArray[90].call((Object)DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[91].call(vnetMatchResult, (Object)"length"), Integer.TYPE)), (Object)8), (Object)SUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH);
                    adjustedLength = DefaultTypeTransformation.intUnbox((Object)object);
                } else {
                    Object object = callSiteArray[92].call(Math.class, (Object)(DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[93].call(vnetMatchResult, (Object)"length"), Integer.TYPE)) + 8), (Object)SUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH);
                    adjustedLength = DefaultTypeTransformation.intUnbox((Object)object);
                }
                Object object = callSiteArray[94].call((Object)vnetAddrPrefix, (Object)"/\\d+$", (Object)new GStringImpl(new Object[]{adjustedLength}, new String[]{"/", ""}));
                subnetAddrPrefix = ShortTypeHandling.castToString((Object)object);
            }
        }
        Object subnetMatchResult = callSiteArray[95].call((Object)IPV4_PREFIX_REGEX, (Object)subnetAddrPrefix);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[96].callStatic(AzureUtilities.class, subnetMatchResult))) {
            throw (Throwable)callSiteArray[97].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{subnetAddrPrefix}, new String[]{"Invalid subnet address prefix: ", ""}));
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.intUnbox((Object)callSiteArray[98].callStatic(AzureUtilities.class, (Object)subnetAddrPrefix, (Object)vnetAddrPrefix)) != 0) {
                throw (Throwable)callSiteArray[99].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{subnetAddrPrefix, vnetAddrPrefix}, new String[]{"Subnet ", " is not in vnet ", ""}));
            }
        } else if (AzureUtilities.compareIpv4AddrPrefixes(subnetAddrPrefix, vnetAddrPrefix) != 0) {
            throw (Throwable)callSiteArray[100].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{subnetAddrPrefix, vnetAddrPrefix}, new String[]{"Subnet ", " is not in vnet ", ""}));
        }
        int length = 0;
        length = !BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (n2 = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[101].call(subnetMatchResult, (Object)"length"), Integer.TYPE))) : (n = DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[102].call(subnetMatchResult, (Object)"length"), Integer.TYPE)));
        int prefix = DefaultTypeTransformation.intUnbox((Object)callSiteArray[103].callStatic(AzureUtilities.class, subnetMatchResult, (Object)length));
        prefix = !BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? DefaultTypeTransformation.intUnbox((Object)callSiteArray[104].call((Object)prefix, callSiteArray[105].call((Object)32, (Object)length))) : prefix >>> 32 - length;
        prefix = !BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? DefaultTypeTransformation.intUnbox((Object)callSiteArray[106].call((Object)prefix, (Object)1)) : prefix + 1;
        prefix = !BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? DefaultTypeTransformation.intUnbox((Object)callSiteArray[107].call((Object)prefix, callSiteArray[108].call((Object)32, (Object)length))) : prefix << 32 - length;
        String resultPrefix = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[109].callStatic(AzureUtilities.class, (Object)prefix, (Object)length);
            resultPrefix = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            resultPrefix = string = AzureUtilities.convertIntToIpv4Prefix(prefix, length);
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.intUnbox((Object)callSiteArray[110].callStatic(AzureUtilities.class, (Object)subnetAddrPrefix, (Object)resultPrefix)) >= 0) {
                throw (Throwable)callSiteArray[111].callConstructor(ArithmeticException.class, (Object)new GStringImpl(new Object[]{subnetAddrPrefix}, new String[]{"Overflow occurred getting next valid subnet after ", ""}));
            }
        } else if (AzureUtilities.compareIpv4AddrPrefixes(subnetAddrPrefix, resultPrefix) >= 0) {
            throw (Throwable)callSiteArray[112].callConstructor(ArithmeticException.class, (Object)new GStringImpl(new Object[]{subnetAddrPrefix}, new String[]{"Overflow occurred getting next valid subnet after ", ""}));
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.intUnbox((Object)callSiteArray[113].callStatic(AzureUtilities.class, (Object)resultPrefix, (Object)vnetAddrPrefix)) != 0) {
                throw (Throwable)callSiteArray[114].callConstructor(ArithmeticException.class, (Object)new GStringImpl(new Object[]{subnetAddrPrefix, vnetAddrPrefix}, new String[]{"Overflow occurred getting next valid subnet after ", " within vnet ", ""}));
            }
        } else if (AzureUtilities.compareIpv4AddrPrefixes(resultPrefix, vnetAddrPrefix) != 0) {
            throw (Throwable)callSiteArray[115].callConstructor(ArithmeticException.class, (Object)new GStringImpl(new Object[]{subnetAddrPrefix, vnetAddrPrefix}, new String[]{"Overflow occurred getting next valid subnet after ", " within vnet ", ""}));
        }
        return resultPrefix;
    }

    public static String convertParametersToTemplateJSON(ObjectMapper mapper, Map<String, Object> sourceParameters) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        Map map = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[116].callConstructor(HashMap.class), Map.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[117].call(sourceParameters), (Object)0)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[118].call((Object)mapper, sourceParameters));
        }
        Map.Entry entry = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[119].call(callSiteArray[120].call(sourceParameters)), Iterator.class);
        while (iterator.hasNext()) {
            entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[121].callGetProperty((Object)entry))) continue;
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[122].callGetProperty(callSiteArray[123].callGetProperty((Object)entry)), String.class)) {
                callSiteArray[124].call((Object)map, callSiteArray[125].callGetProperty((Object)entry), callSiteArray[126].callConstructor(ValueParameter.class, callSiteArray[127].callGetProperty((Object)entry)));
                continue;
            }
            callSiteArray[128].call((Object)map, callSiteArray[129].callGetProperty((Object)entry), callSiteArray[130].callConstructor(ReferenceParameter.class, callSiteArray[131].callGetProperty((Object)entry)));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[132].call((Object)mapper, (Object)map));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureUtilities.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AzureUtilities.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AzureUtilities.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AzureUtilities.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    public static int getSubnetRangeMax(String vnetAddressPrefix) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return AzureUtilities.getSubnetRangeMax(vnetAddressPrefix, SUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH);
        }
        return AzureUtilities.getSubnetRangeMax(vnetAddressPrefix, SUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH);
    }

    @Generated
    public static String getNextSubnet(String vnetAddrPrefix) {
        CallSite[] callSiteArray = AzureUtilities.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return AzureUtilities.getNextSubnet(vnetAddrPrefix, null);
        }
        return AzureUtilities.getNextSubnet(vnetAddrPrefix, null);
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        String string2;
        NAME_SEPARATOR = string2 = "-";
        PATH_SEPARATOR = string = "/";
        Object object = ScriptBytecodeAdapter.bitwiseNegate((Object)"^(?<addr3>\\d+)\\.(?<addr2>\\d+)\\.(?<addr1>\\d+)\\.(?<addr0>\\d+)/(?<length>\\d+)$");
        IPV4_PREFIX_REGEX = (Pattern)ScriptBytecodeAdapter.castToType((Object)object, Pattern.class);
    }

    @Generated
    public static String getPATH_SEPARATOR() {
        return PATH_SEPARATOR;
    }

    @Generated
    public static String getNAME_SEPARATOR() {
        return NAME_SEPARATOR;
    }

    @Generated
    public static String getVNET_NAME_PREFIX() {
        return VNET_NAME_PREFIX;
    }

    @Generated
    public static String getSUBNET_NAME_PREFIX() {
        return SUBNET_NAME_PREFIX;
    }

    @Generated
    public static String getPUBLICIP_NAME_PREFIX() {
        return PUBLICIP_NAME_PREFIX;
    }

    @Generated
    public static String getLBFRONTEND_NAME_PREFIX() {
        return LBFRONTEND_NAME_PREFIX;
    }

    @Generated
    public static String getLBBACKEND_NAME_PREFIX() {
        return LBBACKEND_NAME_PREFIX;
    }

    @Generated
    public static String getDNS_NAME_PREFIX() {
        return DNS_NAME_PREFIX;
    }

    @Generated
    public static String getIPCONFIG_NAME_PREFIX() {
        return IPCONFIG_NAME_PREFIX;
    }

    @Generated
    public static String getNETWORK_INTERFACE_PREFIX() {
        return NETWORK_INTERFACE_PREFIX;
    }

    @Generated
    public static Pattern getIPV4_PREFIX_REGEX() {
        return IPV4_PREFIX_REGEX;
    }

    @Generated
    public static String getLB_NAME_PREFIX() {
        return LB_NAME_PREFIX;
    }

    @Generated
    public static String getINBOUND_NATPOOL_PREFIX() {
        return INBOUND_NATPOOL_PREFIX;
    }

    @Generated
    public static String getVNET_DEFAULT_ADDRESS_PREFIX() {
        return VNET_DEFAULT_ADDRESS_PREFIX;
    }

    @Generated
    public static int getSUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH() {
        return SUBNET_DEFAULT_ADDRESS_PREFIX_LENGTH;
    }

    @Generated
    public static int getPROVIDER_TYPE_INDEX_IN_RESOURCEID() {
        return PROVIDER_TYPE_INDEX_IN_RESOURCEID;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_TYPE_LINUX() {
        return AZURE_CUSTOM_SCRIPT_EXT_TYPE_LINUX;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_VERSION_LINUX() {
        return AZURE_CUSTOM_SCRIPT_EXT_VERSION_LINUX;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_LINUX() {
        return AZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_LINUX;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_TYPE_WINDOWS() {
        return AZURE_CUSTOM_SCRIPT_EXT_TYPE_WINDOWS;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_WINDOWS() {
        return AZURE_CUSTOM_SCRIPT_EXT_PUBLISHER_WINDOWS;
    }

    @Generated
    public static String getAZURE_CUSTOM_SCRIPT_EXT_VERSION_WINDOWS() {
        return AZURE_CUSTOM_SCRIPT_EXT_VERSION_WINDOWS;
    }

    @Generated
    public static String getAZURE_HEALTH_EXT_TYPE() {
        return AZURE_HEALTH_EXT_TYPE;
    }

    @Generated
    public static String getAZURE_HEALTH_EXT_VERSION() {
        return AZURE_HEALTH_EXT_VERSION;
    }

    @Generated
    public static String getAZURE_HEALTH_EXT_PUBLISHER() {
        return AZURE_HEALTH_EXT_PUBLISHER;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "plus";
        stringArray[1] = "plus";
        stringArray[2] = "appName";
        stringArray[3] = "region";
        stringArray[4] = "plus";
        stringArray[5] = "replaceAll";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "toLowerCase";
        stringArray[12] = "replace";
        stringArray[13] = "split";
        stringArray[14] = "findIndexOf";
        stringArray[15] = "getAt";
        stringArray[16] = "plus";
        stringArray[17] = "first";
        stringArray[18] = "split";
        stringArray[19] = "last";
        stringArray[20] = "split";
        stringArray[21] = "split";
        stringArray[22] = "length";
        stringArray[23] = "plus";
        stringArray[24] = "getAt";
        stringArray[25] = "plus";
        stringArray[26] = "length";
        stringArray[27] = "getAt";
        stringArray[28] = "split";
        stringArray[29] = "length";
        stringArray[30] = "plus";
        stringArray[31] = "getAt";
        stringArray[32] = "plus";
        stringArray[33] = "length";
        stringArray[34] = "getAt";
        stringArray[35] = "matches";
        stringArray[36] = "group";
        stringArray[37] = "group";
        stringArray[38] = "group";
        stringArray[39] = "next";
        stringArray[40] = "group";
        stringArray[41] = "matcher";
        stringArray[42] = "validateIpv4PrefixMatch";
        stringArray[43] = "convertIpv4PrefixToInt";
        stringArray[44] = "group";
        stringArray[45] = "matcher";
        stringArray[46] = "validateIpv4PrefixMatch";
        stringArray[47] = "group";
        stringArray[48] = "group";
        stringArray[49] = "leftShift";
        stringArray[50] = "minus";
        stringArray[51] = "matcher";
        stringArray[52] = "validateIpv4PrefixMatch";
        stringArray[53] = "group";
        stringArray[54] = "leftShift";
        stringArray[55] = "minus";
        stringArray[56] = "leftShift";
        stringArray[57] = "or";
        stringArray[58] = "leftShift";
        stringArray[59] = "group";
        stringArray[60] = "multiply";
        stringArray[61] = "next";
        stringArray[62] = "group";
        stringArray[63] = "and";
        stringArray[64] = "length";
        stringArray[65] = "and";
        stringArray[66] = "rightShiftUnsigned";
        stringArray[67] = "multiply";
        stringArray[68] = "putAt";
        stringArray[69] = "next";
        stringArray[70] = "length";
        stringArray[71] = "getAt";
        stringArray[72] = "getAt";
        stringArray[73] = "getAt";
        stringArray[74] = "getAt";
        stringArray[75] = "matcher";
        stringArray[76] = "matcher";
        stringArray[77] = "validateIpv4PrefixMatch";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "validateIpv4PrefixMatch";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "min";
        stringArray[82] = "group";
        stringArray[83] = "group";
        stringArray[84] = "convertIpv4PrefixToInt";
        stringArray[85] = "convertIpv4PrefixToInt";
        stringArray[86] = "minus";
        stringArray[87] = "matcher";
        stringArray[88] = "matches";
        stringArray[89] = "max";
        stringArray[90] = "plus";
        stringArray[91] = "group";
        stringArray[92] = "max";
        stringArray[93] = "group";
        stringArray[94] = "replaceAll";
        stringArray[95] = "matcher";
        stringArray[96] = "validateIpv4PrefixMatch";
        stringArray[97] = "<$constructor$>";
        stringArray[98] = "compareIpv4AddrPrefixes";
        stringArray[99] = "<$constructor$>";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "group";
        stringArray[102] = "group";
        stringArray[103] = "convertIpv4PrefixToInt";
        stringArray[104] = "rightShiftUnsigned";
        stringArray[105] = "minus";
        stringArray[106] = "plus";
        stringArray[107] = "leftShift";
        stringArray[108] = "minus";
        stringArray[109] = "convertIntToIpv4Prefix";
        stringArray[110] = "compareIpv4AddrPrefixes";
        stringArray[111] = "<$constructor$>";
        stringArray[112] = "<$constructor$>";
        stringArray[113] = "compareIpv4AddrPrefixes";
        stringArray[114] = "<$constructor$>";
        stringArray[115] = "<$constructor$>";
        stringArray[116] = "<$constructor$>";
        stringArray[117] = "size";
        stringArray[118] = "writeValueAsString";
        stringArray[119] = "iterator";
        stringArray[120] = "entrySet";
        stringArray[121] = "value";
        stringArray[122] = "class";
        stringArray[123] = "value";
        stringArray[124] = "put";
        stringArray[125] = "key";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "value";
        stringArray[128] = "put";
        stringArray[129] = "key";
        stringArray[130] = "<$constructor$>";
        stringArray[131] = "value";
        stringArray[132] = "writeValueAsString";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[133];
        AzureUtilities.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AzureUtilities.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AzureUtilities.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class ValueParameter
    implements GroovyObject {
        private Object value;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ValueParameter(Object value) {
            Object object;
            MetaClass metaClass;
            CallSite[] callSiteArray = ValueParameter.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.value = object = value;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ValueParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ValueParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ValueParameter.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ValueParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ValueParameter.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ValueParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ValueParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ValueParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ValueParameter.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ValueParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ValueParameter.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Object getValue() {
            return this.value;
        }

        @Generated
        public void setValue(Object object) {
            this.value = object;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(ValueParameter.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ValueParameter.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ReferenceParameter
    implements GroovyObject {
        private Object reference;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ReferenceParameter(Object reference) {
            Object object;
            MetaClass metaClass;
            CallSite[] callSiteArray = ReferenceParameter.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.reference = object = reference;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ReferenceParameter.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ReferenceParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ReferenceParameter.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ReferenceParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ReferenceParameter.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ReferenceParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ReferenceParameter.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ReferenceParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ReferenceParameter.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ReferenceParameter.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ReferenceParameter.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public Object getReference() {
            return this.reference;
        }

        @Generated
        public void setReference(Object object) {
            this.reference = object;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(ReferenceParameter.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ReferenceParameter.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ProvisioningState
    implements GroovyObject {
        public static final String SUCCEEDED = "Succeeded";
        public static final String FAILED = "Failed";
        public static final String CANCELED = "Canceled";
        public static final String READY = "Ready";
        public static final String DELETED = "Deleted";
        public static final String ACCEPTED = "Accepted";
        public static final String DEPLOYING = "Deploying";
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public ProvisioningState() {
            MetaClass metaClass;
            CallSite[] callSiteArray = ProvisioningState.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ProvisioningState.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ProvisioningState.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ProvisioningState.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ProvisioningState.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ProvisioningState.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ProvisioningState.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ProvisioningState.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ProvisioningState.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ProvisioningState.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ProvisioningState.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ProvisioningState.class, AzureUtilities.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(ProvisioningState.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ProvisioningState.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

