/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.netflix.spinnaker.echo.model.Trigger;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.kork.artifacts.model.ExpectedArtifact;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

@JsonDeserialize(builder=PipelineBuilder.class)
public final class Pipeline {
    @JsonProperty
    @NonNull
    private final String application;
    private final Object config;
    @JsonProperty
    @NonNull
    private final String name;
    @JsonProperty
    private final String id;
    @JsonProperty
    private final String executionId;
    @JsonProperty
    private final String executionEngine;
    @JsonProperty
    private final String spelEvaluator;
    @JsonProperty
    private final boolean parallel;
    @JsonProperty
    private final boolean disabled;
    @JsonProperty
    private final boolean limitConcurrent;
    @JsonProperty
    private final int maxConcurrentExecutions;
    @JsonProperty
    private final boolean keepWaitingPipelines;
    @JsonProperty
    private final boolean plan;
    @JsonProperty
    private final boolean respectQuietPeriod;
    @JsonProperty
    private final List<Trigger> triggers;
    @JsonProperty
    private final String type;
    @JsonProperty
    private final String schema;
    @JsonProperty
    private final Object template;
    @JsonProperty
    private final Map<String, Object> templateVariables;
    @JsonProperty
    private final List<Map<String, Object>> stages;
    @JsonProperty
    private final List<Map<String, Object>> notifications;
    @JsonProperty
    private final List<Artifact> receivedArtifacts;
    @JsonProperty
    private final List<ExpectedArtifact> expectedArtifacts;
    @JsonProperty
    private final List<Map<String, Object>> parameterConfig;
    @JsonProperty
    private final Object appConfig;
    @JsonProperty
    private final String errorMessage;
    @JsonProperty
    private final Map<String, String> source;
    private final Trigger trigger;

    Pipeline(@NonNull String application, Object config, @NonNull String name, String id, String executionId, String executionEngine, String spelEvaluator, boolean parallel, boolean disabled, boolean limitConcurrent, int maxConcurrentExecutions, boolean keepWaitingPipelines, boolean plan, boolean respectQuietPeriod, List<Trigger> triggers, String type, String schema, Object template, Map<String, Object> templateVariables, List<Map<String, Object>> stages, List<Map<String, Object>> notifications, List<Artifact> receivedArtifacts, List<ExpectedArtifact> expectedArtifacts, List<Map<String, Object>> parameterConfig, Object appConfig, String errorMessage, Map<String, String> source, Trigger trigger) {
        if (application == null) {
            throw new NullPointerException("application is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.application = application;
        this.config = config;
        this.name = name;
        this.id = id;
        this.executionId = executionId;
        this.executionEngine = executionEngine;
        this.spelEvaluator = spelEvaluator;
        this.parallel = parallel;
        this.disabled = disabled;
        this.limitConcurrent = limitConcurrent;
        this.maxConcurrentExecutions = maxConcurrentExecutions;
        this.keepWaitingPipelines = keepWaitingPipelines;
        this.plan = plan;
        this.respectQuietPeriod = respectQuietPeriod;
        this.triggers = triggers;
        this.type = type;
        this.schema = schema;
        this.template = template;
        this.templateVariables = templateVariables;
        this.stages = stages;
        this.notifications = notifications;
        this.receivedArtifacts = receivedArtifacts;
        this.expectedArtifacts = expectedArtifacts;
        this.parameterConfig = parameterConfig;
        this.appConfig = appConfig;
        this.errorMessage = errorMessage;
        this.source = source;
        this.trigger = trigger;
    }

    public static PipelineBuilder builder() {
        return new PipelineBuilder();
    }

    @NonNull
    public String getApplication() {
        return this.application;
    }

    public Object getConfig() {
        return this.config;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getExecutionEngine() {
        return this.executionEngine;
    }

    public String getSpelEvaluator() {
        return this.spelEvaluator;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isLimitConcurrent() {
        return this.limitConcurrent;
    }

    public int getMaxConcurrentExecutions() {
        return this.maxConcurrentExecutions;
    }

    public boolean isKeepWaitingPipelines() {
        return this.keepWaitingPipelines;
    }

    public boolean isPlan() {
        return this.plan;
    }

    public boolean isRespectQuietPeriod() {
        return this.respectQuietPeriod;
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public String getType() {
        return this.type;
    }

    public String getSchema() {
        return this.schema;
    }

    public Object getTemplate() {
        return this.template;
    }

    public Map<String, Object> getTemplateVariables() {
        return this.templateVariables;
    }

    public List<Map<String, Object>> getStages() {
        return this.stages;
    }

    public List<Map<String, Object>> getNotifications() {
        return this.notifications;
    }

    public List<Artifact> getReceivedArtifacts() {
        return this.receivedArtifacts;
    }

    public List<ExpectedArtifact> getExpectedArtifacts() {
        return this.expectedArtifacts;
    }

    public List<Map<String, Object>> getParameterConfig() {
        return this.parameterConfig;
    }

    public Object getAppConfig() {
        return this.appConfig;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Map<String, String> getSource() {
        return this.source;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pipeline)) {
            return false;
        }
        Pipeline other = (Pipeline)o;
        if (this.isParallel() != other.isParallel()) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        if (this.isLimitConcurrent() != other.isLimitConcurrent()) {
            return false;
        }
        if (this.getMaxConcurrentExecutions() != other.getMaxConcurrentExecutions()) {
            return false;
        }
        if (this.isKeepWaitingPipelines() != other.isKeepWaitingPipelines()) {
            return false;
        }
        if (this.isPlan() != other.isPlan()) {
            return false;
        }
        if (this.isRespectQuietPeriod() != other.isRespectQuietPeriod()) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        Object this$config = this.getConfig();
        Object other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$executionEngine = this.getExecutionEngine();
        String other$executionEngine = other.getExecutionEngine();
        if (this$executionEngine == null ? other$executionEngine != null : !this$executionEngine.equals(other$executionEngine)) {
            return false;
        }
        String this$spelEvaluator = this.getSpelEvaluator();
        String other$spelEvaluator = other.getSpelEvaluator();
        if (this$spelEvaluator == null ? other$spelEvaluator != null : !this$spelEvaluator.equals(other$spelEvaluator)) {
            return false;
        }
        List<Trigger> this$triggers = this.getTriggers();
        List<Trigger> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        Object this$template = this.getTemplate();
        Object other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        Map<String, Object> this$templateVariables = this.getTemplateVariables();
        Map<String, Object> other$templateVariables = other.getTemplateVariables();
        if (this$templateVariables == null ? other$templateVariables != null : !((Object)this$templateVariables).equals(other$templateVariables)) {
            return false;
        }
        List<Map<String, Object>> this$stages = this.getStages();
        List<Map<String, Object>> other$stages = other.getStages();
        if (this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages)) {
            return false;
        }
        List<Map<String, Object>> this$notifications = this.getNotifications();
        List<Map<String, Object>> other$notifications = other.getNotifications();
        if (this$notifications == null ? other$notifications != null : !((Object)this$notifications).equals(other$notifications)) {
            return false;
        }
        List<Artifact> this$receivedArtifacts = this.getReceivedArtifacts();
        List<Artifact> other$receivedArtifacts = other.getReceivedArtifacts();
        if (this$receivedArtifacts == null ? other$receivedArtifacts != null : !((Object)this$receivedArtifacts).equals(other$receivedArtifacts)) {
            return false;
        }
        List<ExpectedArtifact> this$expectedArtifacts = this.getExpectedArtifacts();
        List<ExpectedArtifact> other$expectedArtifacts = other.getExpectedArtifacts();
        if (this$expectedArtifacts == null ? other$expectedArtifacts != null : !((Object)this$expectedArtifacts).equals(other$expectedArtifacts)) {
            return false;
        }
        List<Map<String, Object>> this$parameterConfig = this.getParameterConfig();
        List<Map<String, Object>> other$parameterConfig = other.getParameterConfig();
        if (this$parameterConfig == null ? other$parameterConfig != null : !((Object)this$parameterConfig).equals(other$parameterConfig)) {
            return false;
        }
        Object this$appConfig = this.getAppConfig();
        Object other$appConfig = other.getAppConfig();
        if (this$appConfig == null ? other$appConfig != null : !this$appConfig.equals(other$appConfig)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        Map<String, String> this$source = this.getSource();
        Map<String, String> other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Trigger this$trigger = this.getTrigger();
        Trigger other$trigger = other.getTrigger();
        return !(this$trigger == null ? other$trigger != null : !((Object)this$trigger).equals(other$trigger));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isParallel() ? 79 : 97);
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        result = result * 59 + (this.isLimitConcurrent() ? 79 : 97);
        result = result * 59 + this.getMaxConcurrentExecutions();
        result = result * 59 + (this.isKeepWaitingPipelines() ? 79 : 97);
        result = result * 59 + (this.isPlan() ? 79 : 97);
        result = result * 59 + (this.isRespectQuietPeriod() ? 79 : 97);
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        Object $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $executionEngine = this.getExecutionEngine();
        result = result * 59 + ($executionEngine == null ? 43 : $executionEngine.hashCode());
        String $spelEvaluator = this.getSpelEvaluator();
        result = result * 59 + ($spelEvaluator == null ? 43 : $spelEvaluator.hashCode());
        List<Trigger> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        Object $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        Map<String, Object> $templateVariables = this.getTemplateVariables();
        result = result * 59 + ($templateVariables == null ? 43 : ((Object)$templateVariables).hashCode());
        List<Map<String, Object>> $stages = this.getStages();
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        List<Map<String, Object>> $notifications = this.getNotifications();
        result = result * 59 + ($notifications == null ? 43 : ((Object)$notifications).hashCode());
        List<Artifact> $receivedArtifacts = this.getReceivedArtifacts();
        result = result * 59 + ($receivedArtifacts == null ? 43 : ((Object)$receivedArtifacts).hashCode());
        List<ExpectedArtifact> $expectedArtifacts = this.getExpectedArtifacts();
        result = result * 59 + ($expectedArtifacts == null ? 43 : ((Object)$expectedArtifacts).hashCode());
        List<Map<String, Object>> $parameterConfig = this.getParameterConfig();
        result = result * 59 + ($parameterConfig == null ? 43 : ((Object)$parameterConfig).hashCode());
        Object $appConfig = this.getAppConfig();
        result = result * 59 + ($appConfig == null ? 43 : $appConfig.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        Map<String, String> $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Trigger $trigger = this.getTrigger();
        result = result * 59 + ($trigger == null ? 43 : ((Object)$trigger).hashCode());
        return result;
    }

    public Pipeline withApplication(@NonNull String application) {
        if (application == null) {
            throw new NullPointerException("application is marked non-null but is null");
        }
        return this.application == application ? this : new Pipeline(application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withConfig(Object config) {
        return this.config == config ? this : new Pipeline(this.application, config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new Pipeline(this.application, this.config, name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withId(String id) {
        return this.id == id ? this : new Pipeline(this.application, this.config, this.name, id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withExecutionId(String executionId) {
        return this.executionId == executionId ? this : new Pipeline(this.application, this.config, this.name, this.id, executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withExecutionEngine(String executionEngine) {
        return this.executionEngine == executionEngine ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withSpelEvaluator(String spelEvaluator) {
        return this.spelEvaluator == spelEvaluator ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withParallel(boolean parallel) {
        return this.parallel == parallel ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withDisabled(boolean disabled) {
        return this.disabled == disabled ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withLimitConcurrent(boolean limitConcurrent) {
        return this.limitConcurrent == limitConcurrent ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withMaxConcurrentExecutions(int maxConcurrentExecutions) {
        return this.maxConcurrentExecutions == maxConcurrentExecutions ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withKeepWaitingPipelines(boolean keepWaitingPipelines) {
        return this.keepWaitingPipelines == keepWaitingPipelines ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withPlan(boolean plan) {
        return this.plan == plan ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withRespectQuietPeriod(boolean respectQuietPeriod) {
        return this.respectQuietPeriod == respectQuietPeriod ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withTriggers(List<Trigger> triggers) {
        return this.triggers == triggers ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withType(String type) {
        return this.type == type ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withSchema(String schema) {
        return this.schema == schema ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withTemplate(Object template) {
        return this.template == template ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withTemplateVariables(Map<String, Object> templateVariables) {
        return this.templateVariables == templateVariables ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withStages(List<Map<String, Object>> stages) {
        return this.stages == stages ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withNotifications(List<Map<String, Object>> notifications) {
        return this.notifications == notifications ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withReceivedArtifacts(List<Artifact> receivedArtifacts) {
        return this.receivedArtifacts == receivedArtifacts ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withExpectedArtifacts(List<ExpectedArtifact> expectedArtifacts) {
        return this.expectedArtifacts == expectedArtifacts ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withParameterConfig(List<Map<String, Object>> parameterConfig) {
        return this.parameterConfig == parameterConfig ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withAppConfig(Object appConfig) {
        return this.appConfig == appConfig ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, appConfig, this.errorMessage, this.source, this.trigger);
    }

    public Pipeline withErrorMessage(String errorMessage) {
        return this.errorMessage == errorMessage ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, errorMessage, this.source, this.trigger);
    }

    public Pipeline withSource(Map<String, String> source) {
        return this.source == source ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, source, this.trigger);
    }

    public Pipeline withTrigger(Trigger trigger) {
        return this.trigger == trigger ? this : new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, trigger);
    }

    public String toString() {
        return "Pipeline(" + this.getApplication() + ", " + this.getName() + ", " + this.getId() + ")";
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class PipelineBuilder {
        private String application;
        private Object config;
        private String name;
        private String id;
        private String executionId;
        private String executionEngine;
        private String spelEvaluator;
        private boolean parallel;
        private boolean disabled;
        private boolean limitConcurrent;
        private int maxConcurrentExecutions;
        private boolean keepWaitingPipelines;
        private boolean plan;
        private boolean respectQuietPeriod;
        private List<Trigger> triggers;
        private String type;
        private String schema;
        private Object template;
        private Map<String, Object> templateVariables;
        private List<Map<String, Object>> stages;
        private List<Map<String, Object>> notifications;
        private List<Artifact> receivedArtifacts;
        private List<ExpectedArtifact> expectedArtifacts;
        private List<Map<String, Object>> parameterConfig;
        private Object appConfig;
        private String errorMessage;
        private Map<String, String> source;
        private Trigger trigger;

        @JsonProperty(value="config")
        private void setConfig(Map<String, Object> config) {
            if (config != null) {
                this.config = config;
                this.schema = (String)config.get("schema");
            }
        }

        @JsonProperty
        Object getConfig() {
            return this.config;
        }

        PipelineBuilder() {
        }

        @JsonProperty
        public PipelineBuilder application(@NonNull String application) {
            if (application == null) {
                throw new NullPointerException("application is marked non-null but is null");
            }
            this.application = application;
            return this;
        }

        public PipelineBuilder config(Object config) {
            this.config = config;
            return this;
        }

        @JsonProperty
        public PipelineBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @JsonProperty
        public PipelineBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        public PipelineBuilder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        @JsonProperty
        public PipelineBuilder executionEngine(String executionEngine) {
            this.executionEngine = executionEngine;
            return this;
        }

        @JsonProperty
        public PipelineBuilder spelEvaluator(String spelEvaluator) {
            this.spelEvaluator = spelEvaluator;
            return this;
        }

        @JsonProperty
        public PipelineBuilder parallel(boolean parallel) {
            this.parallel = parallel;
            return this;
        }

        @JsonProperty
        public PipelineBuilder disabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @JsonProperty
        public PipelineBuilder limitConcurrent(boolean limitConcurrent) {
            this.limitConcurrent = limitConcurrent;
            return this;
        }

        @JsonProperty
        public PipelineBuilder maxConcurrentExecutions(int maxConcurrentExecutions) {
            this.maxConcurrentExecutions = maxConcurrentExecutions;
            return this;
        }

        @JsonProperty
        public PipelineBuilder keepWaitingPipelines(boolean keepWaitingPipelines) {
            this.keepWaitingPipelines = keepWaitingPipelines;
            return this;
        }

        @JsonProperty
        public PipelineBuilder plan(boolean plan) {
            this.plan = plan;
            return this;
        }

        @JsonProperty
        public PipelineBuilder respectQuietPeriod(boolean respectQuietPeriod) {
            this.respectQuietPeriod = respectQuietPeriod;
            return this;
        }

        @JsonProperty
        public PipelineBuilder triggers(List<Trigger> triggers) {
            this.triggers = triggers;
            return this;
        }

        @JsonProperty
        public PipelineBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty
        public PipelineBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @JsonProperty
        public PipelineBuilder template(Object template) {
            this.template = template;
            return this;
        }

        @JsonProperty
        public PipelineBuilder templateVariables(Map<String, Object> templateVariables) {
            this.templateVariables = templateVariables;
            return this;
        }

        @JsonProperty
        public PipelineBuilder stages(List<Map<String, Object>> stages) {
            this.stages = stages;
            return this;
        }

        @JsonProperty
        public PipelineBuilder notifications(List<Map<String, Object>> notifications) {
            this.notifications = notifications;
            return this;
        }

        @JsonProperty
        public PipelineBuilder receivedArtifacts(List<Artifact> receivedArtifacts) {
            this.receivedArtifacts = receivedArtifacts;
            return this;
        }

        @JsonProperty
        public PipelineBuilder expectedArtifacts(List<ExpectedArtifact> expectedArtifacts) {
            this.expectedArtifacts = expectedArtifacts;
            return this;
        }

        @JsonProperty
        public PipelineBuilder parameterConfig(List<Map<String, Object>> parameterConfig) {
            this.parameterConfig = parameterConfig;
            return this;
        }

        @JsonProperty
        public PipelineBuilder appConfig(Object appConfig) {
            this.appConfig = appConfig;
            return this;
        }

        @JsonProperty
        public PipelineBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @JsonProperty
        public PipelineBuilder source(Map<String, String> source) {
            this.source = source;
            return this;
        }

        public PipelineBuilder trigger(Trigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public Pipeline build() {
            return new Pipeline(this.application, this.config, this.name, this.id, this.executionId, this.executionEngine, this.spelEvaluator, this.parallel, this.disabled, this.limitConcurrent, this.maxConcurrentExecutions, this.keepWaitingPipelines, this.plan, this.respectQuietPeriod, this.triggers, this.type, this.schema, this.template, this.templateVariables, this.stages, this.notifications, this.receivedArtifacts, this.expectedArtifacts, this.parameterConfig, this.appConfig, this.errorMessage, this.source, this.trigger);
        }

        public String toString() {
            return "Pipeline.PipelineBuilder(application=" + this.application + ", config=" + this.config + ", name=" + this.name + ", id=" + this.id + ", executionId=" + this.executionId + ", executionEngine=" + this.executionEngine + ", spelEvaluator=" + this.spelEvaluator + ", parallel=" + this.parallel + ", disabled=" + this.disabled + ", limitConcurrent=" + this.limitConcurrent + ", maxConcurrentExecutions=" + this.maxConcurrentExecutions + ", keepWaitingPipelines=" + this.keepWaitingPipelines + ", plan=" + this.plan + ", respectQuietPeriod=" + this.respectQuietPeriod + ", triggers=" + this.triggers + ", type=" + this.type + ", schema=" + this.schema + ", template=" + this.template + ", templateVariables=" + this.templateVariables + ", stages=" + this.stages + ", notifications=" + this.notifications + ", receivedArtifacts=" + this.receivedArtifacts + ", expectedArtifacts=" + this.expectedArtifacts + ", parameterConfig=" + this.parameterConfig + ", appConfig=" + this.appConfig + ", errorMessage=" + this.errorMessage + ", source=" + this.source + ", trigger=" + this.trigger + ")";
        }
    }
}

