/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.netflix.spinnaker.echo.model.Pipeline;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=TriggerBuilder.class)
public final class Trigger {
    private static final Logger log = LoggerFactory.getLogger(Trigger.class);
    private final String id;
    private final String type;
    private final boolean enabled;
    private final String parentPipelineId;
    private final String parentPipelineApplication;
    private final String application;
    private final String pipeline;
    private final String correlationId;
    private final String executionId;
    private final String project;
    private final String slug;
    private final String source;
    private final String branch;
    private final List<String> events;
    private final String master;
    private final String job;
    private final String propertyFile;
    private final String cronExpression;
    private final String subscriptionName;
    private final String pubsubSystem;
    private final String account;
    private final String organization;
    private final String registry;
    private final String repository;
    private final String tag;
    private final Map payloadConstraints;
    private final Map attributeConstraints;
    private final List<String> status;
    private final String user;
    private final String artifactorySearchName;
    private final String nexusSearchName;
    private final List<String> expectedArtifactIds;
    private final String pluginEventType;
    private final String pluginId;
    private final String description;
    private final String provider;
    private final String version;
    private final String releaseDate;
    private final String requires;
    private final List<Map<String, String>> parsedRequires;
    private final String binaryUrl;
    private final String sha512sum;
    private final boolean preferred;
    private final String artifactName;
    private final Integer buildNumber;
    private final String hash;
    private final Map<String, Object> buildInfo;
    private final Map<String, Object> properties;
    private final Map parameters;
    private final Map payload;
    private final String runAsUser;
    private final String secret;
    private final String digest;
    private final String action;
    private final boolean rebake;
    private final boolean dryRun;
    private final List<Map<String, Object>> notifications;
    private final List<Map<String, Object>> artifacts;
    private final String eventId;
    private final Map<String, ?> lastSuccessfulExecution;
    private final String link;
    private final String linkText;
    @JsonIgnore
    private final Pipeline parent;
    @JsonIgnore
    private final boolean propagateAuth;

    public String generateFallbackId() {
        return UUID.nameUUIDFromBytes(this.toString().getBytes()).toString();
    }

    public Trigger atBuildNumber(int buildNumber) {
        return this.toBuilder().buildNumber(buildNumber).hash(null).tag(null).build();
    }

    public Trigger atHash(String hash) {
        return this.toBuilder().buildNumber(null).hash(hash).tag(null).build();
    }

    public Trigger atBranch(String branch) {
        return this.toBuilder().buildNumber(null).tag(null).branch(branch).build();
    }

    public Trigger atTag(String tag) {
        return this.toBuilder().buildNumber(null).hash(null).tag(tag).build();
    }

    public Trigger atTag(String tag, String digest) {
        return this.toBuilder().buildNumber(null).hash(null).tag(tag).digest(digest).build();
    }

    public Trigger atPayload(Map payload) {
        return this.toBuilder().payload(payload).build();
    }

    public Trigger atParameters(Map parameters) {
        return this.toBuilder().parameters(parameters).build();
    }

    public Trigger atSecret(String secret) {
        return this.toBuilder().buildNumber(null).hash(null).digest(null).secret(secret).build();
    }

    public Trigger atMessageDescription(String subscriptionName, String pubsubSystem) {
        return this.toBuilder().subscriptionName(subscriptionName).pubsubSystem(pubsubSystem).build();
    }

    public Trigger atEventId(String eventId) {
        return this.toBuilder().eventId(eventId).build();
    }

    public Trigger atCorrelationId(String correlationId) {
        return this.toBuilder().correlationId(correlationId).build();
    }

    public Trigger atExecutionId(String executionId) {
        return this.toBuilder().executionId(executionId).build();
    }

    public Trigger atNotifications(List<Map<String, Object>> notifications) {
        return this.toBuilder().notifications(notifications).build();
    }

    public Trigger atPropagateAuth(boolean propagateAuth) {
        return this.toBuilder().propagateAuth(propagateAuth).build();
    }

    public Trigger atArtifactorySearchName(String artifactorySearchName) {
        return this.toBuilder().artifactorySearchName(artifactorySearchName).build();
    }

    public Trigger atNexusSearchName(String nexusSearchName) {
        return this.toBuilder().nexusSearchName(nexusSearchName).build();
    }

    public Trigger atAction(String action) {
        return this.toBuilder().action(action).build();
    }

    private static boolean $default$rebake() {
        return false;
    }

    private static boolean $default$dryRun() {
        return false;
    }

    Trigger(String id, String type, boolean enabled, String parentPipelineId, String parentPipelineApplication, String application, String pipeline, String correlationId, String executionId, String project, String slug, String source, String branch, List<String> events, String master, String job, String propertyFile, String cronExpression, String subscriptionName, String pubsubSystem, String account, String organization, String registry, String repository, String tag, Map payloadConstraints, Map attributeConstraints, List<String> status, String user, String artifactorySearchName, String nexusSearchName, List<String> expectedArtifactIds, String pluginEventType, String pluginId, String description, String provider, String version, String releaseDate, String requires, List<Map<String, String>> parsedRequires, String binaryUrl, String sha512sum, boolean preferred, String artifactName, Integer buildNumber, String hash, Map<String, Object> buildInfo, Map<String, Object> properties, Map parameters, Map payload, String runAsUser, String secret, String digest, String action, boolean rebake, boolean dryRun, List<Map<String, Object>> notifications, List<Map<String, Object>> artifacts, String eventId, Map<String, ?> lastSuccessfulExecution, String link, String linkText, Pipeline parent, boolean propagateAuth) {
        this.id = id;
        this.type = type;
        this.enabled = enabled;
        this.parentPipelineId = parentPipelineId;
        this.parentPipelineApplication = parentPipelineApplication;
        this.application = application;
        this.pipeline = pipeline;
        this.correlationId = correlationId;
        this.executionId = executionId;
        this.project = project;
        this.slug = slug;
        this.source = source;
        this.branch = branch;
        this.events = events;
        this.master = master;
        this.job = job;
        this.propertyFile = propertyFile;
        this.cronExpression = cronExpression;
        this.subscriptionName = subscriptionName;
        this.pubsubSystem = pubsubSystem;
        this.account = account;
        this.organization = organization;
        this.registry = registry;
        this.repository = repository;
        this.tag = tag;
        this.payloadConstraints = payloadConstraints;
        this.attributeConstraints = attributeConstraints;
        this.status = status;
        this.user = user;
        this.artifactorySearchName = artifactorySearchName;
        this.nexusSearchName = nexusSearchName;
        this.expectedArtifactIds = expectedArtifactIds;
        this.pluginEventType = pluginEventType;
        this.pluginId = pluginId;
        this.description = description;
        this.provider = provider;
        this.version = version;
        this.releaseDate = releaseDate;
        this.requires = requires;
        this.parsedRequires = parsedRequires;
        this.binaryUrl = binaryUrl;
        this.sha512sum = sha512sum;
        this.preferred = preferred;
        this.artifactName = artifactName;
        this.buildNumber = buildNumber;
        this.hash = hash;
        this.buildInfo = buildInfo;
        this.properties = properties;
        this.parameters = parameters;
        this.payload = payload;
        this.runAsUser = runAsUser;
        this.secret = secret;
        this.digest = digest;
        this.action = action;
        this.rebake = rebake;
        this.dryRun = dryRun;
        this.notifications = notifications;
        this.artifacts = artifacts;
        this.eventId = eventId;
        this.lastSuccessfulExecution = lastSuccessfulExecution;
        this.link = link;
        this.linkText = linkText;
        this.parent = parent;
        this.propagateAuth = propagateAuth;
    }

    public static TriggerBuilder builder() {
        return new TriggerBuilder();
    }

    public TriggerBuilder toBuilder() {
        return new TriggerBuilder().id(this.id).type(this.type).enabled(this.enabled).parentPipelineId(this.parentPipelineId).parentPipelineApplication(this.parentPipelineApplication).application(this.application).pipeline(this.pipeline).correlationId(this.correlationId).executionId(this.executionId).project(this.project).slug(this.slug).source(this.source).branch(this.branch).events(this.events).master(this.master).job(this.job).propertyFile(this.propertyFile).cronExpression(this.cronExpression).subscriptionName(this.subscriptionName).pubsubSystem(this.pubsubSystem).account(this.account).organization(this.organization).registry(this.registry).repository(this.repository).tag(this.tag).payloadConstraints(this.payloadConstraints).attributeConstraints(this.attributeConstraints).status(this.status).user(this.user).artifactorySearchName(this.artifactorySearchName).nexusSearchName(this.nexusSearchName).expectedArtifactIds(this.expectedArtifactIds).pluginEventType(this.pluginEventType).pluginId(this.pluginId).description(this.description).provider(this.provider).version(this.version).releaseDate(this.releaseDate).requires(this.requires).parsedRequires(this.parsedRequires).binaryUrl(this.binaryUrl).sha512sum(this.sha512sum).preferred(this.preferred).artifactName(this.artifactName).buildNumber(this.buildNumber).hash(this.hash).buildInfo(this.buildInfo).properties(this.properties).parameters(this.parameters).payload(this.payload).runAsUser(this.runAsUser).secret(this.secret).digest(this.digest).action(this.action).rebake(this.rebake).dryRun(this.dryRun).notifications(this.notifications).artifacts(this.artifacts).eventId(this.eventId).lastSuccessfulExecution(this.lastSuccessfulExecution).link(this.link).linkText(this.linkText).parent(this.parent).propagateAuth(this.propagateAuth);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getParentPipelineId() {
        return this.parentPipelineId;
    }

    public String getParentPipelineApplication() {
        return this.parentPipelineApplication;
    }

    public String getApplication() {
        return this.application;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getProject() {
        return this.project;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getSource() {
        return this.source;
    }

    public String getBranch() {
        return this.branch;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public String getMaster() {
        return this.master;
    }

    public String getJob() {
        return this.job;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public String getPubsubSystem() {
        return this.pubsubSystem;
    }

    public String getAccount() {
        return this.account;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public Map getPayloadConstraints() {
        return this.payloadConstraints;
    }

    public Map getAttributeConstraints() {
        return this.attributeConstraints;
    }

    public List<String> getStatus() {
        return this.status;
    }

    public String getUser() {
        return this.user;
    }

    public String getArtifactorySearchName() {
        return this.artifactorySearchName;
    }

    public String getNexusSearchName() {
        return this.nexusSearchName;
    }

    public List<String> getExpectedArtifactIds() {
        return this.expectedArtifactIds;
    }

    public String getPluginEventType() {
        return this.pluginEventType;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getVersion() {
        return this.version;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getRequires() {
        return this.requires;
    }

    public List<Map<String, String>> getParsedRequires() {
        return this.parsedRequires;
    }

    public String getBinaryUrl() {
        return this.binaryUrl;
    }

    public String getSha512sum() {
        return this.sha512sum;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public String getHash() {
        return this.hash;
    }

    public Map<String, Object> getBuildInfo() {
        return this.buildInfo;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public Map getPayload() {
        return this.payload;
    }

    public String getRunAsUser() {
        return this.runAsUser;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getAction() {
        return this.action;
    }

    public boolean isRebake() {
        return this.rebake;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public List<Map<String, Object>> getNotifications() {
        return this.notifications;
    }

    public List<Map<String, Object>> getArtifacts() {
        return this.artifacts;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Map<String, ?> getLastSuccessfulExecution() {
        return this.lastSuccessfulExecution;
    }

    public String getLink() {
        return this.link;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public Pipeline getParent() {
        return this.parent;
    }

    public boolean isPropagateAuth() {
        return this.propagateAuth;
    }

    public Trigger withId(String id) {
        return this.id == id ? this : new Trigger(id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withType(String type) {
        return this.type == type ? this : new Trigger(this.id, type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withEnabled(boolean enabled) {
        return this.enabled == enabled ? this : new Trigger(this.id, this.type, enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withParentPipelineId(String parentPipelineId) {
        return this.parentPipelineId == parentPipelineId ? this : new Trigger(this.id, this.type, this.enabled, parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withParentPipelineApplication(String parentPipelineApplication) {
        return this.parentPipelineApplication == parentPipelineApplication ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withApplication(String application) {
        return this.application == application ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withPipeline(String pipeline) {
        return this.pipeline == pipeline ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withCorrelationId(String correlationId) {
        return this.correlationId == correlationId ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withExecutionId(String executionId) {
        return this.executionId == executionId ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withProject(String project) {
        return this.project == project ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withSlug(String slug) {
        return this.slug == slug ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withSource(String source) {
        return this.source == source ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withBranch(String branch) {
        return this.branch == branch ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withEvents(List<String> events) {
        return this.events == events ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withMaster(String master) {
        return this.master == master ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withJob(String job) {
        return this.job == job ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withPropertyFile(String propertyFile) {
        return this.propertyFile == propertyFile ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withCronExpression(String cronExpression) {
        return this.cronExpression == cronExpression ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withSubscriptionName(String subscriptionName) {
        return this.subscriptionName == subscriptionName ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withPubsubSystem(String pubsubSystem) {
        return this.pubsubSystem == pubsubSystem ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withAccount(String account) {
        return this.account == account ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withOrganization(String organization) {
        return this.organization == organization ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withRegistry(String registry) {
        return this.registry == registry ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withRepository(String repository) {
        return this.repository == repository ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withTag(String tag) {
        return this.tag == tag ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withPayloadConstraints(Map payloadConstraints) {
        return this.payloadConstraints == payloadConstraints ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withAttributeConstraints(Map attributeConstraints) {
        return this.attributeConstraints == attributeConstraints ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withStatus(List<String> status) {
        return this.status == status ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withUser(String user) {
        return this.user == user ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withArtifactorySearchName(String artifactorySearchName) {
        return this.artifactorySearchName == artifactorySearchName ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withNexusSearchName(String nexusSearchName) {
        return this.nexusSearchName == nexusSearchName ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withExpectedArtifactIds(List<String> expectedArtifactIds) {
        return this.expectedArtifactIds == expectedArtifactIds ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withPluginEventType(String pluginEventType) {
        return this.pluginEventType == pluginEventType ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withDescription(String description) {
        return this.description == description ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withProvider(String provider) {
        return this.provider == provider ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withVersion(String version) {
        return this.version == version ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withReleaseDate(String releaseDate) {
        return this.releaseDate == releaseDate ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withRequires(String requires) {
        return this.requires == requires ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withParsedRequires(List<Map<String, String>> parsedRequires) {
        return this.parsedRequires == parsedRequires ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withBinaryUrl(String binaryUrl) {
        return this.binaryUrl == binaryUrl ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withSha512sum(String sha512sum) {
        return this.sha512sum == sha512sum ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withPreferred(boolean preferred) {
        return this.preferred == preferred ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withArtifactName(String artifactName) {
        return this.artifactName == artifactName ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withBuildNumber(Integer buildNumber) {
        return this.buildNumber == buildNumber ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withHash(String hash) {
        return this.hash == hash ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withBuildInfo(Map<String, Object> buildInfo) {
        return this.buildInfo == buildInfo ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withProperties(Map<String, Object> properties) {
        return this.properties == properties ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withParameters(Map parameters) {
        return this.parameters == parameters ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withPayload(Map payload) {
        return this.payload == payload ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withRunAsUser(String runAsUser) {
        return this.runAsUser == runAsUser ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withSecret(String secret) {
        return this.secret == secret ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withDigest(String digest) {
        return this.digest == digest ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withAction(String action) {
        return this.action == action ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withRebake(boolean rebake) {
        return this.rebake == rebake ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withDryRun(boolean dryRun) {
        return this.dryRun == dryRun ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withNotifications(List<Map<String, Object>> notifications) {
        return this.notifications == notifications ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withArtifacts(List<Map<String, Object>> artifacts) {
        return this.artifacts == artifacts ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withEventId(String eventId) {
        return this.eventId == eventId ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withLastSuccessfulExecution(Map<String, ?> lastSuccessfulExecution) {
        return this.lastSuccessfulExecution == lastSuccessfulExecution ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withLink(String link) {
        return this.link == link ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, link, this.linkText, this.parent, this.propagateAuth);
    }

    public Trigger withLinkText(String linkText) {
        return this.linkText == linkText ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, linkText, this.parent, this.propagateAuth);
    }

    public Trigger withParent(Pipeline parent) {
        return this.parent == parent ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, parent, this.propagateAuth);
    }

    public Trigger withPropagateAuth(boolean propagateAuth) {
        return this.propagateAuth == propagateAuth ? this : new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, this.rebake, this.dryRun, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, propagateAuth);
    }

    public String toString() {
        return "Trigger(" + this.getId() + ", " + this.getType() + ", " + this.getApplication() + ", " + this.getPipeline() + ", " + this.getCorrelationId() + ", " + this.getExecutionId() + ", " + this.getProject() + ", " + this.getSlug() + ", " + this.getSource() + ", " + this.getBranch() + ", " + this.getMaster() + ", " + this.getJob() + ", " + this.getCronExpression() + ", " + this.getSubscriptionName() + ", " + this.getPubsubSystem() + ", " + this.getAccount() + ", " + this.getRepository() + ", " + this.getTag() + ", " + this.getPayloadConstraints() + ", " + this.getAttributeConstraints() + ", " + this.getStatus() + ", " + this.getExpectedArtifactIds() + ", " + this.getArtifactName() + ", " + this.getParameters() + ", " + this.getPayload() + ", " + this.getRunAsUser() + ", " + this.getDigest() + ", " + this.getLink() + ", " + this.getLinkText() + ", " + this.getParent() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)o;
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isPreferred() != other.isPreferred()) {
            return false;
        }
        if (this.isRebake() != other.isRebake()) {
            return false;
        }
        if (this.isDryRun() != other.isDryRun()) {
            return false;
        }
        if (this.isPropagateAuth() != other.isPropagateAuth()) {
            return false;
        }
        Integer this$buildNumber = this.getBuildNumber();
        Integer other$buildNumber = other.getBuildNumber();
        if (this$buildNumber == null ? other$buildNumber != null : !((Object)this$buildNumber).equals(other$buildNumber)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$parentPipelineId = this.getParentPipelineId();
        String other$parentPipelineId = other.getParentPipelineId();
        if (this$parentPipelineId == null ? other$parentPipelineId != null : !this$parentPipelineId.equals(other$parentPipelineId)) {
            return false;
        }
        String this$parentPipelineApplication = this.getParentPipelineApplication();
        String other$parentPipelineApplication = other.getParentPipelineApplication();
        if (this$parentPipelineApplication == null ? other$parentPipelineApplication != null : !this$parentPipelineApplication.equals(other$parentPipelineApplication)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$pipeline = this.getPipeline();
        String other$pipeline = other.getPipeline();
        if (this$pipeline == null ? other$pipeline != null : !this$pipeline.equals(other$pipeline)) {
            return false;
        }
        String this$correlationId = this.getCorrelationId();
        String other$correlationId = other.getCorrelationId();
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$slug = this.getSlug();
        String other$slug = other.getSlug();
        if (this$slug == null ? other$slug != null : !this$slug.equals(other$slug)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        List<String> this$events = this.getEvents();
        List<String> other$events = other.getEvents();
        if (this$events == null ? other$events != null : !((Object)this$events).equals(other$events)) {
            return false;
        }
        String this$master = this.getMaster();
        String other$master = other.getMaster();
        if (this$master == null ? other$master != null : !this$master.equals(other$master)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        String this$propertyFile = this.getPropertyFile();
        String other$propertyFile = other.getPropertyFile();
        if (this$propertyFile == null ? other$propertyFile != null : !this$propertyFile.equals(other$propertyFile)) {
            return false;
        }
        String this$cronExpression = this.getCronExpression();
        String other$cronExpression = other.getCronExpression();
        if (this$cronExpression == null ? other$cronExpression != null : !this$cronExpression.equals(other$cronExpression)) {
            return false;
        }
        String this$subscriptionName = this.getSubscriptionName();
        String other$subscriptionName = other.getSubscriptionName();
        if (this$subscriptionName == null ? other$subscriptionName != null : !this$subscriptionName.equals(other$subscriptionName)) {
            return false;
        }
        String this$pubsubSystem = this.getPubsubSystem();
        String other$pubsubSystem = other.getPubsubSystem();
        if (this$pubsubSystem == null ? other$pubsubSystem != null : !this$pubsubSystem.equals(other$pubsubSystem)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$organization = this.getOrganization();
        String other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$registry = this.getRegistry();
        String other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        Map this$payloadConstraints = this.getPayloadConstraints();
        Map other$payloadConstraints = other.getPayloadConstraints();
        if (this$payloadConstraints == null ? other$payloadConstraints != null : !((Object)this$payloadConstraints).equals(other$payloadConstraints)) {
            return false;
        }
        Map this$attributeConstraints = this.getAttributeConstraints();
        Map other$attributeConstraints = other.getAttributeConstraints();
        if (this$attributeConstraints == null ? other$attributeConstraints != null : !((Object)this$attributeConstraints).equals(other$attributeConstraints)) {
            return false;
        }
        List<String> this$status = this.getStatus();
        List<String> other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$artifactorySearchName = this.getArtifactorySearchName();
        String other$artifactorySearchName = other.getArtifactorySearchName();
        if (this$artifactorySearchName == null ? other$artifactorySearchName != null : !this$artifactorySearchName.equals(other$artifactorySearchName)) {
            return false;
        }
        String this$nexusSearchName = this.getNexusSearchName();
        String other$nexusSearchName = other.getNexusSearchName();
        if (this$nexusSearchName == null ? other$nexusSearchName != null : !this$nexusSearchName.equals(other$nexusSearchName)) {
            return false;
        }
        List<String> this$expectedArtifactIds = this.getExpectedArtifactIds();
        List<String> other$expectedArtifactIds = other.getExpectedArtifactIds();
        if (this$expectedArtifactIds == null ? other$expectedArtifactIds != null : !((Object)this$expectedArtifactIds).equals(other$expectedArtifactIds)) {
            return false;
        }
        String this$pluginEventType = this.getPluginEventType();
        String other$pluginEventType = other.getPluginEventType();
        if (this$pluginEventType == null ? other$pluginEventType != null : !this$pluginEventType.equals(other$pluginEventType)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$releaseDate = this.getReleaseDate();
        String other$releaseDate = other.getReleaseDate();
        if (this$releaseDate == null ? other$releaseDate != null : !this$releaseDate.equals(other$releaseDate)) {
            return false;
        }
        String this$requires = this.getRequires();
        String other$requires = other.getRequires();
        if (this$requires == null ? other$requires != null : !this$requires.equals(other$requires)) {
            return false;
        }
        List<Map<String, String>> this$parsedRequires = this.getParsedRequires();
        List<Map<String, String>> other$parsedRequires = other.getParsedRequires();
        if (this$parsedRequires == null ? other$parsedRequires != null : !((Object)this$parsedRequires).equals(other$parsedRequires)) {
            return false;
        }
        String this$binaryUrl = this.getBinaryUrl();
        String other$binaryUrl = other.getBinaryUrl();
        if (this$binaryUrl == null ? other$binaryUrl != null : !this$binaryUrl.equals(other$binaryUrl)) {
            return false;
        }
        String this$sha512sum = this.getSha512sum();
        String other$sha512sum = other.getSha512sum();
        if (this$sha512sum == null ? other$sha512sum != null : !this$sha512sum.equals(other$sha512sum)) {
            return false;
        }
        String this$artifactName = this.getArtifactName();
        String other$artifactName = other.getArtifactName();
        if (this$artifactName == null ? other$artifactName != null : !this$artifactName.equals(other$artifactName)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        Map<String, Object> this$buildInfo = this.getBuildInfo();
        Map<String, Object> other$buildInfo = other.getBuildInfo();
        if (this$buildInfo == null ? other$buildInfo != null : !((Object)this$buildInfo).equals(other$buildInfo)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Map this$parameters = this.getParameters();
        Map other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Map this$payload = this.getPayload();
        Map other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload)) {
            return false;
        }
        String this$runAsUser = this.getRunAsUser();
        String other$runAsUser = other.getRunAsUser();
        if (this$runAsUser == null ? other$runAsUser != null : !this$runAsUser.equals(other$runAsUser)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$digest = this.getDigest();
        String other$digest = other.getDigest();
        if (this$digest == null ? other$digest != null : !this$digest.equals(other$digest)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        List<Map<String, Object>> this$notifications = this.getNotifications();
        List<Map<String, Object>> other$notifications = other.getNotifications();
        if (this$notifications == null ? other$notifications != null : !((Object)this$notifications).equals(other$notifications)) {
            return false;
        }
        List<Map<String, Object>> this$artifacts = this.getArtifacts();
        List<Map<String, Object>> other$artifacts = other.getArtifacts();
        if (this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts)) {
            return false;
        }
        String this$eventId = this.getEventId();
        String other$eventId = other.getEventId();
        if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
            return false;
        }
        Map<String, ?> this$lastSuccessfulExecution = this.getLastSuccessfulExecution();
        Map<String, ?> other$lastSuccessfulExecution = other.getLastSuccessfulExecution();
        if (this$lastSuccessfulExecution == null ? other$lastSuccessfulExecution != null : !((Object)this$lastSuccessfulExecution).equals(other$lastSuccessfulExecution)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        String this$linkText = this.getLinkText();
        String other$linkText = other.getLinkText();
        return !(this$linkText == null ? other$linkText != null : !this$linkText.equals(other$linkText));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isPreferred() ? 79 : 97);
        result = result * 59 + (this.isRebake() ? 79 : 97);
        result = result * 59 + (this.isDryRun() ? 79 : 97);
        result = result * 59 + (this.isPropagateAuth() ? 79 : 97);
        Integer $buildNumber = this.getBuildNumber();
        result = result * 59 + ($buildNumber == null ? 43 : ((Object)$buildNumber).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $parentPipelineId = this.getParentPipelineId();
        result = result * 59 + ($parentPipelineId == null ? 43 : $parentPipelineId.hashCode());
        String $parentPipelineApplication = this.getParentPipelineApplication();
        result = result * 59 + ($parentPipelineApplication == null ? 43 : $parentPipelineApplication.hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $pipeline = this.getPipeline();
        result = result * 59 + ($pipeline == null ? 43 : $pipeline.hashCode());
        String $correlationId = this.getCorrelationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $slug = this.getSlug();
        result = result * 59 + ($slug == null ? 43 : $slug.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        List<String> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        String $master = this.getMaster();
        result = result * 59 + ($master == null ? 43 : $master.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        String $propertyFile = this.getPropertyFile();
        result = result * 59 + ($propertyFile == null ? 43 : $propertyFile.hashCode());
        String $cronExpression = this.getCronExpression();
        result = result * 59 + ($cronExpression == null ? 43 : $cronExpression.hashCode());
        String $subscriptionName = this.getSubscriptionName();
        result = result * 59 + ($subscriptionName == null ? 43 : $subscriptionName.hashCode());
        String $pubsubSystem = this.getPubsubSystem();
        result = result * 59 + ($pubsubSystem == null ? 43 : $pubsubSystem.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        Map $payloadConstraints = this.getPayloadConstraints();
        result = result * 59 + ($payloadConstraints == null ? 43 : ((Object)$payloadConstraints).hashCode());
        Map $attributeConstraints = this.getAttributeConstraints();
        result = result * 59 + ($attributeConstraints == null ? 43 : ((Object)$attributeConstraints).hashCode());
        List<String> $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $artifactorySearchName = this.getArtifactorySearchName();
        result = result * 59 + ($artifactorySearchName == null ? 43 : $artifactorySearchName.hashCode());
        String $nexusSearchName = this.getNexusSearchName();
        result = result * 59 + ($nexusSearchName == null ? 43 : $nexusSearchName.hashCode());
        List<String> $expectedArtifactIds = this.getExpectedArtifactIds();
        result = result * 59 + ($expectedArtifactIds == null ? 43 : ((Object)$expectedArtifactIds).hashCode());
        String $pluginEventType = this.getPluginEventType();
        result = result * 59 + ($pluginEventType == null ? 43 : $pluginEventType.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $releaseDate = this.getReleaseDate();
        result = result * 59 + ($releaseDate == null ? 43 : $releaseDate.hashCode());
        String $requires = this.getRequires();
        result = result * 59 + ($requires == null ? 43 : $requires.hashCode());
        List<Map<String, String>> $parsedRequires = this.getParsedRequires();
        result = result * 59 + ($parsedRequires == null ? 43 : ((Object)$parsedRequires).hashCode());
        String $binaryUrl = this.getBinaryUrl();
        result = result * 59 + ($binaryUrl == null ? 43 : $binaryUrl.hashCode());
        String $sha512sum = this.getSha512sum();
        result = result * 59 + ($sha512sum == null ? 43 : $sha512sum.hashCode());
        String $artifactName = this.getArtifactName();
        result = result * 59 + ($artifactName == null ? 43 : $artifactName.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        Map<String, Object> $buildInfo = this.getBuildInfo();
        result = result * 59 + ($buildInfo == null ? 43 : ((Object)$buildInfo).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Map $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Map $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        String $runAsUser = this.getRunAsUser();
        result = result * 59 + ($runAsUser == null ? 43 : $runAsUser.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $digest = this.getDigest();
        result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        List<Map<String, Object>> $notifications = this.getNotifications();
        result = result * 59 + ($notifications == null ? 43 : ((Object)$notifications).hashCode());
        List<Map<String, Object>> $artifacts = this.getArtifacts();
        result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
        String $eventId = this.getEventId();
        result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
        Map<String, ?> $lastSuccessfulExecution = this.getLastSuccessfulExecution();
        result = result * 59 + ($lastSuccessfulExecution == null ? 43 : ((Object)$lastSuccessfulExecution).hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        String $linkText = this.getLinkText();
        result = result * 59 + ($linkText == null ? 43 : $linkText.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class TriggerBuilder {
        private String id;
        private String type;
        private boolean enabled;
        private String parentPipelineId;
        private String parentPipelineApplication;
        private String application;
        private String pipeline;
        private String correlationId;
        private String executionId;
        private String project;
        private String slug;
        private String source;
        private String branch;
        private List<String> events;
        private String master;
        private String job;
        private String propertyFile;
        private String cronExpression;
        private String subscriptionName;
        private String pubsubSystem;
        private String account;
        private String organization;
        private String registry;
        private String repository;
        private String tag;
        private Map payloadConstraints;
        private Map attributeConstraints;
        private List<String> status;
        private String user;
        private String artifactorySearchName;
        private String nexusSearchName;
        private List<String> expectedArtifactIds;
        private String pluginEventType;
        private String pluginId;
        private String description;
        private String provider;
        private String version;
        private String releaseDate;
        private String requires;
        private List<Map<String, String>> parsedRequires;
        private String binaryUrl;
        private String sha512sum;
        private boolean preferred;
        private String artifactName;
        private Integer buildNumber;
        private String hash;
        private Map<String, Object> buildInfo;
        private Map<String, Object> properties;
        private Map parameters;
        private Map payload;
        private String runAsUser;
        private String secret;
        private String digest;
        private String action;
        private boolean rebake$set;
        private boolean rebake$value;
        private boolean dryRun$set;
        private boolean dryRun$value;
        private List<Map<String, Object>> notifications;
        private List<Map<String, Object>> artifacts;
        private String eventId;
        private Map<String, ?> lastSuccessfulExecution;
        private String link;
        private String linkText;
        private Pipeline parent;
        private boolean propagateAuth;

        @JsonIgnore
        private TriggerBuilder propagateAuth(boolean propagateAuth) {
            this.propagateAuth = propagateAuth;
            return this;
        }

        TriggerBuilder() {
        }

        public TriggerBuilder id(String id) {
            this.id = id;
            return this;
        }

        public TriggerBuilder type(String type) {
            this.type = type;
            return this;
        }

        public TriggerBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TriggerBuilder parentPipelineId(String parentPipelineId) {
            this.parentPipelineId = parentPipelineId;
            return this;
        }

        public TriggerBuilder parentPipelineApplication(String parentPipelineApplication) {
            this.parentPipelineApplication = parentPipelineApplication;
            return this;
        }

        public TriggerBuilder application(String application) {
            this.application = application;
            return this;
        }

        public TriggerBuilder pipeline(String pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public TriggerBuilder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public TriggerBuilder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public TriggerBuilder project(String project) {
            this.project = project;
            return this;
        }

        public TriggerBuilder slug(String slug) {
            this.slug = slug;
            return this;
        }

        public TriggerBuilder source(String source) {
            this.source = source;
            return this;
        }

        public TriggerBuilder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public TriggerBuilder events(List<String> events) {
            this.events = events;
            return this;
        }

        public TriggerBuilder master(String master) {
            this.master = master;
            return this;
        }

        public TriggerBuilder job(String job) {
            this.job = job;
            return this;
        }

        public TriggerBuilder propertyFile(String propertyFile) {
            this.propertyFile = propertyFile;
            return this;
        }

        public TriggerBuilder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public TriggerBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public TriggerBuilder pubsubSystem(String pubsubSystem) {
            this.pubsubSystem = pubsubSystem;
            return this;
        }

        public TriggerBuilder account(String account) {
            this.account = account;
            return this;
        }

        public TriggerBuilder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public TriggerBuilder registry(String registry) {
            this.registry = registry;
            return this;
        }

        public TriggerBuilder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public TriggerBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public TriggerBuilder payloadConstraints(Map payloadConstraints) {
            this.payloadConstraints = payloadConstraints;
            return this;
        }

        public TriggerBuilder attributeConstraints(Map attributeConstraints) {
            this.attributeConstraints = attributeConstraints;
            return this;
        }

        public TriggerBuilder status(List<String> status) {
            this.status = status;
            return this;
        }

        public TriggerBuilder user(String user) {
            this.user = user;
            return this;
        }

        public TriggerBuilder artifactorySearchName(String artifactorySearchName) {
            this.artifactorySearchName = artifactorySearchName;
            return this;
        }

        public TriggerBuilder nexusSearchName(String nexusSearchName) {
            this.nexusSearchName = nexusSearchName;
            return this;
        }

        public TriggerBuilder expectedArtifactIds(List<String> expectedArtifactIds) {
            this.expectedArtifactIds = expectedArtifactIds;
            return this;
        }

        public TriggerBuilder pluginEventType(String pluginEventType) {
            this.pluginEventType = pluginEventType;
            return this;
        }

        public TriggerBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public TriggerBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TriggerBuilder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public TriggerBuilder version(String version) {
            this.version = version;
            return this;
        }

        public TriggerBuilder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public TriggerBuilder requires(String requires) {
            this.requires = requires;
            return this;
        }

        public TriggerBuilder parsedRequires(List<Map<String, String>> parsedRequires) {
            this.parsedRequires = parsedRequires;
            return this;
        }

        public TriggerBuilder binaryUrl(String binaryUrl) {
            this.binaryUrl = binaryUrl;
            return this;
        }

        public TriggerBuilder sha512sum(String sha512sum) {
            this.sha512sum = sha512sum;
            return this;
        }

        public TriggerBuilder preferred(boolean preferred) {
            this.preferred = preferred;
            return this;
        }

        public TriggerBuilder artifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        public TriggerBuilder buildNumber(Integer buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        public TriggerBuilder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public TriggerBuilder buildInfo(Map<String, Object> buildInfo) {
            this.buildInfo = buildInfo;
            return this;
        }

        public TriggerBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public TriggerBuilder parameters(Map parameters) {
            this.parameters = parameters;
            return this;
        }

        public TriggerBuilder payload(Map payload) {
            this.payload = payload;
            return this;
        }

        public TriggerBuilder runAsUser(String runAsUser) {
            this.runAsUser = runAsUser;
            return this;
        }

        public TriggerBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public TriggerBuilder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public TriggerBuilder action(String action) {
            this.action = action;
            return this;
        }

        public TriggerBuilder rebake(boolean rebake) {
            this.rebake$value = rebake;
            this.rebake$set = true;
            return this;
        }

        public TriggerBuilder dryRun(boolean dryRun) {
            this.dryRun$value = dryRun;
            this.dryRun$set = true;
            return this;
        }

        public TriggerBuilder notifications(List<Map<String, Object>> notifications) {
            this.notifications = notifications;
            return this;
        }

        public TriggerBuilder artifacts(List<Map<String, Object>> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public TriggerBuilder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public TriggerBuilder lastSuccessfulExecution(Map<String, ?> lastSuccessfulExecution) {
            this.lastSuccessfulExecution = lastSuccessfulExecution;
            return this;
        }

        public TriggerBuilder link(String link) {
            this.link = link;
            return this;
        }

        public TriggerBuilder linkText(String linkText) {
            this.linkText = linkText;
            return this;
        }

        @JsonIgnore
        public TriggerBuilder parent(Pipeline parent) {
            this.parent = parent;
            return this;
        }

        public Trigger build() {
            boolean rebake$value = this.rebake$value;
            if (!this.rebake$set) {
                rebake$value = Trigger.$default$rebake();
            }
            boolean dryRun$value = this.dryRun$value;
            if (!this.dryRun$set) {
                dryRun$value = Trigger.$default$dryRun();
            }
            return new Trigger(this.id, this.type, this.enabled, this.parentPipelineId, this.parentPipelineApplication, this.application, this.pipeline, this.correlationId, this.executionId, this.project, this.slug, this.source, this.branch, this.events, this.master, this.job, this.propertyFile, this.cronExpression, this.subscriptionName, this.pubsubSystem, this.account, this.organization, this.registry, this.repository, this.tag, this.payloadConstraints, this.attributeConstraints, this.status, this.user, this.artifactorySearchName, this.nexusSearchName, this.expectedArtifactIds, this.pluginEventType, this.pluginId, this.description, this.provider, this.version, this.releaseDate, this.requires, this.parsedRequires, this.binaryUrl, this.sha512sum, this.preferred, this.artifactName, this.buildNumber, this.hash, this.buildInfo, this.properties, this.parameters, this.payload, this.runAsUser, this.secret, this.digest, this.action, rebake$value, dryRun$value, this.notifications, this.artifacts, this.eventId, this.lastSuccessfulExecution, this.link, this.linkText, this.parent, this.propagateAuth);
        }

        public String toString() {
            return "Trigger.TriggerBuilder(id=" + this.id + ", type=" + this.type + ", enabled=" + this.enabled + ", parentPipelineId=" + this.parentPipelineId + ", parentPipelineApplication=" + this.parentPipelineApplication + ", application=" + this.application + ", pipeline=" + this.pipeline + ", correlationId=" + this.correlationId + ", executionId=" + this.executionId + ", project=" + this.project + ", slug=" + this.slug + ", source=" + this.source + ", branch=" + this.branch + ", events=" + this.events + ", master=" + this.master + ", job=" + this.job + ", propertyFile=" + this.propertyFile + ", cronExpression=" + this.cronExpression + ", subscriptionName=" + this.subscriptionName + ", pubsubSystem=" + this.pubsubSystem + ", account=" + this.account + ", organization=" + this.organization + ", registry=" + this.registry + ", repository=" + this.repository + ", tag=" + this.tag + ", payloadConstraints=" + this.payloadConstraints + ", attributeConstraints=" + this.attributeConstraints + ", status=" + this.status + ", user=" + this.user + ", artifactorySearchName=" + this.artifactorySearchName + ", nexusSearchName=" + this.nexusSearchName + ", expectedArtifactIds=" + this.expectedArtifactIds + ", pluginEventType=" + this.pluginEventType + ", pluginId=" + this.pluginId + ", description=" + this.description + ", provider=" + this.provider + ", version=" + this.version + ", releaseDate=" + this.releaseDate + ", requires=" + this.requires + ", parsedRequires=" + this.parsedRequires + ", binaryUrl=" + this.binaryUrl + ", sha512sum=" + this.sha512sum + ", preferred=" + this.preferred + ", artifactName=" + this.artifactName + ", buildNumber=" + this.buildNumber + ", hash=" + this.hash + ", buildInfo=" + this.buildInfo + ", properties=" + this.properties + ", parameters=" + this.parameters + ", payload=" + this.payload + ", runAsUser=" + this.runAsUser + ", secret=" + this.secret + ", digest=" + this.digest + ", action=" + this.action + ", rebake$value=" + this.rebake$value + ", dryRun$value=" + this.dryRun$value + ", notifications=" + this.notifications + ", artifacts=" + this.artifacts + ", eventId=" + this.eventId + ", lastSuccessfulExecution=" + this.lastSuccessfulExecution + ", link=" + this.link + ", linkText=" + this.linkText + ", parent=" + this.parent + ", propagateAuth=" + this.propagateAuth + ")";
        }
    }

    public static enum Type {
        CRON("cron"),
        GIT("git"),
        CONCOURSE("concourse"),
        JENKINS("jenkins"),
        DOCKER("docker"),
        WEBHOOK("webhook"),
        PUBSUB("pubsub"),
        DRYRUN("dryrun"),
        PIPELINE("pipeline"),
        PLUGIN("plugin"),
        HELM("helm");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

