/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.model.pubsub;

import com.netflix.spinnaker.echo.model.pubsub.PubsubSystem;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.List;
import java.util.Map;

public class MessageDescription {
    private String subscriptionName;
    private String messagePayload;
    private Map<String, String> messageAttributes;
    private PubsubSystem pubsubSystem;
    private int ackDeadlineSeconds;
    private Integer retentionDeadlineSeconds;
    private List<Artifact> artifacts;

    public static MessageDescriptionBuilder builder() {
        return new MessageDescriptionBuilder();
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public String getMessagePayload() {
        return this.messagePayload;
    }

    public Map<String, String> getMessageAttributes() {
        return this.messageAttributes;
    }

    public PubsubSystem getPubsubSystem() {
        return this.pubsubSystem;
    }

    public int getAckDeadlineSeconds() {
        return this.ackDeadlineSeconds;
    }

    public Integer getRetentionDeadlineSeconds() {
        return this.retentionDeadlineSeconds;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public MessageDescription setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
        return this;
    }

    public MessageDescription setMessagePayload(String messagePayload) {
        this.messagePayload = messagePayload;
        return this;
    }

    public MessageDescription setMessageAttributes(Map<String, String> messageAttributes) {
        this.messageAttributes = messageAttributes;
        return this;
    }

    public MessageDescription setPubsubSystem(PubsubSystem pubsubSystem) {
        this.pubsubSystem = pubsubSystem;
        return this;
    }

    public MessageDescription setAckDeadlineSeconds(int ackDeadlineSeconds) {
        this.ackDeadlineSeconds = ackDeadlineSeconds;
        return this;
    }

    public MessageDescription setRetentionDeadlineSeconds(Integer retentionDeadlineSeconds) {
        this.retentionDeadlineSeconds = retentionDeadlineSeconds;
        return this;
    }

    public MessageDescription setArtifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageDescription)) {
            return false;
        }
        MessageDescription other = (MessageDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAckDeadlineSeconds() != other.getAckDeadlineSeconds()) {
            return false;
        }
        Integer this$retentionDeadlineSeconds = this.getRetentionDeadlineSeconds();
        Integer other$retentionDeadlineSeconds = other.getRetentionDeadlineSeconds();
        if (this$retentionDeadlineSeconds == null ? other$retentionDeadlineSeconds != null : !((Object)this$retentionDeadlineSeconds).equals(other$retentionDeadlineSeconds)) {
            return false;
        }
        String this$subscriptionName = this.getSubscriptionName();
        String other$subscriptionName = other.getSubscriptionName();
        if (this$subscriptionName == null ? other$subscriptionName != null : !this$subscriptionName.equals(other$subscriptionName)) {
            return false;
        }
        String this$messagePayload = this.getMessagePayload();
        String other$messagePayload = other.getMessagePayload();
        if (this$messagePayload == null ? other$messagePayload != null : !this$messagePayload.equals(other$messagePayload)) {
            return false;
        }
        Map<String, String> this$messageAttributes = this.getMessageAttributes();
        Map<String, String> other$messageAttributes = other.getMessageAttributes();
        if (this$messageAttributes == null ? other$messageAttributes != null : !((Object)this$messageAttributes).equals(other$messageAttributes)) {
            return false;
        }
        PubsubSystem this$pubsubSystem = this.getPubsubSystem();
        PubsubSystem other$pubsubSystem = other.getPubsubSystem();
        if (this$pubsubSystem == null ? other$pubsubSystem != null : !((Object)((Object)this$pubsubSystem)).equals((Object)other$pubsubSystem)) {
            return false;
        }
        List<Artifact> this$artifacts = this.getArtifacts();
        List<Artifact> other$artifacts = other.getArtifacts();
        return !(this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAckDeadlineSeconds();
        Integer $retentionDeadlineSeconds = this.getRetentionDeadlineSeconds();
        result = result * 59 + ($retentionDeadlineSeconds == null ? 43 : ((Object)$retentionDeadlineSeconds).hashCode());
        String $subscriptionName = this.getSubscriptionName();
        result = result * 59 + ($subscriptionName == null ? 43 : $subscriptionName.hashCode());
        String $messagePayload = this.getMessagePayload();
        result = result * 59 + ($messagePayload == null ? 43 : $messagePayload.hashCode());
        Map<String, String> $messageAttributes = this.getMessageAttributes();
        result = result * 59 + ($messageAttributes == null ? 43 : ((Object)$messageAttributes).hashCode());
        PubsubSystem $pubsubSystem = this.getPubsubSystem();
        result = result * 59 + ($pubsubSystem == null ? 43 : ((Object)((Object)$pubsubSystem)).hashCode());
        List<Artifact> $artifacts = this.getArtifacts();
        result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
        return result;
    }

    public String toString() {
        return "MessageDescription(subscriptionName=" + this.getSubscriptionName() + ", messagePayload=" + this.getMessagePayload() + ", messageAttributes=" + this.getMessageAttributes() + ", pubsubSystem=" + this.getPubsubSystem() + ", ackDeadlineSeconds=" + this.getAckDeadlineSeconds() + ", retentionDeadlineSeconds=" + this.getRetentionDeadlineSeconds() + ", artifacts=" + this.getArtifacts() + ")";
    }

    public MessageDescription() {
    }

    public MessageDescription(String subscriptionName, String messagePayload, Map<String, String> messageAttributes, PubsubSystem pubsubSystem, int ackDeadlineSeconds, Integer retentionDeadlineSeconds, List<Artifact> artifacts) {
        this.subscriptionName = subscriptionName;
        this.messagePayload = messagePayload;
        this.messageAttributes = messageAttributes;
        this.pubsubSystem = pubsubSystem;
        this.ackDeadlineSeconds = ackDeadlineSeconds;
        this.retentionDeadlineSeconds = retentionDeadlineSeconds;
        this.artifacts = artifacts;
    }

    public static class MessageDescriptionBuilder {
        private String subscriptionName;
        private String messagePayload;
        private Map<String, String> messageAttributes;
        private PubsubSystem pubsubSystem;
        private int ackDeadlineSeconds;
        private Integer retentionDeadlineSeconds;
        private List<Artifact> artifacts;

        MessageDescriptionBuilder() {
        }

        public MessageDescriptionBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public MessageDescriptionBuilder messagePayload(String messagePayload) {
            this.messagePayload = messagePayload;
            return this;
        }

        public MessageDescriptionBuilder messageAttributes(Map<String, String> messageAttributes) {
            this.messageAttributes = messageAttributes;
            return this;
        }

        public MessageDescriptionBuilder pubsubSystem(PubsubSystem pubsubSystem) {
            this.pubsubSystem = pubsubSystem;
            return this;
        }

        public MessageDescriptionBuilder ackDeadlineSeconds(int ackDeadlineSeconds) {
            this.ackDeadlineSeconds = ackDeadlineSeconds;
            return this;
        }

        public MessageDescriptionBuilder retentionDeadlineSeconds(Integer retentionDeadlineSeconds) {
            this.retentionDeadlineSeconds = retentionDeadlineSeconds;
            return this;
        }

        public MessageDescriptionBuilder artifacts(List<Artifact> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public MessageDescription build() {
            return new MessageDescription(this.subscriptionName, this.messagePayload, this.messageAttributes, this.pubsubSystem, this.ackDeadlineSeconds, this.retentionDeadlineSeconds, this.artifacts);
        }

        public String toString() {
            return "MessageDescription.MessageDescriptionBuilder(subscriptionName=" + this.subscriptionName + ", messagePayload=" + this.messagePayload + ", messageAttributes=" + this.messageAttributes + ", pubsubSystem=" + this.pubsubSystem + ", ackDeadlineSeconds=" + this.ackDeadlineSeconds + ", retentionDeadlineSeconds=" + this.retentionDeadlineSeconds + ", artifacts=" + this.artifacts + ")";
        }
    }
}

