/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.model.trigger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.netflix.spinnaker.echo.model.trigger.TriggerEvent;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildEvent
extends TriggerEvent {
    public static final String TYPE = "build";
    private Content content;

    @JsonIgnore
    public int getBuildNumber() {
        return this.content.getProject().getLastBuild().getNumber();
    }

    public Content getContent() {
        return this.content;
    }

    public BuildEvent setContent(Content content) {
        this.content = content;
        return this;
    }

    @Override
    public String toString() {
        return "BuildEvent(content=" + this.getContent() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildEvent)) {
            return false;
        }
        BuildEvent other = (BuildEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Content this$content = this.getContent();
        Content other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BuildEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Content $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public static enum Result {
        SUCCESS,
        UNSTABLE,
        BUILDING,
        ABORTED,
        FAILURE,
        NOT_BUILT;

    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Build {
        private boolean building;
        private int number;
        private Result result;
        private String url;
        private List<Artifact> artifacts;

        public boolean isBuilding() {
            return this.building;
        }

        public int getNumber() {
            return this.number;
        }

        public Result getResult() {
            return this.result;
        }

        public String getUrl() {
            return this.url;
        }

        public List<Artifact> getArtifacts() {
            return this.artifacts;
        }

        public Build setBuilding(boolean building) {
            this.building = building;
            return this;
        }

        public Build setNumber(int number) {
            this.number = number;
            return this;
        }

        public Build setResult(Result result) {
            this.result = result;
            return this;
        }

        public Build setUrl(String url) {
            this.url = url;
            return this;
        }

        public Build setArtifacts(List<Artifact> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Build)) {
                return false;
            }
            Build other = (Build)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isBuilding() != other.isBuilding()) {
                return false;
            }
            if (this.getNumber() != other.getNumber()) {
                return false;
            }
            Result this$result = this.getResult();
            Result other$result = other.getResult();
            if (this$result == null ? other$result != null : !((Object)((Object)this$result)).equals((Object)other$result)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            List<Artifact> this$artifacts = this.getArtifacts();
            List<Artifact> other$artifacts = other.getArtifacts();
            return !(this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Build;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isBuilding() ? 79 : 97);
            result = result * 59 + this.getNumber();
            Result $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)((Object)$result)).hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            List<Artifact> $artifacts = this.getArtifacts();
            result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
            return result;
        }

        public String toString() {
            return "BuildEvent.Build(building=" + this.isBuilding() + ", number=" + this.getNumber() + ", result=" + this.getResult() + ", url=" + this.getUrl() + ", artifacts=" + this.getArtifacts() + ")";
        }

        public Build(boolean building, int number, Result result, String url, List<Artifact> artifacts) {
            this.building = building;
            this.number = number;
            this.result = result;
            this.url = url;
            this.artifacts = artifacts;
        }

        public Build() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Project {
        String name;
        Build lastBuild;

        public String getName() {
            return this.name;
        }

        public Build getLastBuild() {
            return this.lastBuild;
        }

        public Project setName(String name) {
            this.name = name;
            return this;
        }

        public Project setLastBuild(Build lastBuild) {
            this.lastBuild = lastBuild;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Project)) {
                return false;
            }
            Project other = (Project)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Build this$lastBuild = this.getLastBuild();
            Build other$lastBuild = other.getLastBuild();
            return !(this$lastBuild == null ? other$lastBuild != null : !((Object)this$lastBuild).equals(other$lastBuild));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Project;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Build $lastBuild = this.getLastBuild();
            result = result * 59 + ($lastBuild == null ? 43 : ((Object)$lastBuild).hashCode());
            return result;
        }

        public String toString() {
            return "BuildEvent.Project(name=" + this.getName() + ", lastBuild=" + this.getLastBuild() + ")";
        }

        public Project(String name, Build lastBuild) {
            this.name = name;
            this.lastBuild = lastBuild;
        }

        public Project() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Content {
        Project project;
        String master;

        public Project getProject() {
            return this.project;
        }

        public String getMaster() {
            return this.master;
        }

        public Content setProject(Project project) {
            this.project = project;
            return this;
        }

        public Content setMaster(String master) {
            this.master = master;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Content)) {
                return false;
            }
            Content other = (Content)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Project this$project = this.getProject();
            Project other$project = other.getProject();
            if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
                return false;
            }
            String this$master = this.getMaster();
            String other$master = other.getMaster();
            return !(this$master == null ? other$master != null : !this$master.equals(other$master));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Content;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Project $project = this.getProject();
            result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
            String $master = this.getMaster();
            result = result * 59 + ($master == null ? 43 : $master.hashCode());
            return result;
        }

        public String toString() {
            return "BuildEvent.Content(project=" + this.getProject() + ", master=" + this.getMaster() + ")";
        }

        public Content(Project project, String master) {
            this.project = project;
            this.master = master;
        }

        public Content() {
        }
    }
}

