/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50;

import com.netflix.spinnaker.front50.model.ItemDAO;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.scheduling.TaskScheduler;

public class ItemDAOHealthIndicator
implements HealthIndicator,
Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ItemDAO itemDAO;
    private final AtomicReference<Health> lastHealth = new AtomicReference<Object>(null);

    public ItemDAOHealthIndicator(ItemDAO<?> itemDAO, TaskScheduler taskScheduler) {
        this.itemDAO = itemDAO;
        taskScheduler.scheduleWithFixedDelay((Runnable)this, itemDAO.getHealthIntervalMillis());
    }

    public Health health() {
        if (this.lastHealth.get() == null) {
            return new Health.Builder().down().build();
        }
        return this.lastHealth.get();
    }

    @Override
    public void run() {
        Health.Builder healthBuilder = new Health.Builder().up();
        try {
            if (this.itemDAO.isHealthy()) {
                healthBuilder.withDetail(this.itemDAO.getClass().getSimpleName(), (Object)"Healthy");
            } else {
                healthBuilder.down().withDetail(this.itemDAO.getClass().getSimpleName(), (Object)"Unhealthy");
            }
        }
        catch (RuntimeException e) {
            this.log.error("ItemDAO {} health check failed", (Object)this.itemDAO.getClass().getSimpleName(), (Object)e);
            healthBuilder.down().withDetail(this.itemDAO.getClass().getSimpleName(), (Object)String.format("Unhealthy: `%s`", e.getMessage()));
        }
        this.lastHealth.set(healthBuilder.build());
    }
}

