/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.config;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.PluginsAutoConfiguration;
import com.netflix.spinnaker.fiat.shared.EnableFiatAutoConfig;
import com.netflix.spinnaker.fiat.shared.FiatClientConfigurationProperties;
import com.netflix.spinnaker.fiat.shared.FiatStatus;
import com.netflix.spinnaker.filters.AuthenticatedRequestFilter;
import com.netflix.spinnaker.front50.ItemDAOHealthIndicator;
import com.netflix.spinnaker.front50.config.StorageServiceConfigurationProperties;
import com.netflix.spinnaker.front50.model.ItemDAO;
import com.netflix.spinnaker.front50.model.application.ApplicationDAO;
import com.netflix.spinnaker.front50.model.application.ApplicationPermissionDAO;
import com.netflix.spinnaker.front50.model.delivery.DeliveryRepository;
import com.netflix.spinnaker.front50.model.pipeline.PipelineDAO;
import com.netflix.spinnaker.front50.model.pipeline.PipelineStrategyDAO;
import com.netflix.spinnaker.front50.model.pipeline.PipelineTemplateDAO;
import com.netflix.spinnaker.front50.model.project.ProjectDAO;
import com.netflix.spinnaker.front50.model.serviceaccount.ServiceAccountDAO;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.web.context.AuthenticatedRequestContextProvider;
import com.netflix.spinnaker.kork.web.context.RequestContextProvider;
import com.netflix.spinnaker.kork.web.interceptors.MetricsInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ComponentScan
@EnableFiatAutoConfig
@EnableScheduling
@Import(value={PluginsAutoConfiguration.class})
@EnableConfigurationProperties(value={StorageServiceConfigurationProperties.class})
public class Front50WebConfig
extends WebMvcConfigurerAdapter {
    @Autowired
    private Registry registry;

    @Bean
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("scheduler-");
        scheduler.setPoolSize(10);
        return scheduler;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new MetricsInterceptor(this.registry, "controller.invocations", new ArrayList<String>(Arrays.asList("account", "application")), new ArrayList<String>(Collections.singletonList("BasicErrorController"))));
    }

    @Bean
    public FilterRegistrationBean<?> authenticatedRequestFilter() {
        FilterRegistrationBean frb = new FilterRegistrationBean((Filter)new AuthenticatedRequestFilter(true), new ServletRegistrationBean[0]);
        frb.setOrder(Integer.MIN_VALUE);
        return frb;
    }

    @Bean
    public ItemDAOHealthIndicator applicationDAOHealthIndicator(ApplicationDAO applicationDAO, TaskScheduler taskScheduler) {
        return new ItemDAOHealthIndicator((ItemDAO<?>)applicationDAO, taskScheduler);
    }

    @Bean
    public ItemDAOHealthIndicator projectDAOHealthIndicator(ProjectDAO projectDAO, TaskScheduler taskScheduler) {
        return new ItemDAOHealthIndicator((ItemDAO<?>)projectDAO, taskScheduler);
    }

    @Bean
    public ItemDAOHealthIndicator pipelineDAOHealthIndicator(PipelineDAO pipelineDAO, TaskScheduler taskScheduler) {
        return new ItemDAOHealthIndicator((ItemDAO<?>)pipelineDAO, taskScheduler);
    }

    @Bean
    @ConditionalOnBean(value={PipelineTemplateDAO.class})
    public ItemDAOHealthIndicator pipelineTemplateDAOHealthIndicator(PipelineTemplateDAO pipelineTemplateDAO, TaskScheduler taskScheduler) {
        return new ItemDAOHealthIndicator((ItemDAO<?>)pipelineTemplateDAO, taskScheduler);
    }

    @Bean
    public ItemDAOHealthIndicator pipelineStrategyDAOHealthIndicator(PipelineStrategyDAO pipelineStrategyDAO, TaskScheduler taskScheduler) {
        return new ItemDAOHealthIndicator((ItemDAO<?>)pipelineStrategyDAO, taskScheduler);
    }

    @Bean
    @ConditionalOnBean(value={ApplicationPermissionDAO.class})
    public ItemDAOHealthIndicator applicationPermissionDAOHealthIndicator(ApplicationPermissionDAO applicationPermissionDAO, TaskScheduler taskScheduler) {
        return new ItemDAOHealthIndicator((ItemDAO<?>)applicationPermissionDAO, taskScheduler);
    }

    @Bean
    @ConditionalOnBean(value={ServiceAccountDAO.class})
    public ItemDAOHealthIndicator serviceAccountDAOHealthIndicator(ServiceAccountDAO serviceAccountDAO, TaskScheduler taskScheduler) {
        return new ItemDAOHealthIndicator((ItemDAO<?>)serviceAccountDAO, taskScheduler);
    }

    @Bean
    @ConditionalOnBean(value={DeliveryRepository.class})
    public ItemDAOHealthIndicator deliveryRepositoryHealthIndicator(DeliveryRepository deliveryRepository, TaskScheduler taskScheduler) {
        return new ItemDAOHealthIndicator((ItemDAO<?>)deliveryRepository, taskScheduler);
    }

    @Bean
    public RequestContextProvider requestContextProvider() {
        return new AuthenticatedRequestContextProvider();
    }

    @Bean
    public FiatStatus fiatStatus(DynamicConfigService dynamicConfigService, Registry registry, FiatClientConfigurationProperties fiatClientConfigurationProperties) {
        return new FiatStatus(registry, dynamicConfigService, fiatClientConfigurationProperties);
    }
}

