/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.netflix.spinnaker.front50.model.AdminOperations;
import com.netflix.spinnaker.front50.model.ObjectType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin"})
@Api(value="admin", description="Various administrative operations")
public class AdminController {
    private final Collection<AdminOperations> adminOperations;

    @Autowired
    public AdminController(Collection<AdminOperations> adminOperations) {
        this.adminOperations = adminOperations;
    }

    @ApiOperation(value="", notes="Recover a previously deleted object")
    @RequestMapping(value={"/recover"}, method={RequestMethod.POST})
    void recover(@RequestBody AdminOperations.Recover operation) {
        this.adminOperations.forEach(o -> o.recover(operation));
        if (operation.getObjectType().equalsIgnoreCase(ObjectType.APPLICATION.clazz.getSimpleName())) {
            this.adminOperations.forEach(o -> o.recover(new AdminOperations.Recover(ObjectType.APPLICATION_PERMISSION.clazz.getSimpleName(), operation.getObjectId())));
        }
    }
}

