/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import com.netflix.spinnaker.front50.api.model.pipeline.Pipeline;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
public class AuthorizationSupport {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationSupport.class);
    private final FiatPermissionEvaluator permissionEvaluator;

    public AuthorizationSupport(FiatPermissionEvaluator permissionEvaluator) {
        this.permissionEvaluator = permissionEvaluator;
    }

    public boolean hasRunAsUserPermission(Pipeline pipeline) {
        List runAsUsers = Optional.ofNullable(pipeline.getTriggers()).map(triggers -> triggers.stream().map(it -> (String)it.get((Object)"runAsUser")).filter(Objects::nonNull).collect(Collectors.toList())).orElse(Collections.emptyList());
        if (runAsUsers.isEmpty()) {
            return true;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return runAsUsers.stream().noneMatch(runAsUser -> {
            if (!this.userCanAccessServiceAccount(auth, (String)runAsUser)) {
                log.error("User {} does not have access to service account {}", Optional.ofNullable(auth).map(Authentication::getPrincipal).orElse("unknown"), runAsUser);
                return true;
            }
            if (!this.serviceAccountCanAccessApplication((String)runAsUser, pipeline.getApplication())) {
                log.error("Service account {} does not have access to application {}", runAsUser, (Object)pipeline.getApplication());
                return true;
            }
            return false;
        });
    }

    public boolean userCanAccessServiceAccount(Authentication auth, String runAsUser) {
        return this.permissionEvaluator.hasPermission(auth, (Serializable)((Object)runAsUser), "SERVICE_ACCOUNT", (Object)"ignored-svcAcct-auth");
    }

    public boolean serviceAccountCanAccessApplication(String runAsUser, String application) {
        PreAuthenticatedAuthenticationToken auth = new PreAuthenticatedAuthenticationToken((Object)runAsUser, null, new ArrayList());
        return this.permissionEvaluator.hasPermission((Authentication)auth, (Serializable)((Object)application), "APPLICATION", (Object)"EXECUTE");
    }
}

