/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.google.common.base.Strings;
import com.netflix.spinnaker.front50.UntypedUtils;
import com.netflix.spinnaker.front50.model.notification.HierarchicalLevel;
import com.netflix.spinnaker.front50.model.notification.Notification;
import com.netflix.spinnaker.front50.model.notification.NotificationDAO;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"notifications"})
public class NotificationController {
    private static final Logger log = LoggerFactory.getLogger(NotificationController.class);
    private final NotificationDAO notificationDAO;

    public NotificationController(NotificationDAO notificationDAO) {
        this.notificationDAO = notificationDAO;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Collection<Notification> list() {
        return this.notificationDAO.all();
    }

    @RequestMapping(value={"global"}, method={RequestMethod.GET})
    public Notification getGlobal() {
        return this.notificationDAO.getGlobal();
    }

    @RequestMapping(value={"global"}, method={RequestMethod.POST})
    public void saveGlobal(@RequestBody Notification notification) {
        this.notificationDAO.saveGlobal(notification);
    }

    @PostAuthorize(value="hasPermission(#name, 'APPLICATION', 'READ')")
    @RequestMapping(value={"{type}/{name}"}, method={RequestMethod.GET})
    public Notification listByApplication(@PathVariable(value="type") String type, @PathVariable(value="name") String name) {
        HierarchicalLevel level = NotificationController.getLevel(type);
        Notification notification = this.notificationDAO.get(level, name);
        if (level.equals((Object)HierarchicalLevel.APPLICATION)) {
            Notification global = this.getGlobal();
            NotificationDAO.NOTIFICATION_FORMATS.forEach(it -> {
                if (UntypedUtils.hasProperty((Object)global, (String)it)) {
                    if (!UntypedUtils.hasProperty((Object)notification, (String)it)) {
                        UntypedUtils.setProperty((Object)notification, (String)it, new ArrayList());
                    }
                    ((List)UntypedUtils.getProperty((Object)notification, (String)it)).addAll((List)UntypedUtils.getProperty((Object)global, (String)it));
                }
            });
        }
        return notification;
    }

    @RequestMapping(value={"batchUpdate"}, method={RequestMethod.POST})
    public void batchUpdate(@RequestBody List<Notification> notifications) {
        notifications.forEach(it -> {
            try {
                this.save("application", (String)it.get((Object)"application"), (Notification)it);
                log.info("inserted {}", it);
            }
            catch (Exception e) {
                log.error("could not insert {}", it, (Object)e);
            }
        });
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.storeWholePermission() and hasPermission(#name, 'APPLICATION', 'WRITE')")
    @RequestMapping(value={"{type}/{name}"}, method={RequestMethod.POST})
    public void save(@PathVariable(value="type") String type, @PathVariable(value="name") String name, @RequestBody Notification notification) {
        if (!Strings.isNullOrEmpty((String)name)) {
            this.notificationDAO.save(NotificationController.getLevel(type), name, notification);
        }
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.storeWholePermission() and hasPermission(#name, 'APPLICATION', 'WRITE')")
    @RequestMapping(value={"{type}/{name}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable(value="type") String type, @PathVariable(value="name") String name) {
        HierarchicalLevel level = NotificationController.getLevel(type);
        this.notificationDAO.delete(level, name);
    }

    private static HierarchicalLevel getLevel(String type) {
        HierarchicalLevel result = HierarchicalLevel.fromString((String)type);
        if (result == null) {
            throw new NotFoundException(String.format("No hierarchical level matches '%s'", type));
        }
        return result;
    }
}

