/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.netflix.spinnaker.front50.ApplicationPermissionsService;
import com.netflix.spinnaker.front50.model.application.Application;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/permissions"})
public class PermissionsController {
    private final ApplicationPermissionsService permissionsService;

    public PermissionsController(ApplicationPermissionsService permissionsService) {
        this.permissionsService = permissionsService;
    }

    @ApiOperation(value="", notes="Get all application permissions. Internal use only.")
    @RequestMapping(method={RequestMethod.GET}, value={"/applications"})
    public Set<Application.Permission> getAllApplicationPermissions() {
        return this.permissionsService.getAllApplicationPermissions();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/applications/{appName:.+}"})
    public Application.Permission getApplicationPermission(@PathVariable String appName) {
        return this.permissionsService.getApplicationPermission(appName);
    }

    @ApiOperation(value="", notes="Create an application permission.")
    @RequestMapping(method={RequestMethod.POST}, value={"/applications"})
    public Application.Permission createApplicationPermission(@RequestBody Application.Permission newPermission) {
        return this.permissionsService.createApplicationPermission(newPermission);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/applications/{appName:.+}"})
    public Application.Permission updateApplicationPermission(@PathVariable String appName, @RequestBody Application.Permission newPermission) {
        return this.permissionsService.updateApplicationPermission(appName, newPermission, false);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/applications/{appName:.+}"})
    public void deleteApplicationPermission(@PathVariable String appName) {
        this.permissionsService.deleteApplicationPermission(appName);
    }
}

