/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.netflix.spinnaker.front50.ServiceAccountsService;
import com.netflix.spinnaker.front50.api.model.pipeline.Pipeline;
import com.netflix.spinnaker.front50.api.validator.PipelineValidator;
import com.netflix.spinnaker.front50.api.validator.ValidatorErrors;
import com.netflix.spinnaker.front50.exception.BadRequestException;
import com.netflix.spinnaker.front50.exceptions.DuplicateEntityException;
import com.netflix.spinnaker.front50.exceptions.InvalidEntityException;
import com.netflix.spinnaker.front50.exceptions.InvalidRequestException;
import com.netflix.spinnaker.front50.model.pipeline.PipelineDAO;
import com.netflix.spinnaker.front50.model.pipeline.PipelineTemplateDAO;
import com.netflix.spinnaker.front50.model.pipeline.TemplateConfiguration;
import com.netflix.spinnaker.front50.model.pipeline.V2TemplateConfiguration;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import com.netflix.spinnaker.kork.web.exceptions.ValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"pipelines"})
public class PipelineController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PipelineDAO pipelineDAO;
    private final ObjectMapper objectMapper;
    private final Optional<ServiceAccountsService> serviceAccountsService;
    private final List<PipelineValidator> pipelineValidators;
    private final Optional<PipelineTemplateDAO> pipelineTemplateDAO;

    public PipelineController(PipelineDAO pipelineDAO, ObjectMapper objectMapper, Optional<ServiceAccountsService> serviceAccountsService, List<PipelineValidator> pipelineValidators, Optional<PipelineTemplateDAO> pipelineTemplateDAO) {
        this.pipelineDAO = pipelineDAO;
        this.objectMapper = objectMapper;
        this.serviceAccountsService = serviceAccountsService;
        this.pipelineValidators = pipelineValidators;
        this.pipelineTemplateDAO = pipelineTemplateDAO;
    }

    @PreAuthorize(value="#restricted ? @fiatPermissionEvaluator.storeWholePermission() : true")
    @PostFilter(value="#restricted ? hasPermission(filterObject.name, 'APPLICATION', 'READ') : true")
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Collection<Pipeline> list(@RequestParam(required=false, value="restricted", defaultValue="true") boolean restricted, @RequestParam(required=false, value="refresh", defaultValue="true") boolean refresh) {
        return this.pipelineDAO.all(refresh);
    }

    @PreAuthorize(value="hasPermission(#application, 'APPLICATION', 'READ')")
    @RequestMapping(value={"{application:.+}"}, method={RequestMethod.GET})
    public List<Pipeline> listByApplication(@PathVariable(value="application") String application, @RequestParam(required=false, value="refresh", defaultValue="true") boolean refresh) {
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>(this.pipelineDAO.getPipelinesByApplication(application, refresh));
        pipelines.sort((p1, p2) -> {
            if (p1.getIndex() != null && p2.getIndex() == null) {
                return -1;
            }
            if (p1.getIndex() == null && p2.getIndex() != null) {
                return 1;
            }
            if (p1.getIndex() != null && p2.getIndex() != null && !p1.getIndex().equals(p2.getIndex())) {
                return p1.getIndex() - p2.getIndex();
            }
            return Optional.ofNullable(p1.getName()).orElse(p1.getId()).compareToIgnoreCase(Optional.ofNullable(p2.getName()).orElse(p2.getId()));
        });
        int i = 0;
        for (Pipeline p : pipelines) {
            p.setIndex(Integer.valueOf(i));
            ++i;
        }
        return pipelines;
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.storeWholePermission()")
    @PostFilter(value="hasPermission(filterObject.application, 'APPLICATION', 'READ')")
    @RequestMapping(value={"{id:.+}/history"}, method={RequestMethod.GET})
    public Collection<Pipeline> getHistory(@PathVariable String id, @RequestParam(value="limit", defaultValue="20") int limit) {
        return this.pipelineDAO.history(id, limit);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.storeWholePermission()")
    @PostAuthorize(value="hasPermission(returnObject.application, 'APPLICATION', 'READ')")
    @RequestMapping(value={"{id:.+}/get"}, method={RequestMethod.GET})
    public Pipeline get(@PathVariable String id) {
        return (Pipeline)this.pipelineDAO.findById(id);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.storeWholePermission() and hasPermission(#pipeline.application, 'APPLICATION', 'WRITE') and @authorizationSupport.hasRunAsUserPermission(#pipeline)")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public Pipeline save(@RequestBody Pipeline pipeline, @RequestParam(value="staleCheck", required=false, defaultValue="false") Boolean staleCheck) {
        this.validatePipeline(pipeline, staleCheck);
        pipeline.setName(pipeline.getName().trim());
        pipeline = PipelineController.ensureCronTriggersHaveIdentifier(pipeline);
        if (Strings.isNullOrEmpty((String)pipeline.getId())) {
            List triggers = pipeline.getTriggers();
            triggers.stream().filter(it -> "cron".equals(it.getType())).forEach(it -> it.put((Object)"id", (Object)UUID.randomUUID().toString()));
            pipeline.setTriggers(triggers);
        }
        return (Pipeline)this.pipelineDAO.create(pipeline.getId(), (Object)pipeline);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.isAdmin()")
    @RequestMapping(value={"batchUpdate"}, method={RequestMethod.POST})
    public void batchUpdate(@RequestBody List<Pipeline> pipelines) {
        this.pipelineDAO.bulkImport(pipelines);
    }

    @PreAuthorize(value="hasPermission(#application, 'APPLICATION', 'WRITE')")
    @RequestMapping(value={"{application}/{pipeline:.+}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable String application, @PathVariable String pipeline) {
        String pipelineId = this.pipelineDAO.getPipelineId(application, pipeline);
        this.log.info("Deleting pipeline \"{}\" with id {} in application {}", new Object[]{pipeline, pipelineId, application});
        this.pipelineDAO.delete(pipelineId);
        this.serviceAccountsService.ifPresent(accountsService -> accountsService.deleteManagedServiceAccounts(Collections.singletonList(pipelineId)));
    }

    public void delete(@PathVariable String id) {
        this.pipelineDAO.delete(id);
        this.serviceAccountsService.ifPresent(accountsService -> accountsService.deleteManagedServiceAccounts(Collections.singletonList(id)));
    }

    @PreAuthorize(value="hasPermission(#pipeline.application, 'APPLICATION', 'WRITE')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public Pipeline update(@PathVariable String id, @RequestParam(value="staleCheck", required=false, defaultValue="false") Boolean staleCheck, @RequestBody Pipeline pipeline) {
        Pipeline existingPipeline = (Pipeline)this.pipelineDAO.findById(id);
        if (!pipeline.getId().equals(existingPipeline.getId())) {
            throw new InvalidRequestException(String.format("The provided id %s doesn't match the pipeline id %s", pipeline.getId(), existingPipeline.getId()));
        }
        this.validatePipeline(pipeline, staleCheck);
        pipeline.setName(pipeline.getName().trim());
        pipeline.setLastModified(Long.valueOf(System.currentTimeMillis()));
        pipeline = PipelineController.ensureCronTriggersHaveIdentifier(pipeline);
        this.pipelineDAO.update(id, (Object)pipeline);
        return pipeline;
    }

    private void validatePipeline(Pipeline pipeline, Boolean staleCheck) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{pipeline.getApplication(), pipeline.getName()})) {
            throw new InvalidEntityException("A pipeline requires name and application fields");
        }
        if ("templatedPipeline".equals(pipeline.getType())) {
            String source;
            PipelineTemplateDAO templateDAO = this.getTemplateDAO();
            switch (pipeline.getSchema()) {
                case "v2": {
                    V2TemplateConfiguration v2Config = (V2TemplateConfiguration)this.objectMapper.convertValue((Object)pipeline, V2TemplateConfiguration.class);
                    source = v2Config.getTemplate().getReference();
                    break;
                }
                default: {
                    TemplateConfiguration v1Config = (TemplateConfiguration)this.objectMapper.convertValue(pipeline.getConfig(), TemplateConfiguration.class);
                    source = v1Config.getPipeline().getTemplate().getSource();
                }
            }
            if (source.startsWith("spinnaker://")) {
                String templateId = source.substring("spinnaker://".length());
                try {
                    templateDAO.findById(templateId);
                }
                catch (NotFoundException notFoundEx) {
                    throw new BadRequestException("Configured pipeline template not found", (Throwable)notFoundEx);
                }
            }
        }
        this.checkForDuplicatePipeline(pipeline.getApplication(), pipeline.getName().trim(), pipeline.getId());
        ValidatorErrors errors = new ValidatorErrors();
        this.pipelineValidators.forEach(it -> it.validate(pipeline, errors));
        if (staleCheck.booleanValue() && !Strings.isNullOrEmpty((String)pipeline.getId()) && pipeline.getLastModified() != null) {
            this.checkForStalePipeline(pipeline, errors);
        }
        if (errors.hasErrors().booleanValue()) {
            String message = errors.getAllErrorsMessage();
            throw new ValidationException(message, (Collection)errors.getAllErrors());
        }
    }

    private PipelineTemplateDAO getTemplateDAO() {
        return this.pipelineTemplateDAO.orElseThrow(() -> new BadRequestException("Pipeline Templates are not supported with your current storage backend"));
    }

    private void checkForStalePipeline(Pipeline pipeline, ValidatorErrors errors) {
        Pipeline existingPipeline = (Pipeline)this.pipelineDAO.findById(pipeline.getId());
        Long storedUpdateTs = existingPipeline.getLastModified();
        Long submittedUpdateTs = pipeline.getLastModified();
        if (!submittedUpdateTs.equals(storedUpdateTs)) {
            errors.reject("The submitted pipeline is stale.  submitted updateTs " + submittedUpdateTs + " does not match stored updateTs " + storedUpdateTs);
        }
    }

    private void checkForDuplicatePipeline(String application, String name, String id) {
        boolean any = this.pipelineDAO.getPipelinesByApplication(application).stream().anyMatch(it -> it.getName().equalsIgnoreCase(name) && !it.getId().equals(id));
        if (any) {
            throw new DuplicateEntityException(String.format("A pipeline with name %s already exists in application %s", name, application));
        }
    }

    private void checkForDuplicatePipeline(String application, String name) {
        this.checkForDuplicatePipeline(application, name, null);
    }

    private static Pipeline ensureCronTriggersHaveIdentifier(Pipeline pipeline) {
        List triggers = pipeline.getTriggers();
        triggers.stream().filter(it -> "cron".equalsIgnoreCase(it.getType())).forEach(it -> {
            String triggerId = (String)it.get((Object)"id");
            if (triggerId == null || triggerId.isEmpty()) {
                triggerId = UUID.randomUUID().toString();
            }
            it.put((Object)"id", (Object)triggerId);
        });
        pipeline.setTriggers(triggers);
        return pipeline;
    }
}

