/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.front50.api.model.pipeline.Pipeline;
import com.netflix.spinnaker.front50.exception.BadRequestException;
import com.netflix.spinnaker.front50.exceptions.DuplicateEntityException;
import com.netflix.spinnaker.front50.exceptions.InvalidEntityException;
import com.netflix.spinnaker.front50.exceptions.InvalidRequestException;
import com.netflix.spinnaker.front50.model.pipeline.PipelineDAO;
import com.netflix.spinnaker.front50.model.pipeline.PipelineTemplate;
import com.netflix.spinnaker.front50.model.pipeline.PipelineTemplateDAO;
import com.netflix.spinnaker.front50.model.pipeline.TemplateConfiguration;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"pipelineTemplates"})
public class PipelineTemplateController {
    @Autowired(required=false)
    PipelineTemplateDAO pipelineTemplateDAO = null;
    @Autowired
    PipelineDAO pipelineDAO;
    @Autowired
    ObjectMapper objectMapper;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    List<PipelineTemplate> list(@RequestParam(required=false, value="scopes") List<String> scopes) {
        return (List)this.getPipelineTemplateDAO().getPipelineTemplatesByScope(scopes);
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    void save(@RequestBody PipelineTemplate pipelineTemplate) {
        this.validatePipelineTemplate(pipelineTemplate);
        this.getPipelineTemplateDAO().create(pipelineTemplate.getId(), (Object)pipelineTemplate);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    PipelineTemplate get(@PathVariable String id) {
        return (PipelineTemplate)this.getPipelineTemplateDAO().findById(id);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.PUT})
    PipelineTemplate update(@PathVariable String id, @RequestBody PipelineTemplate pipelineTemplate) {
        PipelineTemplate existingPipelineTemplate = (PipelineTemplate)this.getPipelineTemplateDAO().findById(id);
        if (!pipelineTemplate.getId().equals(existingPipelineTemplate.getId())) {
            throw new InvalidRequestException("The provided id " + id + " doesn't match the pipeline template id " + pipelineTemplate.getId());
        }
        pipelineTemplate.setLastModified(Long.valueOf(System.currentTimeMillis()));
        this.getPipelineTemplateDAO().update(id, (Object)pipelineTemplate);
        return pipelineTemplate;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    void delete(@PathVariable String id) {
        this.checkForDependentConfigs(id, true);
        this.checkForDependentTemplates(id);
        this.getPipelineTemplateDAO().delete(id);
    }

    @RequestMapping(value={"{id}/dependentPipelines"}, method={RequestMethod.GET})
    List<Pipeline> listDependentPipelines(@PathVariable String id, @RequestParam(required=false, value="recursive", defaultValue="false") boolean recursive) {
        List<String> dependentConfigsIds = this.getDependentConfigs(id, recursive);
        return this.pipelineDAO.all().stream().filter(pipeline -> dependentConfigsIds.contains(pipeline.getId())).collect(Collectors.toList());
    }

    @VisibleForTesting
    List<String> getDependentConfigs(String templateId, boolean recursive) {
        ArrayList<String> dependentConfigIds = new ArrayList<String>();
        List<String> templateIds = this.convertAllTemplateIdsToSources(templateId, recursive);
        this.pipelineDAO.all().stream().filter(pipeline -> pipeline.getType() != null && pipeline.getType().equals("templatedPipeline")).forEach(templatedPipeline -> {
            String source;
            try {
                TemplateConfiguration config = (TemplateConfiguration)this.objectMapper.convertValue(templatedPipeline.getConfig(), TemplateConfiguration.class);
                source = config.getPipeline().getTemplate().getSource();
            }
            catch (Exception e) {
                return;
            }
            if (source != null && PipelineTemplateController.containsAnyIgnoreCase(source, templateIds)) {
                dependentConfigIds.add(templatedPipeline.getId());
            }
        });
        return dependentConfigIds;
    }

    private List<String> convertAllTemplateIdsToSources(String rootTemplateId, boolean recursive) {
        ArrayList<String> templateIds = new ArrayList<String>();
        templateIds.add("spinnaker://" + rootTemplateId);
        if (recursive) {
            for (String id : this.getDependentTemplates(rootTemplateId, Optional.empty())) {
                templateIds.add("spinnaker://" + id);
            }
        }
        return templateIds;
    }

    private static boolean containsAnyIgnoreCase(String source, List<String> templateIds) {
        for (String templateId : templateIds) {
            if (!source.equalsIgnoreCase(templateId)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void checkForDependentConfigs(String templateId, boolean recursive) {
        List<String> dependentConfigIds = this.getDependentConfigs(templateId, recursive);
        if (dependentConfigIds.size() != 0) {
            throw new InvalidRequestException("The following pipeline configs depend on this template: " + String.join((CharSequence)", ", dependentConfigIds));
        }
    }

    @VisibleForTesting
    List<String> getDependentTemplates(String templateId, Optional<Collection<PipelineTemplate>> templates) {
        ArrayList<String> dependentTemplateIds = new ArrayList<String>();
        Collection<PipelineTemplate> pipelineTemplates = templates.orElse(this.getPipelineTemplateDAO().all());
        pipelineTemplates.forEach(template -> {
            if (template.getSource() != null && template.getSource().equalsIgnoreCase("spinnaker://" + templateId)) {
                dependentTemplateIds.add(template.getId());
                dependentTemplateIds.addAll(this.getDependentTemplates(template.getId(), Optional.of(pipelineTemplates)));
            }
        });
        return dependentTemplateIds;
    }

    @VisibleForTesting
    void checkForDependentTemplates(String templateId) {
        List<String> dependentTemplateIds = this.getDependentTemplates(templateId, Optional.empty());
        if (dependentTemplateIds.size() != 0) {
            throw new InvalidRequestException("The following pipeline templates depend on this template: " + String.join((CharSequence)", ", dependentTemplateIds));
        }
    }

    private void validatePipelineTemplate(PipelineTemplate pipelineTemplate) {
        String pipelineTemplateId = pipelineTemplate.getId();
        if (StringUtils.isBlank((CharSequence)pipelineTemplateId)) {
            throw new InvalidEntityException("A pipeline template requires an id");
        }
        try {
            if (this.getPipelineTemplateDAO().findById(pipelineTemplateId) != null) {
                throw new DuplicateEntityException("A pipeline template with the id " + pipelineTemplateId + " already exists");
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private PipelineTemplateDAO getPipelineTemplateDAO() {
        if (this.pipelineTemplateDAO == null) {
            throw new BadRequestException("Pipeline Templates are not supported with your current storage backend");
        }
        return this.pipelineTemplateDAO;
    }
}

