/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.google.common.hash.Hashing;
import com.netflix.spinnaker.front50.plugins.PluginBinaryStorageService;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/pluginBinaries"})
public class PluginBinaryController {
    private final Optional<PluginBinaryStorageService> pluginBinaryStorageService;

    public PluginBinaryController(Optional<PluginBinaryStorageService> pluginBinaryStorageService) {
        this.pluginBinaryStorageService = pluginBinaryStorageService;
    }

    @PostMapping(value={"/{id}/{version}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    void upload(@PathVariable String id, @PathVariable String version, @RequestParam(value="sha512sum") String sha512sum, @RequestParam(value="plugin") MultipartFile body) {
        byte[] bytes = body.getBytes();
        this.verifyChecksum(bytes, sha512sum);
        this.storageService().store(this.storageService().getKey(id, version), bytes);
    }

    @GetMapping(value={"/{id}/{version}"})
    ResponseEntity<byte[]> getBinary(@PathVariable String id, @PathVariable String version) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"application/octet-stream"})).body((Object)this.storageService().load(this.storageService().getKey(id, version)));
    }

    private void verifyChecksum(byte[] body, String sha512sum) {
        String sha = Hashing.sha512().hashBytes(body).toString();
        if (!sha.equals(sha512sum)) {
            throw new SystemException("Plugin binary checksum does not match expected checksum value").setRetryable(Boolean.valueOf(true));
        }
    }

    private PluginBinaryStorageService storageService() {
        return this.pluginBinaryStorageService.orElseThrow(() -> new IllegalArgumentException("Plugin binary storage service is yet not available for your persistence backend"));
    }
}

