/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.netflix.spinnaker.front50.config.annotations.ConditionalOnAnyProviderExceptRedisIsEnabled;
import com.netflix.spinnaker.front50.model.plugins.PluginInfo;
import com.netflix.spinnaker.front50.model.plugins.PluginInfoService;
import java.util.Collection;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pluginInfo"})
@Validated
@ConditionalOnAnyProviderExceptRedisIsEnabled
public class PluginInfoController {
    private final PluginInfoService pluginInfoService;

    public PluginInfoController(PluginInfoService pluginInfoService) {
        this.pluginInfoService = pluginInfoService;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    Collection<PluginInfo> list(@RequestParam(value="service", required=false) String service) {
        return Optional.ofNullable(service).map(arg_0 -> ((PluginInfoService)this.pluginInfoService).findAllByService(arg_0)).orElseGet(() -> ((PluginInfoService)this.pluginInfoService).findAll());
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    PluginInfo get(@PathVariable String id) {
        return this.pluginInfoService.findById(id);
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    PluginInfo upsert(@Valid @RequestBody PluginInfo pluginInfo) {
        return this.pluginInfoService.upsert(pluginInfo);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.isAdmin()")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    void delete(@PathVariable String id) {
        this.pluginInfoService.delete(id);
    }

    @RequestMapping(value={"/{id}/releases"}, method={RequestMethod.POST})
    PluginInfo createRelease(@PathVariable String id, @Valid @RequestBody PluginInfo.Release release) {
        return this.pluginInfoService.createRelease(id, release);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.isAdmin()")
    @RequestMapping(value={"/{id}/releases"}, method={RequestMethod.PUT})
    PluginInfo upsertRelease(@PathVariable String id, @Valid @RequestBody PluginInfo.Release release) {
        return this.pluginInfoService.upsertRelease(id, release);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.isAdmin()")
    @RequestMapping(value={"/{id}/releases/{releaseVersion}"}, method={RequestMethod.PUT})
    PluginInfo.Release preferReleaseVersion(@PathVariable String id, @PathVariable @Pattern(regexp="^[0-9]\\d*\\.\\d+\\.\\d+(?:-[a-zA-Z0-9]+)?$") @Pattern(regexp="^[0-9]\\d*\\.\\d+\\.\\d+(?:-[a-zA-Z0-9]+)?$") String releaseVersion, @RequestParam(value="preferred") boolean preferred) {
        return this.pluginInfoService.preferReleaseVersion(id, releaseVersion, preferred);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.isAdmin()")
    @RequestMapping(value={"/{id}/releases/{releaseVersion}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    PluginInfo deleteRelease(@PathVariable String id, @PathVariable @Pattern(regexp="^[0-9]\\d*\\.\\d+\\.\\d+(?:-[a-zA-Z0-9]+)?$") @Pattern(regexp="^[0-9]\\d*\\.\\d+\\.\\d+(?:-[a-zA-Z0-9]+)?$") String releaseVersion) {
        return this.pluginInfoService.deleteRelease(id, releaseVersion);
    }
}

