/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.netflix.spinnaker.front50.config.annotations.ConditionalOnAnyProviderExceptRedisIsEnabled;
import com.netflix.spinnaker.front50.model.plugins.PluginInfo;
import com.netflix.spinnaker.front50.model.plugins.PluginVersionPinningService;
import java.util.Map;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pluginVersions"})
@ConditionalOnAnyProviderExceptRedisIsEnabled
public class PluginVersionController {
    private final PluginVersionPinningService pluginVersionPinningService;

    public PluginVersionController(PluginVersionPinningService pluginVersionPinningService) {
        this.pluginVersionPinningService = pluginVersionPinningService;
    }

    @PutMapping(value={"/{serverGroupName}"})
    Map<String, PluginInfo.Release> pinVersions(@PathVariable String serverGroupName, @RequestParam String location, @RequestParam String serviceName, @RequestBody Map<String, String> pinnedVersions) {
        return this.pluginVersionPinningService.pinVersions(serviceName, location, serverGroupName, pinnedVersions);
    }
}

