/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import com.netflix.spinnaker.front50.api.model.pipeline.Pipeline;
import com.netflix.spinnaker.front50.exceptions.InvalidRequestException;
import com.netflix.spinnaker.front50.model.ItemDAO;
import com.netflix.spinnaker.front50.model.pipeline.PipelineDAO;
import com.netflix.spinnaker.front50.model.pipeline.PipelineStrategyDAO;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"actions"})
class ReorderPipelinesController {
    @Autowired
    FiatPermissionEvaluator fiatPermissionEvaluator;
    @Autowired
    PipelineDAO pipelineDAO;
    @Autowired
    PipelineStrategyDAO pipelineStrategyDAO;

    ReorderPipelinesController() {
    }

    @RequestMapping(value={"/pipelines/reorder"}, method={RequestMethod.POST})
    void reorderPipelines(@RequestBody Map<String, Object> requestBody) {
        this.handlePipelineReorder(requestBody, (ItemDAO<Pipeline>)this.pipelineDAO);
    }

    @RequestMapping(value={"/strategies/reorder"}, method={RequestMethod.POST})
    void reorderPipelineStrategies(@RequestBody Map<String, Object> requestBody) {
        this.handlePipelineReorder(requestBody, (ItemDAO<Pipeline>)this.pipelineStrategyDAO);
    }

    private void handlePipelineReorder(Map<String, Object> requestBody, ItemDAO<Pipeline> pipelineItemDAO) {
        String application = (String)requestBody.get("application");
        Map idsToIndices = (Map)requestBody.get("idsToIndices");
        if (application == null) {
            throw new InvalidRequestException("`application` is required field on request body");
        }
        if (idsToIndices == null) {
            throw new InvalidRequestException("`idsToIndices` is required field on request body");
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (!this.fiatPermissionEvaluator.storeWholePermission() && !this.fiatPermissionEvaluator.hasPermission(auth, (Serializable)((Object)application), "APPLICATION", (Object)"WRITE")) {
            throw new InvalidRequestException("Application write permission is required to reorder pipelines");
        }
        for (String id : idsToIndices.keySet()) {
            Pipeline pipeline = (Pipeline)pipelineItemDAO.findById(id);
            if (pipeline == null) {
                throw new NotFoundException(String.format("No pipeline of id %s found", id));
            }
            if (!pipeline.getApplication().equals(application)) {
                throw new InvalidRequestException(String.format("Pipeline with id %s does not belong to application %s", id, application));
            }
            pipeline.setIndex((Integer)idsToIndices.get(id));
            pipelineItemDAO.update(id, (Object)pipeline);
        }
    }
}

