/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.netflix.spinnaker.front50.ServiceAccountsService;
import com.netflix.spinnaker.front50.config.annotations.ConditionalOnAnyProviderExceptRedisIsEnabled;
import com.netflix.spinnaker.front50.model.serviceaccount.ServiceAccount;
import java.util.HashSet;
import java.util.Set;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/serviceAccounts"})
@ConditionalOnAnyProviderExceptRedisIsEnabled
public class ServiceAccountsController {
    private final ServiceAccountsService serviceAccountService;

    public ServiceAccountsController(ServiceAccountsService serviceAccountService) {
        this.serviceAccountService = serviceAccountService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public Set<ServiceAccount> getAllServiceAccounts() {
        return new HashSet<ServiceAccount>(this.serviceAccountService.getAllServiceAccounts());
    }

    @RequestMapping(method={RequestMethod.POST})
    public ServiceAccount createServiceAccount(@RequestBody ServiceAccount serviceAccount) {
        return this.serviceAccountService.createServiceAccount(serviceAccount);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{serviceAccountId:.+}"})
    public void deleteServiceAccount(@PathVariable String serviceAccountId) {
        this.serviceAccountService.deleteServiceAccount(serviceAccountId);
    }
}

