/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.google.common.base.Strings;
import com.netflix.spinnaker.front50.config.annotations.ConditionalOnAnyProviderExceptRedisIsEnabled;
import com.netflix.spinnaker.front50.exceptions.InvalidEntityException;
import com.netflix.spinnaker.front50.model.snapshot.Snapshot;
import com.netflix.spinnaker.front50.model.snapshot.SnapshotDAO;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.util.Collection;
import java.util.Objects;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/snapshots"})
@ConditionalOnAnyProviderExceptRedisIsEnabled
public class SnapshotsController {
    private final SnapshotDAO snapshotDAO;

    public SnapshotsController(SnapshotDAO snapshotDAO) {
        this.snapshotDAO = snapshotDAO;
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.storeWholePermission()")
    @PostFilter(value="hasPermission(filterObject.application, 'APPLICATION', 'READ')")
    @RequestMapping(value={"/{id:.+}/history"}, method={RequestMethod.GET})
    public Collection<Snapshot> getHistory(@PathVariable String id, @RequestParam(value="limit", defaultValue="20") int limit) {
        return this.snapshotDAO.history(id, limit);
    }

    @PostAuthorize(value="hasPermission(returnObject.application, 'APPLICATION', 'READ')")
    @RequestMapping(value={"/{id:.+}"}, method={RequestMethod.GET})
    public Snapshot getCurrent(@PathVariable String id) {
        return (Snapshot)this.snapshotDAO.findById(id);
    }

    @PostAuthorize(value="hasPermission(returnObject.application, 'APPLICATION', 'READ')")
    @RequestMapping(value={"/{id:.+}/{timestamp:.+}"}, method={RequestMethod.GET})
    public Snapshot getVersionByTimestamp(@PathVariable String id, @PathVariable String timestamp, @RequestParam(value="limit", defaultValue="20") int limit) {
        Long creationTime = Long.parseLong(timestamp);
        return this.snapshotDAO.history(id, limit).stream().filter(it -> Objects.equals(it.getTimestamp(), creationTime)).findFirst().orElseThrow(() -> new NotFoundException("Snapshot not found"));
    }

    @PreAuthorize(value="hasPermission(#snapshot.application, 'APPLICATION', 'WRITE')")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public void save(@RequestBody Snapshot snapshot) {
        if (Strings.isNullOrEmpty((String)snapshot.getApplication()) || Strings.isNullOrEmpty((String)snapshot.getAccount())) {
            throw new InvalidEntityException("A snapshot requires application and account fields");
        }
        String id = snapshot.getApplication() + "-" + snapshot.getAccount();
        this.snapshotDAO.create(id, (Object)snapshot);
    }
}

