/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.google.common.base.Strings;
import com.netflix.spinnaker.front50.api.model.pipeline.Pipeline;
import com.netflix.spinnaker.front50.exceptions.DuplicateEntityException;
import com.netflix.spinnaker.front50.exceptions.InvalidRequestException;
import com.netflix.spinnaker.front50.model.pipeline.PipelineStrategyDAO;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"strategies"})
public class StrategyController {
    private final PipelineStrategyDAO pipelineStrategyDAO;

    public StrategyController(PipelineStrategyDAO pipelineStrategyDAO) {
        this.pipelineStrategyDAO = pipelineStrategyDAO;
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.storeWholePermission()")
    @PostFilter(value="hasPermission(filterObject.application, 'APPLICATION', 'READ')")
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Collection<Pipeline> list() {
        return this.pipelineStrategyDAO.all();
    }

    @PreAuthorize(value="hasPermission(#application, 'APPLICATION', 'READ')")
    @RequestMapping(value={"{application:.+}"}, method={RequestMethod.GET})
    public Collection<Pipeline> listByApplication(@PathVariable(value="application") String application) {
        return this.pipelineStrategyDAO.getPipelinesByApplication(application);
    }

    @PostFilter(value="hasPermission(filterObject.application, 'APPLICATION', 'READ')")
    @RequestMapping(value={"{id:.+}/history"}, method={RequestMethod.GET})
    public Collection<Pipeline> getHistory(@PathVariable String id, @RequestParam(value="limit", defaultValue="20") int limit) {
        return this.pipelineStrategyDAO.history(id, limit);
    }

    @PreAuthorize(value="hasPermission(#strategy.application, 'APPLICATION', 'WRITE')")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public void save(@RequestBody Pipeline strategy) {
        if (Strings.isNullOrEmpty((String)strategy.getId())) {
            this.checkForDuplicatePipeline(strategy.getApplication(), strategy.getName());
            if (strategy.getTriggers() != null) {
                List triggers = strategy.getTriggers();
                triggers.stream().filter(it -> "cron".equals(it.getType())).forEach(it -> it.put((Object)"id", (Object)UUID.randomUUID().toString()));
                strategy.setTriggers(triggers);
            }
        }
        this.pipelineStrategyDAO.create(strategy.getId(), (Object)strategy);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.isAdmin()")
    @RequestMapping(value={"batchUpdate"}, method={RequestMethod.POST})
    public void batchUpdate(@RequestBody List<Pipeline> strategies) {
        this.pipelineStrategyDAO.bulkImport(strategies);
    }

    @PreAuthorize(value="hasPermission(#application, 'APPLICATION', 'WRITE')")
    @RequestMapping(value={"{application}/{strategy:.+}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable String application, @PathVariable String strategy) {
        this.pipelineStrategyDAO.delete(this.pipelineStrategyDAO.getPipelineId(application, strategy));
    }

    public void delete(@PathVariable String id) {
        this.pipelineStrategyDAO.delete(id);
    }

    @PreAuthorize(value="hasPermission(#strategy.application, 'APPLICATION', 'WRITE')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public Pipeline update(@PathVariable String id, @RequestBody Pipeline strategy) {
        Pipeline existingStrategy = (Pipeline)this.pipelineStrategyDAO.findById(id);
        if (!strategy.getId().equals(existingStrategy.getId())) {
            throw new InvalidRequestException(String.format("The provided id '%s' doesn't match the strategy id '%s'", id, strategy.getId()));
        }
        boolean alreadyExists = this.pipelineStrategyDAO.getPipelinesByApplication(strategy.getApplication()).stream().anyMatch(it -> it.getName().equalsIgnoreCase(strategy.getName()) && !it.getId().equals(id));
        if (alreadyExists) {
            throw new DuplicateEntityException(String.format("A strategy with name '%s' already exists in application '%s'", strategy.getName(), strategy.getApplication()));
        }
        strategy.setLastModified(Long.valueOf(System.currentTimeMillis()));
        this.pipelineStrategyDAO.update(id, (Object)strategy);
        return strategy;
    }

    private void checkForDuplicatePipeline(String application, String name) {
        boolean duplicate = this.pipelineStrategyDAO.getPipelinesByApplication(application).stream().anyMatch(it -> it.getName().equals(name));
        if (duplicate) {
            throw new DuplicateEntityException("A strategy with name " + name + " already exists in application " + application);
        }
    }
}

