/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.front50.api.model.pipeline.Pipeline;
import com.netflix.spinnaker.front50.exception.BadRequestException;
import com.netflix.spinnaker.front50.exceptions.DuplicateEntityException;
import com.netflix.spinnaker.front50.exceptions.InvalidEntityException;
import com.netflix.spinnaker.front50.exceptions.InvalidRequestException;
import com.netflix.spinnaker.front50.model.pipeline.PipelineDAO;
import com.netflix.spinnaker.front50.model.pipeline.PipelineTemplate;
import com.netflix.spinnaker.front50.model.pipeline.PipelineTemplateDAO;
import com.netflix.spinnaker.front50.model.pipeline.TemplateConfiguration;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/pipelineTemplates"})
public class V2PipelineTemplateController {
    private static final Logger log = LoggerFactory.getLogger(V2PipelineTemplateController.class);
    private static final List<String> VALID_TEMPLATE_TAGS = Arrays.asList("latest", "stable", "unstable", "experimental", "test", "canary");
    @Autowired(required=false)
    PipelineTemplateDAO pipelineTemplateDAO = null;
    @Autowired
    PipelineDAO pipelineDAO;
    @Autowired
    ObjectMapper objectMapper;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    List<PipelineTemplate> list(@RequestParam(required=false, value="scopes") List<String> scopes) {
        return (List)this.getPipelineTemplateDAO().getPipelineTemplatesByScope(scopes);
    }

    @RequestMapping(value={"versions"}, method={RequestMethod.GET})
    Map<String, List<PipelineTemplate>> listVersions(@RequestParam(required=false, value="scopes") List<String> scopes) {
        return this.getPipelineTemplateDAO().getPipelineTemplatesByScope(scopes).stream().filter(pt -> pt.getOrDefault((Object)"schema", (Object)"").equals("v2")).collect(Collectors.groupingBy(PipelineTemplate::undecoratedId));
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    void save(@RequestParam(value="tag", required=false) String tag, @RequestBody PipelineTemplate pipelineTemplate) {
        String templateId;
        if (StringUtils.isNotEmpty((CharSequence)tag)) {
            this.validatePipelineTemplateTag(tag);
        }
        if (StringUtils.isBlank((CharSequence)pipelineTemplate.getId())) {
            throw new InvalidEntityException("A pipeline template requires an id");
        }
        boolean nonEmptyTag = StringUtils.isNotEmpty((CharSequence)tag);
        if (nonEmptyTag) {
            templateId = String.format("%s:%s", pipelineTemplate.undecoratedId(), tag);
            pipelineTemplate.setTag(tag);
        } else {
            templateId = pipelineTemplate.undecoratedId();
        }
        this.checkForDuplicatePipelineTemplate(templateId);
        this.getPipelineTemplateDAO().create(templateId, (Object)pipelineTemplate);
        this.saveLatest(pipelineTemplate, tag);
        this.saveDigest(pipelineTemplate);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.PUT})
    PipelineTemplate update(@PathVariable String id, @RequestParam(value="tag", required=false) String tag, @RequestBody PipelineTemplate pipelineTemplate) {
        boolean nonEmptyTag = StringUtils.isNotEmpty((CharSequence)tag);
        if (nonEmptyTag) {
            this.validatePipelineTemplateTag(tag);
        }
        String templateId = nonEmptyTag ? String.format("%s:%s", id, tag) : pipelineTemplate.undecoratedId();
        pipelineTemplate.setTag(tag);
        pipelineTemplate.setLastModified(Long.valueOf(System.currentTimeMillis()));
        this.getPipelineTemplateDAO().update(templateId, (Object)pipelineTemplate);
        this.saveLatest(pipelineTemplate, tag);
        this.saveDigest(pipelineTemplate);
        return pipelineTemplate;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    PipelineTemplate get(@PathVariable String id, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="digest", required=false) String digest) {
        String templateId = this.formatId(id, tag, digest);
        PipelineTemplate foundTemplate = (PipelineTemplate)this.getPipelineTemplateDAO().findById(templateId);
        foundTemplate.remove((Object)"digest");
        foundTemplate.remove((Object)"tag");
        return foundTemplate;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    void delete(@PathVariable String id, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="digest", required=false) String digest) {
        String templateId = this.formatId(id, tag, digest);
        this.checkForDependentConfigs(templateId);
        this.getPipelineTemplateDAO().delete(templateId);
    }

    @RequestMapping(value={"{id}/dependentPipelines"}, method={RequestMethod.GET})
    List<Pipeline> listDependentPipelines(@PathVariable String id) {
        List<String> dependentConfigsIds = this.getDependentConfigs(id);
        return this.pipelineDAO.all().stream().filter(pipeline -> dependentConfigsIds.contains(pipeline.getId())).collect(Collectors.toList());
    }

    @VisibleForTesting
    List<String> getDependentConfigs(String templateId) {
        ArrayList<String> dependentConfigIds = new ArrayList<String>();
        String prefixedId = "spinnaker://" + templateId;
        this.pipelineDAO.all().stream().filter(pipeline -> pipeline.getType() != null && pipeline.getType().equals("templatedPipeline")).forEach(templatedPipeline -> {
            String source;
            try {
                TemplateConfiguration config = (TemplateConfiguration)this.objectMapper.convertValue(templatedPipeline.getConfig(), TemplateConfiguration.class);
                source = config.getPipeline().getTemplate().getSource();
            }
            catch (Exception e) {
                return;
            }
            if (source != null && source.equalsIgnoreCase(prefixedId)) {
                dependentConfigIds.add(templatedPipeline.getId());
            }
        });
        return dependentConfigIds;
    }

    @VisibleForTesting
    void checkForDependentConfigs(String templateId) {
        List<String> dependentConfigIds = this.getDependentConfigs(templateId);
        if (dependentConfigIds.size() != 0) {
            throw new InvalidRequestException("The following pipeline configs depend on this template: " + String.join((CharSequence)", ", dependentConfigIds));
        }
    }

    private void checkForDuplicatePipelineTemplate(String id) {
        try {
            this.getPipelineTemplateDAO().findById(id);
        }
        catch (NotFoundException e) {
            return;
        }
        throw new DuplicateEntityException("A pipeline template with the id " + id + " already exists");
    }

    @VisibleForTesting
    public String computeSHA256Digest(PipelineTemplate pipelineTemplate) {
        Map sortedMap = (Map)this.sortObjectRecursive(pipelineTemplate);
        try {
            String jsonPayload = this.objectMapper.writeValueAsString((Object)sortedMap).replaceAll("\\s+", "");
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(jsonPayload.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])hashBytes);
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new InvalidRequestException(String.format("Computing digest for pipeline template %s failed. Nested exception is %s", pipelineTemplate.undecoratedId(), e));
        }
    }

    private Object sortObjectRecursive(Object initialObj) {
        if (initialObj instanceof Map) {
            Map initialMap = (Map)initialObj;
            TreeMap sortedMap = new TreeMap();
            initialMap.forEach((k, v) -> sortedMap.put(k, this.sortObjectRecursive(v)));
            return sortedMap;
        }
        if (initialObj instanceof List) {
            List initialList = (List)initialObj;
            return initialList.stream().map(this::sortObjectRecursive).collect(Collectors.toList());
        }
        return initialObj;
    }

    private PipelineTemplateDAO getPipelineTemplateDAO() {
        if (this.pipelineTemplateDAO == null) {
            throw new BadRequestException("Pipeline Templates are not supported with your current storage backend");
        }
        return this.pipelineTemplateDAO;
    }

    private void validatePipelineTemplateTag(String tag) {
        if (!VALID_TEMPLATE_TAGS.contains(tag)) {
            throw new InvalidRequestException(String.format("The provided tag %s is not supported. Pipeline template must tag be one of %s", tag, VALID_TEMPLATE_TAGS));
        }
    }

    private String formatId(String id, String tag, String digest) {
        if (StringUtils.isNotEmpty((CharSequence)digest) && StringUtils.isNotEmpty((CharSequence)tag)) {
            throw new InvalidRequestException("Cannot query pipeline by 'tag' and 'digest' simultaneously. Specify one of 'tag' or 'digest'.");
        }
        if (StringUtils.isNotEmpty((CharSequence)digest)) {
            return String.format("%s@sha256:%s", id, digest);
        }
        if (StringUtils.isNotEmpty((CharSequence)tag)) {
            return String.format("%s:%s", id, tag);
        }
        return id;
    }

    private void saveDigest(PipelineTemplate pipelineTemplate) {
        pipelineTemplate.remove((Object)"digest");
        String lastModifiedBy = pipelineTemplate.removeLastModifiedBy();
        Long lastModified = pipelineTemplate.removeLastModified();
        String digest = this.computeSHA256Digest(pipelineTemplate);
        String digestId = String.format("%s@sha256:%s", pipelineTemplate.undecoratedId(), digest);
        pipelineTemplate.setDigest(digest);
        try {
            this.checkForDuplicatePipelineTemplate(digestId);
        }
        catch (DuplicateEntityException dee) {
            log.debug("Duplicate pipeline digest calculated, not updating key {}", (Object)digestId);
            return;
        }
        if (lastModified != null) {
            pipelineTemplate.setLastModified(lastModified);
        }
        if (StringUtils.isNotEmpty((CharSequence)lastModifiedBy)) {
            pipelineTemplate.setLastModifiedBy(lastModifiedBy);
        }
        this.getPipelineTemplateDAO().create(digestId, (Object)pipelineTemplate);
    }

    private void saveLatest(PipelineTemplate pipelineTemplate, String tag) {
        boolean nonLatestTag;
        boolean emptyTag = StringUtils.isEmpty((CharSequence)tag);
        boolean bl = nonLatestTag = !emptyTag && !tag.equals("latest");
        if (emptyTag || nonLatestTag) {
            String latestTemplateId = String.format("%s:latest", pipelineTemplate.undecoratedId());
            pipelineTemplate.setTag("latest");
            this.getPipelineTemplateDAO().update(latestTemplateId, (Object)pipelineTemplate);
            log.debug("Wrote latest tag for template: {}", (Object)pipelineTemplate.undecoratedId());
        }
    }
}

