/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers.v2;

import com.netflix.spinnaker.fiat.shared.FiatService;
import com.netflix.spinnaker.fiat.shared.FiatStatus;
import com.netflix.spinnaker.front50.config.FiatConfigurationProperties;
import com.netflix.spinnaker.front50.controllers.exception.InvalidApplicationRequestException;
import com.netflix.spinnaker.front50.exception.ApplicationAlreadyExistsException;
import com.netflix.spinnaker.front50.exception.ValidationException;
import com.netflix.spinnaker.front50.model.application.Application;
import com.netflix.spinnaker.front50.model.application.ApplicationDAO;
import com.netflix.spinnaker.front50.model.application.ApplicationPermissionDAO;
import com.netflix.spinnaker.front50.model.application.ApplicationService;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/applications"})
@Api(value="application", description="Application API")
public class ApplicationsController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationsController.class);
    private final MessageSource messageSource;
    private final ApplicationDAO applicationDAO;
    private final Optional<ApplicationPermissionDAO> applicationPermissionDAO;
    private final Optional<FiatService> fiatService;
    private final FiatConfigurationProperties fiatConfigurationProperties;
    private final FiatStatus fiatStatus;
    private final ApplicationService applicationService;

    public ApplicationsController(MessageSource messageSource, ApplicationDAO applicationDAO, Optional<ApplicationPermissionDAO> applicationPermissionDAO, Optional<FiatService> fiatService, FiatConfigurationProperties fiatConfigurationProperties, FiatStatus fiatStatus, ApplicationService applicationService) {
        this.messageSource = messageSource;
        this.applicationDAO = applicationDAO;
        this.applicationPermissionDAO = applicationPermissionDAO;
        this.fiatService = fiatService;
        this.fiatConfigurationProperties = fiatConfigurationProperties;
        this.fiatStatus = fiatStatus;
        this.applicationService = applicationService;
    }

    @PreAuthorize(value="#restricted ? @fiatPermissionEvaluator.storeWholePermission() : true")
    @PostFilter(value="#restricted ? hasPermission(filterObject.name, 'APPLICATION', 'READ') : true")
    @ApiOperation(value="", notes="Fetch all applications.\n\nSupports filtering by one or more attributes:\n- ?email=my@email.com\n- ?email=my@email.com&name=flex")
    @RequestMapping(method={RequestMethod.GET})
    public List<Application> applications(@RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(required=false, value="restricted", defaultValue="true") boolean restricted, @RequestParam Map<String, String> params) {
        params.remove("pageSize");
        params.remove("restricted");
        Map permissions = this.applicationPermissionDAO.map(apd -> apd.all().stream().filter(it -> it.getPermissions().isRestricted()).collect(Collectors.groupingBy(it -> it.getName().toLowerCase()))).orElseGet(HashMap::new);
        List<Object> applications = params.isEmpty() ? this.applicationDAO.all().stream().sorted(Comparator.comparing(Application::getName)).collect(Collectors.toList()) : new ArrayList(this.applicationDAO.search(params));
        ArrayList<Application> results = new ArrayList<Application>(pageSize == null ? applications : applications.subList(0, Math.min(pageSize, applications.size())));
        results.forEach(it -> {
            if (permissions.containsKey(it.getName().toLowerCase())) {
                it.set("permissions", (Object)((Application.Permission)((List)permissions.get(it.getName().toLowerCase())).get(0)).getPermissions());
            } else {
                it.details().remove("permissions");
            }
        });
        return results;
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.canCreate('APPLICATION', #app)")
    @ApiOperation(value="", notes="Create an application")
    @RequestMapping(method={RequestMethod.POST})
    public Application create(@RequestBody Application app) {
        if (this.applicationService.findByName(app.getName()) != null) {
            throw new ApplicationAlreadyExistsException();
        }
        Application createdApplication = this.applicationService.save(app);
        if (this.fiatStatus.isEnabled() && this.fiatConfigurationProperties.getRoleSync().isEnabled() && this.fiatService.isPresent()) {
            try {
                this.fiatService.get().sync();
            }
            catch (Exception e) {
                log.warn("failed to trigger fiat permission sync", (Throwable)e);
            }
        }
        return createdApplication;
    }

    @PreAuthorize(value="hasPermission(#applicationName, 'APPLICATION', 'WRITE')")
    @ApiOperation(value="", notes="Delete an application")
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{applicationName:.+}"})
    public void delete(@PathVariable String applicationName, HttpServletResponse response) {
        this.applicationService.delete(applicationName);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @PreAuthorize(value="hasPermission(#app.name, 'APPLICATION', 'WRITE')")
    @ApiOperation(value="", notes="Update an existing application by merging the attributes")
    @RequestMapping(method={RequestMethod.PATCH}, value={"/{applicationName:.+}"})
    public Application update(@PathVariable String applicationName, @RequestBody Application app) {
        if (!applicationName.trim().equalsIgnoreCase(app.getName())) {
            throw new InvalidApplicationRequestException(String.format("Application name '%s' does not match path parameter '%s'", app.getName(), applicationName));
        }
        return this.applicationService.save(app);
    }

    @PreAuthorize(value="hasPermission(#app.name, 'APPLICATION', 'WRITE')")
    @ApiOperation(value="", notes="Update an existing application by replacing all attributes")
    @RequestMapping(method={RequestMethod.PUT}, value={"/{applicationName:.+}"})
    public Application replace(@PathVariable String applicationName, @RequestBody Application app) {
        if (!applicationName.trim().equalsIgnoreCase(app.getName())) {
            throw new InvalidApplicationRequestException(String.format("Application name '%s' does not match path parameter '%s'", app.getName(), applicationName));
        }
        return this.applicationService.replace(app);
    }

    @PostAuthorize(value="hasPermission(#applicationName, 'APPLICATION', 'READ')")
    @ApiOperation(value="", notes="Fetch a single application by name")
    @RequestMapping(method={RequestMethod.GET}, value={"/{applicationName:.+}"})
    public Application get(@PathVariable String applicationName) {
        Application app = this.applicationDAO.findByName(applicationName.toUpperCase());
        try {
            Application.Permission perm = this.applicationPermissionDAO.map(it -> (Application.Permission)it.findById(app.getName())).orElse(null);
            if (perm != null && perm.getPermissions().isRestricted()) {
                app.details().put("permissions", perm.getPermissions());
            } else {
                app.details().remove("permissions");
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return app;
    }

    @PreAuthorize(value="hasPermission(#applicationName, 'APPLICATION', 'READ')")
    @RequestMapping(value={"{applicationName:.+}/history"}, method={RequestMethod.GET})
    public Collection<Application> getHistory(@PathVariable String applicationName, @RequestParam(value="limit", defaultValue="20") int limit) {
        return this.applicationDAO.history(applicationName, limit);
    }

    @PreAuthorize(value="@fiatPermissionEvaluator.isAdmin()")
    @RequestMapping(method={RequestMethod.POST}, value={"/batch/applications"})
    public void batchUpdate(@RequestBody Collection<Application> applications) {
        this.applicationDAO.bulkImport(applications);
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Map handleValidationException(ValidationException ex) {
        Locale locale = LocaleContextHolder.getLocale();
        List errorStrings = ex.getErrors().getAllErrors().stream().map(it -> this.messageSource.getMessage(Optional.ofNullable(it.getCode()).orElse("-1"), it.getArguments(), it.getDefaultMessage(), locale)).collect(Collectors.toList());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(3);
        map.put("error", "Validation Failed.");
        map.put("errors", errorStrings);
        map.put("status", HttpStatus.BAD_REQUEST);
        return map;
    }
}

