/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers.v2;

import com.google.common.base.Strings;
import com.netflix.spinnaker.front50.exception.BadRequestException;
import com.netflix.spinnaker.front50.model.tag.EntityTags;
import com.netflix.spinnaker.front50.model.tag.EntityTagsDAO;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.HandlerMapping;

@RestController
@RequestMapping(value={"/v2/tags"}, produces={"application/json"})
public class EntityTagsController {
    private static final Logger log = LoggerFactory.getLogger(EntityTagsController.class);
    private final Optional<EntityTagsDAO> taggedEntityDAO;

    public EntityTagsController(Optional<EntityTagsDAO> taggedEntityDAO) {
        this.taggedEntityDAO = taggedEntityDAO;
    }

    @RequestMapping(method={RequestMethod.GET})
    public Set<EntityTags> tags(@RequestParam(value="prefix", required=false) String prefix, @RequestParam(value="ids", required=false) Collection<String> ids, @RequestParam(value="refresh", required=false) Boolean refresh) {
        Collection tagIds = Optional.ofNullable(ids).orElseGet(ArrayList::new);
        if (prefix == null && tagIds.isEmpty()) {
            throw new BadRequestException("Either 'prefix' or 'ids' parameter is required");
        }
        if (!tagIds.isEmpty()) {
            return this.findAllByIds(tagIds);
        }
        boolean refreshFlag = refresh == null ? true : refresh;
        return this.taggedEntityDAO.map(dao -> dao.all(refreshFlag).stream().filter(it -> {
            if (Strings.isNullOrEmpty((String)prefix)) {
                return true;
            }
            return it.getId().startsWith(prefix);
        }).collect(Collectors.toSet())).orElse(null);
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET})
    public EntityTags tag(HttpServletRequest request) {
        String pattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        String searchTerm = new AntPathMatcher().extractPathWithinPattern(pattern, request.getServletPath());
        return this.taggedEntityDAO.map(it -> (EntityTags)it.findById(searchTerm)).orElseThrow(() -> new NotFoundException(String.format("No tags found for '%s'", searchTerm)));
    }

    @RequestMapping(method={RequestMethod.POST})
    public EntityTags create(@RequestBody EntityTags tag) {
        return this.taggedEntityDAO.map(it -> (EntityTags)it.create(tag.getId(), (Object)tag)).orElseThrow(() -> new BadRequestException("Tagging is not supported"));
    }

    @RequestMapping(value={"/batchUpdate"}, method={RequestMethod.POST})
    public Collection<EntityTags> batchUpdate(@RequestBody Collection<EntityTags> tags) {
        return this.taggedEntityDAO.map(it -> {
            it.bulkImport(tags);
            return tags;
        }).orElseThrow(() -> new BadRequestException("Tagging is not supported"));
    }

    @RequestMapping(value={"/batchDelete"}, method={RequestMethod.POST})
    public void batchDelete(@RequestBody Collection<String> ids) {
        if (!this.taggedEntityDAO.isPresent()) {
            throw new BadRequestException("Tagging is not supported");
        }
        this.taggedEntityDAO.get().bulkDelete(ids);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/**"})
    public void delete(HttpServletRequest request, HttpServletResponse response) {
        String pattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        String tagId = new AntPathMatcher().extractPathWithinPattern(pattern, request.getServletPath());
        if (!this.taggedEntityDAO.isPresent()) {
            throw new BadRequestException("Tagging is not supported");
        }
        this.taggedEntityDAO.get().delete(tagId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    private Set<EntityTags> findAllByIds(Collection<String> ids) {
        return this.taggedEntityDAO.map(dao -> ids.stream().map(it -> {
            try {
                return (EntityTags)dao.findById(it);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet())).orElseGet(HashSet::new);
    }
}

