/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.front50.controllers.v2;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.netflix.spinnaker.front50.UntypedUtils;
import com.netflix.spinnaker.front50.api.model.Timestamped;
import com.netflix.spinnaker.front50.exceptions.InvalidRequestException;
import com.netflix.spinnaker.front50.model.SearchUtils;
import com.netflix.spinnaker.front50.model.project.Project;
import com.netflix.spinnaker.front50.model.project.ProjectDAO;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/projects"}, produces={"application/json"})
@Api(value="projects", description="Project API")
public class ProjectsController {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private final ProjectDAO projectDAO;
    private static final Predicate<FuzzySearch> FUZZY_SEARCH_PREDICATE = fuzzySearch -> {
        boolean matches = SearchUtils.matchesIgnoreCase((Map)UntypedUtils.getProperties((Object)fuzzySearch.project), (String)fuzzySearch.key, (String)fuzzySearch.value);
        if (!matches) {
            return Optional.ofNullable(fuzzySearch.project.getConfig().getClusters()).map(c -> c.stream().anyMatch(it -> SearchUtils.matchesIgnoreCase((Map)UntypedUtils.getProperties((Object)it), (String)fuzzySearch.key, (String)fuzzySearch.value))).orElse(false);
        }
        return true;
    };

    public ProjectsController(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    @ApiOperation(value="", notes="Search for projects given one or more attributes.\n\n- /search?q=ProjectName\n- /search?q=ApplicationName\n")
    public Set<Project> search(@RequestParam(value="q") String query) {
        return this.projectDAO.all().stream().filter(p -> p.getName().toLowerCase().contains(query.toLowerCase()) || p.getConfig().getApplications().stream().anyMatch(it -> it.toLowerCase().contains(query.toLowerCase()))).collect(Collectors.toSet());
    }

    @ApiOperation(value="", notes="Fetch all projects.\n\n    Support filtering by one or more attributes:\n    - ?name=projectName\n    - ?email=my@email.com")
    @RequestMapping(method={RequestMethod.GET})
    public List<Project> projects(@RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam Map<String, String> params) {
        params.remove("pageSize");
        ArrayList<Project> projects = params.isEmpty() ? new ArrayList(this.projectDAO.all()) : this.filter(this.projectDAO.all(), params);
        return pageSize == null ? projects : projects.subList(0, Math.min(pageSize, projects.size()));
    }

    @ApiOperation(value="", notes="Fetch a single project")
    @RequestMapping(method={RequestMethod.GET}, value={"/{projectId}"})
    public Project project(@PathVariable String projectId) {
        try {
            return this.projectDAO.findByName(projectId);
        }
        catch (NotFoundException e) {
            return (Project)this.projectDAO.findById(projectId);
        }
    }

    @ApiOperation(value="", notes="Update an existing project")
    @RequestMapping(method={RequestMethod.PUT}, value={"/{projectId}"})
    public Project put(@PathVariable String projectId, @RequestBody Project project) {
        Project existingProject = (Project)this.projectDAO.findById(projectId);
        project.setId(existingProject.getId());
        project.setCreateTs(existingProject.getCreateTs());
        project.setUpdateTs(Long.valueOf(System.currentTimeMillis()));
        try {
            if (!this.projectDAO.findByName(project.getName()).getId().equals(projectId)) {
                throw new InvalidRequestException(String.format("A Project named '%s' already exists", project.getName()));
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.projectDAO.update(projectId, (Object)project);
        return project;
    }

    @ApiOperation(value="", notes="Create a project")
    @RequestMapping(method={RequestMethod.POST})
    public Project create(@RequestBody Project project) {
        project.setCreateTs(Long.valueOf(System.currentTimeMillis()));
        project.setUpdateTs(Long.valueOf(System.currentTimeMillis()));
        try {
            this.projectDAO.findByName(project.getName());
            throw new InvalidRequestException(String.format("A Project named '%s' already exists", project.getName()));
        }
        catch (NotFoundException notFoundException) {
            return (Project)this.projectDAO.create(project.getId(), (Object)project);
        }
    }

    private List<Project> filter(Collection<Project> projects, Map<String, String> attributes) {
        HashMap<String, String> normalizedAttributes = new HashMap<String, String>();
        for (Map.Entry<String, String> attr : attributes.entrySet()) {
            if (Strings.isNullOrEmpty((String)attr.getValue())) continue;
            normalizedAttributes.put(attr.getKey().toLowerCase(), attr.getValue());
        }
        List<Object> items = new ArrayList();
        if (normalizedAttributes.containsKey("applications")) {
            List applications = COMMA_SPLITTER.splitToList((CharSequence)normalizedAttributes.get("applications"));
            items = projects.stream().filter(project -> Optional.ofNullable(project.getConfig().getApplications()).map(projectApps -> projectApps.stream().anyMatch(app -> ProjectsController.projectApplicationMatches(app, applications))).orElse(false) != false || Optional.ofNullable(project.getConfig().getClusters()).map(projectClusters -> projectClusters.stream().anyMatch(cluster -> ProjectsController.clusterHasMatchingApplication(cluster, applications))).orElse(false) != false).collect(Collectors.toList());
            normalizedAttributes.remove("applications");
        }
        items.addAll(projects.stream().filter(project -> normalizedAttributes.entrySet().stream().anyMatch(it -> FUZZY_SEARCH_PREDICATE.test(new FuzzySearch((Project)project, (String)it.getKey(), (String)it.getValue())))).collect(Collectors.toList()));
        return items.stream().distinct().sorted((a, b) -> SearchUtils.score((Timestamped)b, (Map)normalizedAttributes) - SearchUtils.score((Timestamped)a, (Map)normalizedAttributes)).collect(Collectors.toList());
    }

    private static boolean projectApplicationMatches(String app, List<String> applications) {
        return applications.stream().anyMatch(it -> app.toLowerCase().contains(it.toLowerCase()));
    }

    private static boolean clusterHasMatchingApplication(Project.ClusterConfig cluster, List<String> applications) {
        return Optional.ofNullable(cluster.getApplications()).map(clusterApplications -> clusterApplications.stream().anyMatch(app -> applications.stream().anyMatch(it -> app.toLowerCase().contains(it.toLowerCase())))).orElse(false);
    }

    @ApiOperation(value="", notes="Delete a project")
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{projectId}"})
    public void delete(@PathVariable String projectId, HttpServletResponse response) {
        this.projectDAO.delete(projectId);
        response.setStatus(HttpStatus.ACCEPTED.value());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/batchUpdate"})
    public void batchUpdate(@RequestBody Collection<Project> projects, HttpServletResponse response) {
        this.projectDAO.bulkImport(projects);
        response.setStatus(HttpStatus.ACCEPTED.value());
    }

    private static final class FuzzySearch {
        private final Project project;
        private final String key;
        private final String value;

        public FuzzySearch(Project project, String key, String value) {
            this.project = project;
            this.key = key;
            this.value = value;
        }

        public Project getProject() {
            return this.project;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FuzzySearch)) {
                return false;
            }
            FuzzySearch other = (FuzzySearch)o;
            Project this$project = this.getProject();
            Project other$project = other.getProject();
            if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Project $project = this.getProject();
            result = result * 59 + ($project == null ? 43 : $project.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "ProjectsController.FuzzySearch(project=" + this.getProject() + ", key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }
}

