/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.networkTest.startapp;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Looper;
import com.startapp.networkTest.c;
import com.startapp.networkTest.c.b;
import com.startapp.networkTest.d.a.e;
import com.startapp.networkTest.results.ConnectivityTestResult;
import com.startapp.networkTest.results.LatencyResult;
import com.startapp.networkTest.startapp.ConnectivityTestListener;
import com.startapp.networkTest.startapp.CoverageMapperManager;

public final class NetworkTester {
    static final String LOG_TAG = NetworkTester.class.getSimpleName();
    private static final String P3WRAPPER_PREFS = "StartappP3WrapperPrefs";
    private static final String CTLT_GUARD_DIFF_KEY = "StartappGuardDiffKey";
    private static final String CTLT_PREV_TIME_CHECK_KEY = "StartappCtLtPrevTimeCheckKey";
    private static final String CTLT_CHECK_INTERVAL_KEY = "StartappCtLtCheckIntervalKey";
    static NetworkTester sInstance;
    ConnectivityTestListener mConnectivityTestListener;
    CoverageMapperManager mCoverageMapper;
    b mForegroundTestManager;
    private Context mContext;
    Thread mActiveThread;

    private NetworkTester() {
    }

    public static void init(Context context, Config config) {
        String string;
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        if ((string = com.iab.omid.library.startapp.b.b((Object)string)) == null) {
            throw new IllegalArgumentException("Wrong format of config");
        }
        if (sInstance != null) {
            return;
        }
        sInstance = new NetworkTester();
        new NetworkTester().mContext = context;
        c.a(context, string.getBytes());
        NetworkTester.sInstance.mCoverageMapper = new CoverageMapperManager(context);
        if (Build.VERSION.SDK_INT >= 14) {
            Context context2;
            NetworkTester.sInstance.mForegroundTestManager = new b(context2, NetworkTester.sInstance.mCoverageMapper);
        }
    }

    public static void setOnConnectivityLatencyListener(ConnectivityTestListener listener) {
        ConnectivityTestListener connectivityTestListener;
        NetworkTester.sInstance.mConnectivityTestListener = connectivityTestListener;
    }

    public static void setOnNetworkInfoListener(CoverageMapperManager.OnNetworkInfoResultListener listener) {
        CoverageMapperManager.OnNetworkInfoResultListener onNetworkInfoResultListener;
        NetworkTester.sInstance.mCoverageMapper.a(onNetworkInfoResultListener);
    }

    public static int isAppInForeground() {
        return NetworkTester.sInstance.mForegroundTestManager.c();
    }

    /*
     * WARNING - void declaration
     */
    public static void startListening(long checkingIntervalMilli, long guardDiffMilli) {
        void var2_1;
        long l2;
        SharedPreferences sharedPreferences = NetworkTester.sInstance.mContext.getSharedPreferences(P3WRAPPER_PREFS, 0);
        sharedPreferences.edit().putLong(CTLT_CHECK_INTERVAL_KEY, l2).commit();
        sharedPreferences.edit().putLong(CTLT_GUARD_DIFF_KEY, (long)var2_1).commit();
        NetworkTester.sInstance.mCoverageMapper.a();
        if (Build.VERSION.SDK_INT >= 14) {
            NetworkTester.sInstance.mForegroundTestManager.a();
        }
    }

    public static void stopListening() {
        Object object;
        NetworkTester networkTester = sInstance;
        if (networkTester != null && networkTester.mCoverageMapper != null && (object = networkTester.mCoverageMapper) != null) {
            ((CoverageMapperManager)object).b();
        }
        if (networkTester != null && Build.VERSION.SDK_INT >= 14 && (object = networkTester.mForegroundTestManager) != null) {
            ((b)object).b();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void runTests(Context context, a finalizer) {
        void var1_1;
        Context context2;
        if (sInstance == null) {
            finalizer.a();
            return;
        }
        if (!com.startapp.common.b.b.a(context, "android.permission.ACCESS_FINE_LOCATION") && !com.startapp.common.b.b.a(context, "android.permission.ACCESS_COARSE_LOCATION")) {
            NetworkTester.sInstance.mCoverageMapper.b();
            finalizer.a();
            return;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences(P3WRAPPER_PREFS, 0);
        long l2 = sharedPreferences.getLong(CTLT_GUARD_DIFF_KEY, 120000L);
        long l3 = sharedPreferences.getLong(CTLT_PREV_TIME_CHECK_KEY, 0L);
        long l4 = sharedPreferences.getLong(CTLT_CHECK_INTERVAL_KEY, l2);
        if (System.currentTimeMillis() - l3 < l4 - l2) {
            finalizer.a();
            return;
        }
        if (!c.a()) {
            finalizer.a();
            return;
        }
        if (NetworkTester.sInstance.mActiveThread != null) {
            finalizer.a();
            return;
        }
        sharedPreferences.edit().putLong(CTLT_PREV_TIME_CHECK_KEY, System.currentTimeMillis()).commit();
        NetworkTester.sInstance.mCoverageMapper.a();
        NetworkTester.sInstance.mActiveThread = new Thread(new Runnable(context2, (a)var1_1){
            private /* synthetic */ Context b;
            final /* synthetic */ a a;
            {
                this.b = context;
                this.a = a2;
            }

            @Override
            public final void run() {
                boolean[] blArray = new boolean[2];
                Looper.prepare();
                Looper looper = Looper.myLooper();
                com.startapp.networkTest.d.a.b b2 = new com.startapp.networkTest.d.a.b(this.b.getApplicationContext());
                b2.a();
                b2.a(new e(blArray, looper, b2){
                    private /* synthetic */ boolean[] b;
                    private /* synthetic */ Looper c;
                    private /* synthetic */ com.startapp.networkTest.d.a.b d;
                    {
                        this.b = blArray;
                        this.c = looper;
                        this.d = b2;
                    }

                    @Override
                    public final void a(ConnectivityTestResult connectivityTestResult) {
                        if (this.b[0]) {
                            if (this.c != null) {
                                NetworkTester.sInstance.mActiveThread = null;
                                this.c.quit();
                                a.a();
                            }
                            return;
                        }
                        this.b[0] = true;
                        if (NetworkTester.sInstance.mConnectivityTestListener != null) {
                            NetworkTester.sInstance.mConnectivityTestListener.onConnectivityTestResult(connectivityTestResult);
                        }
                    }

                    @Override
                    public final void a(LatencyResult latencyResult) {
                        if (this.b[1]) {
                            if (this.c != null) {
                                NetworkTester.sInstance.mActiveThread = null;
                                this.c.quit();
                                a.a();
                            }
                            return;
                        }
                        this.b[1] = true;
                        if (NetworkTester.sInstance.mConnectivityTestListener != null) {
                            NetworkTester.sInstance.mConnectivityTestListener.onLatencyTestResult(latencyResult);
                        }
                    }

                    @Override
                    public final void a() {
                        this.d.b();
                        if (this.c != null) {
                            NetworkTester.sInstance.mActiveThread = null;
                            this.c.quit();
                        }
                        if (NetworkTester.sInstance.mConnectivityTestListener != null) {
                            NetworkTester.sInstance.mConnectivityTestListener.onConnectivityTestFinished(new Runnable(this){
                                private /* synthetic */ 1 a;
                                {
                                    this.a = var1_1;
                                }

                                @Override
                                public final void run() {
                                    a.a();
                                }
                            });
                            return;
                        }
                        a.a();
                    }
                });
                Looper.loop();
            }
        });
        NetworkTester.sInstance.mActiveThread.start();
    }

    public static interface a {
        public void a();
    }

    public static final class Config {
        public String PROJECT_ID = "20050";
        public String CONNECTIVITY_TEST_HOSTNAME = "d2to8y50b3n6dq.cloudfront.net";
        public String CONNECTIVITY_TEST_FILENAME = "/favicon.ico";
        public boolean CONNECTIVITY_TEST_ENABLED = true;
        public boolean NIR_COLLECT_CELLINFO = true;
        public boolean CT_COLLECT_CELLINFO = true;
        public int NIR_COLLECT_CELLINFO_THRESHOLD = 2;
        public String CONNECTIVITY_TEST_CDNCONFIG_URL = "https://d2to8y50b3n6dq.cloudfront.net/truststores/[PROJECTID]/cdnconfig.zip";
        public String GEOIP_URL = "https://geoip.api.c0nnectthed0ts.com/geoip/";
        public long FOREGROUND_TEST_CT_SCHEDULE_INTERVAL = 300000L;
        public long FOREGROUND_TEST_CT_MIN_INTERVAL = 180000L;
        public boolean FOREGROUND_TEST_CT_ENABLED = true;
        public boolean FOREGROUND_TEST_NIR_ENABLED = true;
    }
}

