/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.sdk.ads.splash;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import com.startapp.common.parser.d;
import com.startapp.sdk.ads.splash.SplashHtml;
import com.startapp.sdk.ads.splash.SplashMetaData;
import com.startapp.sdk.ads.splash.e;
import com.startapp.sdk.adsbase.f.a;
import com.startapp.sdk.adsbase.l.z;
import java.io.Serializable;
import java.util.Arrays;

public class SplashConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean forceNative = false;
    private static long a;
    private static final Theme b;
    private static final MinSplashTime c;
    private static final long d;
    private static final MaxAdDisplayTime e;
    private static final Orientation f;
    private int customScreen = -1;
    private String appName = "";
    private transient Drawable g = null;
    private byte[] logoByteArray = null;
    private int logoRes = -1;
    @d(b=Theme.class)
    private Theme defaultTheme = b;
    @d(b=MinSplashTime.class)
    private MinSplashTime defaultMinSplashTime = c;
    private Long defaultMaxLoadTime = d;
    @d(b=MaxAdDisplayTime.class)
    private MaxAdDisplayTime defaultMaxAdDisplayTime = e;
    @d(b=Orientation.class)
    private Orientation defaultOrientation = f;
    private boolean htmlSplash = true;
    private String splashBgColor = "#066CAA";
    private String splashFontColor = "ffffff";
    private String splashLoadingType = "LoadingDots";
    private transient String h = "";

    public static SplashConfig getDefaultSplashConfig() {
        SplashConfig splashConfig = new SplashConfig();
        splashConfig.setTheme(b).setMinSplashTime(c).a(d).setMaxAdDisplayTime(e).setOrientation(f).setLoadingType("LoadingDots").setAppName("");
        return splashConfig;
    }

    /*
     * WARNING - void declaration
     */
    public SplashConfig setTheme(Theme theme) {
        void var1_1;
        this.defaultTheme = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SplashConfig setCustomScreen(int resource) {
        void var1_1;
        this.customScreen = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SplashConfig setAppName(String appName) {
        void var1_1;
        this.appName = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SplashConfig setLogo(int resource) {
        void var1_1;
        this.logoRes = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SplashConfig setLogo(byte[] logoByteArray) {
        void var1_1;
        this.logoByteArray = var1_1;
        return this;
    }

    private SplashConfig a(long l2) {
        this.defaultMaxLoadTime = l2;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SplashConfig setOrientation(Orientation orientation) {
        void var1_1;
        this.defaultOrientation = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SplashConfig setMinSplashTime(MinSplashTime minSplashTime) {
        void var1_1;
        this.defaultMinSplashTime = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SplashConfig setMaxAdDisplayTime(MaxAdDisplayTime maxDisplayTime) {
        void var1_1;
        this.defaultMaxAdDisplayTime = var1_1;
        return this;
    }

    public int getCustomScreen() {
        return this.customScreen;
    }

    public String getAppName() {
        return this.appName;
    }

    public Drawable getLogo() {
        return this.g;
    }

    public int getLogoRes() {
        return this.logoRes;
    }

    public byte[] getLogoByteArray() {
        return this.logoByteArray;
    }

    protected final Long a() {
        return this.defaultMaxLoadTime;
    }

    public String getErrorMessage() {
        return this.h;
    }

    protected final Theme b() {
        return this.defaultTheme;
    }

    public Orientation getOrientation() {
        return this.defaultOrientation;
    }

    public MinSplashTime getMinSplashTime() {
        return this.defaultMinSplashTime;
    }

    public MaxAdDisplayTime getMaxAdDisplayTime() {
        return this.defaultMaxAdDisplayTime;
    }

    public boolean isHtmlSplash() {
        if (this.forceNative) {
            return false;
        }
        return this.htmlSplash;
    }

    public String getBgColor() {
        return this.splashBgColor;
    }

    public String getFontColor() {
        return this.splashFontColor;
    }

    public String getLoadingType() {
        return this.splashLoadingType;
    }

    /*
     * WARNING - void declaration
     */
    public SplashConfig setLoadingType(String splashLoadingType) {
        void var1_1;
        this.splashLoadingType = var1_1;
        return this;
    }

    protected final boolean a(Context context) {
        boolean bl = true;
        switch (this.defaultTheme) {
            case USER_DEFINED: {
                if (this.getCustomScreen() != -1) break;
                bl = false;
                this.h = "StartApp: Exception getting custom screen resource id, make sure it is set";
                break;
            }
            default: {
                if (this.getAppName().equals("")) {
                    this.setAppName(com.startapp.sdk.adsbase.a.a(context, "Welcome!"));
                }
                if (this.getLogo() != null || this.getLogoByteArray() != null) break;
                try {
                    if (this.getLogoRes() == -1) {
                        this.setLogo(context.getApplicationInfo().icon);
                        this.g = context.getResources().getDrawable(context.getApplicationInfo().icon);
                        break;
                    }
                    this.g = context.getResources().getDrawable(this.getLogoRes());
                    break;
                }
                catch (Throwable throwable) {
                    new a(throwable).a(context);
                }
            }
        }
        return bl;
    }

    protected final View b(Context context) {
        View view = null;
        switch (this.defaultTheme) {
            case USER_DEFINED: {
                try {
                    view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(this.getCustomScreen(), null);
                    break;
                }
                catch (Resources.NotFoundException notFoundException) {
                    throw new Resources.NotFoundException("StartApp: Can't find Custom layout resource");
                }
                catch (InflateException inflateException) {
                    throw new InflateException("StartApp: Can't inflate layout in Custom mode, Are you sure layout resource is valid?");
                }
                catch (Throwable throwable) {
                    new a(throwable).a(context);
                    break;
                }
            }
            default: {
                view = com.startapp.sdk.ads.splash.e.a(context, this);
            }
        }
        return view;
    }

    public void setDefaults(Context context) {
        ApplicationInfo applicationInfo;
        SplashConfig splashConfig = SplashMetaData.b().a();
        if (splashConfig == null) {
            splashConfig = SplashConfig.getDefaultSplashConfig();
        } else {
            this.htmlSplash = splashConfig.isHtmlSplash();
        }
        Context context2 = context;
        SplashConfig splashConfig2 = splashConfig;
        SplashConfig splashConfig3 = SplashConfig.getDefaultSplashConfig();
        if (splashConfig2.defaultTheme == null) {
            splashConfig2.setTheme(splashConfig3.defaultTheme);
        }
        if (splashConfig2.getMinSplashTime() == null) {
            splashConfig2.setMinSplashTime(splashConfig3.getMinSplashTime());
        }
        if (splashConfig2.defaultMaxLoadTime == null) {
            splashConfig2.a(splashConfig3.defaultMaxLoadTime);
        }
        if (splashConfig2.getMaxAdDisplayTime() == null) {
            splashConfig2.setMaxAdDisplayTime(splashConfig3.getMaxAdDisplayTime());
        }
        if (splashConfig2.getOrientation() == null) {
            splashConfig2.setOrientation(splashConfig3.getOrientation());
        }
        if (splashConfig2.getLoadingType() == null) {
            splashConfig2.setLoadingType(splashConfig3.getLoadingType());
        }
        if (splashConfig2.getAppName().equals("")) {
            splashConfig2.setAppName(com.startapp.sdk.adsbase.a.a(context2, "Welcome!"));
        }
        if (this.getMaxAdDisplayTime() == null) {
            this.setMaxAdDisplayTime(splashConfig.getMaxAdDisplayTime());
        }
        if (this.defaultMaxLoadTime == null) {
            this.a(splashConfig.defaultMaxLoadTime);
        }
        if (this.getMinSplashTime() == null) {
            this.setMinSplashTime(splashConfig.getMinSplashTime());
        }
        if (this.getOrientation() == null) {
            this.setOrientation(splashConfig.getOrientation());
        }
        if (this.defaultTheme == null) {
            this.setTheme(splashConfig.defaultTheme);
        }
        if (this.getLogoRes() == -1 && (applicationInfo = applicationInfo.getApplicationInfo()) != null) {
            this.setLogo(applicationInfo.icon);
        }
        if (this.getAppName().equals("")) {
            this.setAppName(splashConfig.getAppName());
        }
    }

    protected final void a(Activity activity) {
        if (this.getLogo() == null && this.getLogoRes() == -1 && this.getLogoByteArray() != null) {
            Object object = this.getLogoByteArray();
            object = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length);
            activity = new BitmapDrawable(activity.getResources(), (Bitmap)object);
            this.g = activity;
        }
    }

    protected final SplashHtml b(Activity object) {
        SplashConfig splashConfig = this;
        Theme theme = splashConfig.defaultTheme;
        SplashConfig splashConfig2 = splashConfig;
        String string = "#066CAA";
        String string2 = "ffffff";
        switch (theme) {
            case DEEP_BLUE: {
                string2 = "#FFFFFF";
                string = "#066CAA";
                break;
            }
            case SKY: {
                string2 = "#333333";
                string = "#a3d4e5";
                break;
            }
            case ASHEN_SKY: {
                string2 = "#333333";
                string = "#E3E3E3";
                break;
            }
            case BLAZE: {
                string2 = "#FFFFFF";
                string = "#FF6600";
                break;
            }
            case GLOOMY: {
                string2 = "#33B5E5";
                string = "#2F353F";
                break;
            }
            case OCEAN: {
                string2 = "#063D51";
                string = "#237C9A";
            }
        }
        splashConfig2.splashBgColor = string;
        splashConfig2.splashFontColor = string2;
        object = new SplashHtml((Activity)object);
        ((SplashHtml)object).a(this);
        ((SplashHtml)object).a();
        return object;
    }

    final boolean c() {
        return this.defaultTheme == Theme.USER_DEFINED || this.getCustomScreen() != -1;
    }

    public boolean equals(Object o2) {
        SplashConfig splashConfig;
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        splashConfig = splashConfig;
        return this.forceNative == splashConfig.forceNative && this.customScreen == splashConfig.customScreen && this.logoRes == splashConfig.logoRes && this.htmlSplash == splashConfig.htmlSplash && z.b(this.appName, splashConfig.appName) && Arrays.equals(this.logoByteArray, splashConfig.logoByteArray) && this.defaultTheme == splashConfig.defaultTheme && this.defaultMinSplashTime == splashConfig.defaultMinSplashTime && z.b(this.defaultMaxLoadTime, splashConfig.defaultMaxLoadTime) && this.defaultMaxAdDisplayTime == splashConfig.defaultMaxAdDisplayTime && this.defaultOrientation == splashConfig.defaultOrientation && z.b(this.splashBgColor, splashConfig.splashBgColor) && z.b(this.splashFontColor, splashConfig.splashFontColor) && z.b(this.splashLoadingType, splashConfig.splashLoadingType);
    }

    public int hashCode() {
        return z.a(new Object[]{this.forceNative, this.customScreen, this.appName, this.logoRes, this.defaultTheme, this.defaultMinSplashTime, this.defaultMaxLoadTime, this.defaultMaxAdDisplayTime, this.defaultOrientation, this.htmlSplash, this.splashBgColor, this.splashFontColor, this.splashLoadingType}) * 31 + Arrays.hashCode(this.logoByteArray);
    }

    static {
        SplashConfig.class.getSimpleName();
        a = 7500L;
        b = Theme.OCEAN;
        c = MinSplashTime.REGULAR;
        d = a;
        e = MaxAdDisplayTime.FOR_EVER;
        f = Orientation.AUTO;
    }

    public static enum Theme {
        DEEP_BLUE(1),
        SKY(2),
        ASHEN_SKY(3),
        BLAZE(4),
        GLOOMY(5),
        OCEAN(6),
        USER_DEFINED(0);

        private int index;

        /*
         * WARNING - void declaration
         */
        private Theme(int index) {
            void var3_3;
            this.index = var3_3;
        }

        public final int getIndex() {
            return this.index;
        }

        public static Theme getByIndex(int index) {
            Theme theme = DEEP_BLUE;
            Theme[] themeArray = Theme.values();
            for (int i2 = 0; i2 < themeArray.length; ++i2) {
                if (themeArray[i2].getIndex() != index) continue;
                theme = themeArray[i2];
            }
            return theme;
        }

        public static Theme getByName(String name) {
            Theme theme = DEEP_BLUE;
            Theme[] themeArray = Theme.values();
            for (int i2 = 0; i2 < themeArray.length; ++i2) {
                if (themeArray[i2].name().toLowerCase().compareTo(name.toLowerCase()) != 0) continue;
                theme = themeArray[i2];
            }
            return theme;
        }
    }

    public static enum Orientation {
        PORTRAIT(1),
        LANDSCAPE(2),
        AUTO(3);

        private int index;

        /*
         * WARNING - void declaration
         */
        private Orientation(int index) {
            void var3_3;
            this.index = var3_3;
        }

        public final int getIndex() {
            return this.index;
        }

        public static Orientation getByIndex(int index) {
            Orientation orientation = PORTRAIT;
            Orientation[] orientationArray = Orientation.values();
            for (int i2 = 0; i2 < orientationArray.length; ++i2) {
                if (orientationArray[i2].getIndex() != index) continue;
                orientation = orientationArray[i2];
            }
            return orientation;
        }

        public static Orientation getByName(String name) {
            Orientation orientation = AUTO;
            Orientation[] orientationArray = Orientation.values();
            for (int i2 = 0; i2 < orientationArray.length; ++i2) {
                if (orientationArray[i2].name().toLowerCase().compareTo(name.toLowerCase()) != 0) continue;
                orientation = orientationArray[i2];
            }
            return orientation;
        }
    }

    public static enum MinSplashTime {
        REGULAR(3000),
        SHORT(2000),
        LONG(5000);

        private long index;

        /*
         * WARNING - void declaration
         */
        private MinSplashTime(int index) {
            void var3_3;
            this.index = (long)var3_3;
        }

        public final long getIndex() {
            return this.index;
        }

        public static MinSplashTime getByIndex(long index) {
            MinSplashTime minSplashTime = SHORT;
            MinSplashTime[] minSplashTimeArray = MinSplashTime.values();
            for (int i2 = 0; i2 < minSplashTimeArray.length; ++i2) {
                if (minSplashTimeArray[i2].getIndex() != index) continue;
                minSplashTime = minSplashTimeArray[i2];
            }
            return minSplashTime;
        }

        public static MinSplashTime getByName(String name) {
            MinSplashTime minSplashTime = LONG;
            MinSplashTime[] minSplashTimeArray = MinSplashTime.values();
            for (int i2 = 0; i2 < minSplashTimeArray.length; ++i2) {
                if (minSplashTimeArray[i2].name().toLowerCase().compareTo(name.toLowerCase()) != 0) continue;
                minSplashTime = minSplashTimeArray[i2];
            }
            return minSplashTime;
        }
    }

    public static enum MaxAdDisplayTime {
        SHORT(5000L),
        LONG(10000L),
        FOR_EVER(86400000L);

        private long index;

        /*
         * WARNING - void declaration
         */
        private MaxAdDisplayTime(long index) {
            void var3_3;
            this.index = var3_3;
        }

        public final long getIndex() {
            return this.index;
        }

        public static MaxAdDisplayTime getByIndex(long index) {
            MaxAdDisplayTime maxAdDisplayTime = SHORT;
            MaxAdDisplayTime[] maxAdDisplayTimeArray = MaxAdDisplayTime.values();
            for (int i2 = 0; i2 < maxAdDisplayTimeArray.length; ++i2) {
                if (maxAdDisplayTimeArray[i2].getIndex() != index) continue;
                maxAdDisplayTime = maxAdDisplayTimeArray[i2];
            }
            return maxAdDisplayTime;
        }

        public static MaxAdDisplayTime getByName(String name) {
            MaxAdDisplayTime maxAdDisplayTime = FOR_EVER;
            MaxAdDisplayTime[] maxAdDisplayTimeArray = MaxAdDisplayTime.values();
            for (int i2 = 0; i2 < maxAdDisplayTimeArray.length; ++i2) {
                if (maxAdDisplayTimeArray[i2].name().toLowerCase().compareTo(name.toLowerCase()) != 0) continue;
                maxAdDisplayTime = maxAdDisplayTimeArray[i2];
            }
            return maxAdDisplayTime;
        }
    }
}

