/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.sdk.adsbase;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.startapp.sdk.adsbase.ActivityExtra;
import com.startapp.sdk.adsbase.SimpleTokenUtils;
import com.startapp.sdk.adsbase.adinformation.AdInformationOverrides;
import com.startapp.sdk.adsbase.adlisteners.AdDisplayListener;
import com.startapp.sdk.adsbase.adlisteners.AdEventListener;
import com.startapp.sdk.adsbase.cache.CacheMetaData;
import com.startapp.sdk.adsbase.consent.ConsentData;
import com.startapp.sdk.adsbase.l.v;
import com.startapp.sdk.adsbase.l.z;
import com.startapp.sdk.adsbase.model.AdPreferences;
import com.startapp.sdk.adsbase.remoteconfig.MetaData;
import com.startapp.sdk.adsbase.remoteconfig.MetaDataRequest;
import com.startapp.sdk.adsbase.remoteconfig.b;
import com.startapp.sdk.components.c;
import java.io.Serializable;

public abstract class Ad
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    protected transient Context a;
    protected ActivityExtra activityExtra;
    protected Serializable extraData = null;
    private AdInformationOverrides adInfoOverride;
    protected AdPreferences.Placement placement;
    protected ConsentData consentData;
    @Nullable
    protected String errorMessage;
    protected Long adCacheTtl = null;
    private AdState state = AdState.UN_INITIALIZED;
    private AdDisplayListener.NotDisplayedReason notDisplayedReason;
    private static boolean b = false;
    private Long lastLoadTime = null;
    private AdType type;
    protected boolean belowMinCPM = false;
    private boolean videoCancelCallBack;

    /*
     * WARNING - void declaration
     */
    public Ad(@NonNull Context context, AdPreferences.Placement placement) {
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.placement = var2_2;
        z.c();
        this.adInfoOverride = AdInformationOverrides.a();
    }

    public Serializable getExtraData() {
        return this.extraData;
    }

    @NonNull
    public Context getContext() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    public void setContext(@NonNull Context context) {
        void var1_1;
        this.a = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setActivityExtra(ActivityExtra activityExtra) {
        void var1_1;
        this.activityExtra = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setExtraData(Serializable extraData) {
        void var1_1;
        this.extraData = var1_1;
    }

    public AdState getState() {
        return this.state;
    }

    public boolean isBelowMinCPM() {
        return this.belowMinCPM;
    }

    /*
     * WARNING - void declaration
     */
    public void setState(AdState state) {
        void var1_1;
        this.state = var1_1;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * WARNING - void declaration
     */
    public void setErrorMessage(@Nullable String errorMessage) {
        void var1_1;
        this.errorMessage = var1_1;
    }

    public AdInformationOverrides getAdInfoOverride() {
        return this.adInfoOverride;
    }

    /*
     * WARNING - void declaration
     */
    public void setAdInfoOverride(AdInformationOverrides adInfoOverride) {
        void var1_1;
        this.adInfoOverride = var1_1;
    }

    @Nullable
    public final ConsentData getConsentData() {
        return this.consentData;
    }

    protected AdPreferences.Placement i() {
        return this.placement;
    }

    @Deprecated
    public boolean load() {
        return this.load(new AdPreferences(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean load(AdEventListener callback) {
        void var1_1;
        return this.load(new AdPreferences(), (AdEventListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean load(AdPreferences adPreferences) {
        void var1_1;
        return this.load((AdPreferences)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean load(AdPreferences adPreferences, AdEventListener callback) {
        void var2_2;
        void var1_1;
        return this.load((AdPreferences)var1_1, (AdEventListener)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public boolean load(AdPreferences adPreferences, AdEventListener listener, boolean waitForMetadata) {
        void var3_3;
        void var1_1;
        Object object;
        object = new AdEventListener(this, (AdEventListener)object){
            private /* synthetic */ AdEventListener a;
            private /* synthetic */ Ad b;
            {
                this.b = ad;
                this.a = adEventListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void onReceiveAd(Ad ad) {
                void var1_1;
                this.b.lastLoadTime = System.currentTimeMillis();
                com.startapp.sdk.adsbase.adlisteners.b.a(this.b.a, this.a, ad);
                ConsentData consentData = ad.getConsentData();
                if (consentData != null) {
                    c.a(this.b.a).f().a(consentData.a(), consentData.b(), consentData.c(), false, true);
                }
                z.a(this.b.a, false, "Loaded " + z.a(ad) + " ad with creative ID - " + var1_1.getAdId());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void onFailedToReceiveAd(Ad ad) {
                void var1_1;
                this.a.onFailedToReceiveAd(ad);
                String string = ad.getErrorMessage();
                if (string == null) {
                    string = "";
                } else if (string.contains("204")) {
                    string = "NO FILL";
                }
                z.a(this.b.a, true, "Failed to load " + z.a((Ad)var1_1) + " ad: " + string);
            }
        };
        if (!b) {
            SimpleTokenUtils.c(this.a);
            b = true;
        }
        boolean bl = false;
        String string = "";
        if (this.state != AdState.UN_INITIALIZED) {
            bl = true;
            string = "load() was already called.";
        }
        if (!z.c(this.a)) {
            bl = true;
            string = "network not available.";
        }
        if (!MetaData.K().Q()) {
            bl = true;
            string = "serving ads disabled";
        }
        if (bl) {
            this.setErrorMessage("Ad wasn't loaded: ".concat(String.valueOf(string)));
            object.onFailedToReceiveAd(this);
            return false;
        }
        this.setState(AdState.PROCESSING);
        object = new b(this, adPreferences, (AdEventListener)object){
            private /* synthetic */ AdPreferences a;
            private /* synthetic */ AdEventListener b;
            private /* synthetic */ Ad c;
            {
                this.c = ad;
                this.a = adPreferences;
                this.b = adEventListener;
            }

            @Override
            public final void a(@Nullable MetaDataRequest.RequestReason requestReason, boolean bl) {
                this.c.a(this.a, this.b);
            }

            @Override
            public final void a() {
                this.c.a(this.a, this.b);
            }
        };
        if (adPreferences.getType() != null) {
            this.type = adPreferences.getType();
        }
        MetaData.K().a(this.a, (AdPreferences)var1_1, v.d().c(), (boolean)var3_3, (b)object, false);
        return true;
    }

    protected abstract void a(AdPreferences var1, AdEventListener var2);

    public boolean isReady() {
        return this.state == AdState.READY && !this.e_();
    }

    @Deprecated
    public boolean show() {
        return false;
    }

    public AdDisplayListener.NotDisplayedReason getNotDisplayedReason() {
        return this.notDisplayedReason;
    }

    protected final void a(AdDisplayListener.NotDisplayedReason notDisplayedReason) {
        this.notDisplayedReason = notDisplayedReason;
    }

    protected Long c() {
        long l2 = this.f();
        return this.adCacheTtl == null ? l2 : Math.min(this.adCacheTtl, l2);
    }

    protected long f() {
        return CacheMetaData.a().b().a();
    }

    protected Long b() {
        return this.lastLoadTime;
    }

    protected boolean e_() {
        if (this.lastLoadTime == null) {
            return false;
        }
        return System.currentTimeMillis() - this.lastLoadTime > this.c();
    }

    public AdType getType() {
        return this.type;
    }

    protected boolean e() {
        return this.videoCancelCallBack;
    }

    protected void a(boolean bl) {
        this.videoCancelCallBack = bl;
    }

    @Nullable
    public abstract String getAdId();

    public static enum AdType {
        INTERSTITIAL,
        RICH_TEXT,
        VIDEO,
        REWARDED_VIDEO,
        NON_VIDEO,
        VIDEO_NO_VAST;

    }

    public static enum AdState {
        UN_INITIALIZED,
        PROCESSING,
        READY;

    }
}

