/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.sdk.adsbase.adinformation;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.startapp.common.parser.d;
import com.startapp.sdk.adsbase.adinformation.AdInformationPositions;
import com.startapp.sdk.adsbase.adinformation.ImageResourceConfig;
import com.startapp.sdk.adsbase.j;
import com.startapp.sdk.adsbase.l.z;
import com.startapp.sdk.adsbase.model.AdPreferences;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AdInformationConfig
implements Serializable {
    private static final long serialVersionUID = 8911501868319500986L;
    private static final String a = new String(new byte[]{104, 116, 116, 112, 115, 58, 47, 47, 102, 117, 110, 110, 101, 108, 45, 97, 115, 115, 101, 116, 115, 46, 115, 116, 97, 114, 116, 97, 112, 112, 115, 101, 114, 118, 105, 99, 101, 46, 99, 111, 109, 47, 99, 111, 110, 115, 101, 110, 116, 47, 105, 110, 100, 101, 120, 46, 104, 116, 109, 108});
    private boolean enabled = true;
    private float fatFingersFactor = 200.0f;
    private String dialogUrlSecured = a;
    private String eulaUrlSecured = "https://www.startapp.com/policy/privacy-policy/";
    @Nullable
    private Integer consentTypeInfo;
    @d(b=HashMap.class, d=AdPreferences.Placement.class, c=AdInformationPositions.Position.class)
    protected HashMap<AdPreferences.Placement, AdInformationPositions.Position> Positions = new HashMap();
    private transient EnumMap<ImageResourceType, ImageResourceConfig> b = new EnumMap(ImageResourceType.class);
    @d(b=ArrayList.class, c=ImageResourceConfig.class)
    private List<ImageResourceConfig> ImageResources = new ArrayList<ImageResourceConfig>();

    private AdInformationConfig() {
    }

    public static AdInformationConfig a() {
        AdInformationConfig adInformationConfig = new AdInformationConfig();
        AdInformationConfig.a(adInformationConfig);
        return adInformationConfig;
    }

    public static void a(AdInformationConfig adInformationConfig) {
        adInformationConfig.i();
        adInformationConfig.h();
    }

    @Nullable
    public final Integer b() {
        return this.consentTypeInfo;
    }

    public final String c() {
        if (this.eulaUrlSecured != null && !this.eulaUrlSecured.equals("")) {
            return this.eulaUrlSecured;
        }
        return "https://www.startapp.com/policy/privacy-policy/";
    }

    public final String d() {
        if (this.b.containsKey((Object)ImageResourceType.INFO_L) && !this.b.get((Object)ImageResourceType.INFO_L).d().equals("")) {
            return this.b.get((Object)ImageResourceType.INFO_L).d();
        }
        return "https://info.startappservice.com/InApp/resources/info_l.png";
    }

    public final boolean a(Context context) {
        return j.a(context, "userDisabledAdInformation", Boolean.FALSE) == false && this.enabled;
    }

    public final float e() {
        return this.fatFingersFactor / 100.0f;
    }

    public final String f() {
        if (this.dialogUrlSecured != null) {
            return this.dialogUrlSecured;
        }
        return a;
    }

    public final AdInformationPositions.Position a(AdPreferences.Placement placement) {
        AdInformationPositions.Position position = this.Positions.get((Object)placement);
        if (position == null) {
            position = AdInformationPositions.Position.BOTTOM_LEFT;
            this.Positions.put(placement, position);
        }
        return position;
    }

    public final ImageResourceConfig a(ImageResourceType imageResourceType) {
        return this.b.get((Object)imageResourceType);
    }

    public final void b(@NonNull Context context) {
        Iterator<ImageResourceConfig> iterator = this.ImageResources.iterator();
        while (iterator.hasNext()) {
            ImageResourceConfig imageResourceConfig;
            ImageResourceConfig imageResourceConfig2 = imageResourceConfig = iterator.next();
            ImageResourceType imageResourceType = ImageResourceType.getByName(imageResourceConfig.a());
            this.b.put(imageResourceType, imageResourceConfig2);
            imageResourceConfig.b(context);
        }
    }

    private void h() {
        for (ImageResourceType imageResourceType : ImageResourceType.values()) {
            if (this.b.get((Object)imageResourceType) != null) continue;
            throw new IllegalArgumentException("AdInformation error in ImageResource [" + (Object)((Object)imageResourceType) + "] cannot be found in MetaData");
        }
    }

    private void i() {
        for (ImageResourceType imageResourceType : ImageResourceType.values()) {
            ImageResourceConfig imageResourceConfig = this.b.get((Object)imageResourceType);
            Boolean bl = Boolean.TRUE;
            if (imageResourceConfig == null) {
                imageResourceConfig = ImageResourceConfig.b(imageResourceType.name());
                Iterator<ImageResourceConfig> iterator = this.ImageResources.iterator();
                while (iterator.hasNext()) {
                    if (!ImageResourceType.getByName(iterator.next().a()).equals((Object)imageResourceType)) continue;
                    bl = Boolean.FALSE;
                    break;
                }
                this.b.put(imageResourceType, imageResourceConfig);
                if (bl.booleanValue()) {
                    this.ImageResources.add(imageResourceConfig);
                }
            }
            imageResourceConfig.a(imageResourceType.getDefaultWidth());
            imageResourceConfig.b(imageResourceType.getDefaultHeight());
            imageResourceConfig.a(imageResourceType.name().toLowerCase() + ".png");
        }
    }

    public final void g() {
        this.b = new EnumMap(ImageResourceType.class);
    }

    public boolean equals(Object o2) {
        AdInformationConfig adInformationConfig;
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        adInformationConfig = adInformationConfig;
        return this.enabled == adInformationConfig.enabled && Float.compare(adInformationConfig.fatFingersFactor, this.fatFingersFactor) == 0 && z.b(this.consentTypeInfo, adInformationConfig.consentTypeInfo) && z.b(this.dialogUrlSecured, adInformationConfig.dialogUrlSecured) && z.b(this.eulaUrlSecured, adInformationConfig.eulaUrlSecured) && z.b(this.Positions, adInformationConfig.Positions) && z.b(this.ImageResources, adInformationConfig.ImageResources);
    }

    public int hashCode() {
        return z.a(this.enabled, this.consentTypeInfo, Float.valueOf(this.fatFingersFactor), this.dialogUrlSecured, this.eulaUrlSecured, this.Positions, this.ImageResources);
    }

    public static enum ImageResourceType {
        INFO_S(17, 14),
        INFO_EX_S(88, 14),
        INFO_L(25, 21),
        INFO_EX_L(130, 21);

        private final int width;
        private final int height;

        /*
         * WARNING - void declaration
         */
        private ImageResourceType(int width, int height) {
            void var3_3;
            this.width = var3_3;
            this.height = height;
        }

        public final int getDefaultWidth() {
            return this.width;
        }

        public final int getDefaultHeight() {
            return this.height;
        }

        public static ImageResourceType getByName(String name) {
            ImageResourceType imageResourceType = INFO_S;
            for (ImageResourceType imageResourceType2 : ImageResourceType.values()) {
                if (imageResourceType2.name().toLowerCase().compareTo(name.toLowerCase()) != 0) continue;
                imageResourceType = imageResourceType2;
            }
            return imageResourceType;
        }
    }
}

