/*
 * Decompiled with CFR 0.152.
 */
package com.startapp.sdk.jobs;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.os.PersistableBundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.startapp.common.b.b;
import com.startapp.sdk.jobs.JobRequest;
import com.startapp.sdk.jobs.h;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=21)
public class e
implements h {
    @NonNull
    private static final String a = e.class.getSimpleName();
    @NonNull
    private final JobScheduler b;
    @NonNull
    private final ComponentName c;
    private final boolean d;

    public e(@NonNull Context context, @NonNull Class<? extends JobService> clazz) throws IllegalStateException {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler == null) {
            throw new IllegalStateException();
        }
        this.b = jobScheduler;
        this.c = new ComponentName(context, clazz);
        this.d = com.startapp.common.b.b.a(context, "android.permission.RECEIVE_BOOT_COMPLETED");
    }

    @NonNull
    private JobInfo.Builder a(@NonNull JobRequest jobRequest, @Nullable Integer n2) {
        JobInfo.Builder builder = new JobInfo.Builder(n2 != null ? n2.intValue() : jobRequest.e(), this.c);
        PersistableBundle persistableBundle = new PersistableBundle();
        persistableBundle.putString("extraKeyUuid", jobRequest.b().toString());
        persistableBundle.putStringArray("extraKeyTags", jobRequest.a());
        if (n2 != null) {
            persistableBundle.putInt("extraKeyDuplicate", 1);
        }
        builder.setExtras(persistableBundle);
        if (jobRequest.c() != null) {
            builder.setRequiredNetworkType(jobRequest.c() == JobRequest.Network.b ? 2 : (jobRequest.c() == JobRequest.Network.a ? 1 : 0));
        }
        if (this.d) {
            builder.setPersisted(true);
        }
        return builder;
    }

    private boolean a(@NonNull JobInfo jobInfo, @NonNull JobRequest jobRequest) {
        boolean bl = false;
        try {
            bl = this.b.schedule(jobInfo) == 1;
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)a, (String)("JobScheduler 100 job limit exceeded. Unable to schedule " + jobRequest.a()[0]));
        }
        catch (Throwable throwable) {
            Log.e((String)a, (String)("Unable to schedule " + jobRequest.a()[0]));
        }
        return bl;
    }

    @Nullable
    private List<JobInfo> a() {
        Object object = null;
        try {
            object = this.b.getAllPendingJobs();
        }
        catch (Throwable throwable) {
            Log.e((String)a, (String)"getAllPendingJobs() is not reliable on this device.");
        }
        if (object == null) {
            return null;
        }
        ArrayList<JobInfo> arrayList = new ArrayList<JobInfo>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            JobInfo jobInfo = (JobInfo)object.next();
            if (!this.c.equals((Object)jobInfo.getService())) continue;
            arrayList.add(jobInfo);
        }
        return arrayList;
    }

    @Nullable
    private List<Integer> a(@NonNull String string) {
        List<JobInfo> list = this.a();
        if (list == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        for (JobInfo jobInfo : list) {
            PersistableBundle persistableBundle = jobInfo.getExtras();
            try {
                if (!persistableBundle.containsKey("extraKeyUuid") || !string.equals(persistableBundle.getString("extraKeyUuid"))) continue;
                arrayList.add(jobInfo.getId());
            }
            catch (NullPointerException nullPointerException) {}
        }
        return arrayList;
    }

    private static void a(@NonNull JobInfo.Builder builder, @Nullable Long l2) {
        if (l2 != null || Build.VERSION.SDK_INT <= 28) {
            builder.setMinimumLatency(l2 != null ? l2 : 0L);
        }
    }

    @Override
    public final boolean a(@NonNull JobRequest jobRequest, long l2) {
        JobInfo.Builder builder = this.a(jobRequest, (Integer)null);
        if (Build.VERSION.SDK_INT >= 24) {
            return this.a(builder.setPeriodic(l2, JobInfo.getMinFlexMillis()).build(), jobRequest);
        }
        for (JobInfo jobInfo : this.a()) {
            if (jobInfo.getId() != jobRequest.e() || jobInfo.getIntervalMillis() != l2) continue;
            return false;
        }
        return this.a(builder.setPeriodic(l2).build(), jobRequest);
    }

    @Override
    public final boolean a(@NonNull JobRequest jobRequest, @Nullable Long l2) {
        List<Integer> list;
        JobInfo.Builder builder = this.a(jobRequest, (Integer)null);
        e.a(builder, l2);
        builder = builder.build();
        boolean bl = this.a((JobInfo)builder, jobRequest);
        if (Build.VERSION.SDK_INT == 23 && (list = this.a(jobRequest.b().toString())) != null) {
            int n2 = builder.getId();
            int n3 = list.indexOf(n2);
            if (n3 >= 0) {
                list.remove(n3);
            }
            n2 = !list.isEmpty() ? list.get(0) : (n2 < Integer.MAX_VALUE ? n2 + 1 : n2 - 1);
            JobInfo.Builder builder2 = this.a(jobRequest, (Integer)n2);
            e.a(builder2, l2);
            this.a(builder2.build(), jobRequest);
        }
        return bl;
    }

    @Override
    public final boolean a(int n2) {
        List<JobInfo> list = this.a();
        if (list == null) {
            return false;
        }
        try {
            list = list.iterator();
            while (list.hasNext()) {
                if (((JobInfo)list.next()).getId() != n2) continue;
                this.b.cancel(n2);
                return true;
            }
        }
        catch (Throwable throwable) {
            Log.e((String)a, (String)"cancel(jobId) is not reliable on this device.");
        }
        return false;
    }
}

