/*
 * Decompiled with CFR 0.152.
 */
package com.bornfight.demo.weather.model;

import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.TypeConverters;
import com.bornfight.demo.weather.model.Main;
import com.bornfight.demo.weather.model.Weather;
import com.bornfight.demo.weather.model.WeatherConverter;
import com.google.gson.annotations.SerializedName;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u001b\u001a\u00020\tJ\u0006\u0010\u001c\u001a\u00020\tJ\u0006\u0010\u001d\u001a\u00020\tJ\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\b\u001a\u00020!J\t\u0010\"\u001a\u00020\tH\u00d6\u0001R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/bornfight/demo/weather/model/Forecast;", "", "()V", "main", "Lcom/bornfight/demo/weather/model/Main;", "weather", "", "Lcom/bornfight/demo/weather/model/Weather;", "date", "", "name", "(Lcom/bornfight/demo/weather/model/Main;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getDate", "()Ljava/lang/String;", "getMain", "()Lcom/bornfight/demo/weather/model/Main;", "getName", "getWeather", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getDateString", "getImageUrl", "getTimeString", "hashCode", "", "isSelectedDate", "", "toString", "sdk_release"})
@Entity(primaryKeys={"date", "name"})
@TypeConverters(value={WeatherConverter.class})
public final class Forecast {
    @SerializedName(value="main")
    @Embedded
    @NotNull
    private final Main main;
    @SerializedName(value="weather")
    @NotNull
    private final List<Weather> weather;
    @SerializedName(value="dt_txt")
    @NotNull
    private final String date;
    @NotNull
    private final String name;

    @NotNull
    public final String getImageUrl() {
        return "https://openweathermap.org/img/w/" + this.weather.get(0).getIcon() + ".png";
    }

    @NotNull
    public final String getTimeString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        SimpleDateFormat format = new SimpleDateFormat("HH:mm", Locale.US);
        String string2 = format.format(dateFormat.parse(this.date));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"format.format(dateFormat.parse(date))");
        return string2;
    }

    @NotNull
    public final String getDateString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.", Locale.US);
        String string2 = format.format(dateFormat.parse(this.date));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"format.format(dateFormat.parse(date))");
        return string2;
    }

    public final boolean isSelectedDate(long date2) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        CharSequence charSequence = this.date;
        String string2 = format.format(date2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"format.format(date)");
        return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null);
    }

    @NotNull
    public final Main getMain() {
        return this.main;
    }

    @NotNull
    public final List<Weather> getWeather() {
        return this.weather;
    }

    @NotNull
    public final String getDate() {
        return this.date;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public Forecast(@NotNull Main main, @NotNull List<Weather> weather, @NotNull String date2, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)main, (String)"main");
        Intrinsics.checkParameterIsNotNull(weather, (String)"weather");
        Intrinsics.checkParameterIsNotNull((Object)date2, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.main = main;
        this.weather = weather;
        this.date = date2;
        this.name = name;
    }

    public /* synthetic */ Forecast(Main main, List list, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string3 = "";
        }
        this(main, list, string2, string3);
    }

    public Forecast() {
        this(new Main(0.0, 0.0, 0.0), CollectionsKt.emptyList(), "", "");
    }

    @NotNull
    public final Main component1() {
        return this.main;
    }

    @NotNull
    public final List<Weather> component2() {
        return this.weather;
    }

    @NotNull
    public final String component3() {
        return this.date;
    }

    @NotNull
    public final String component4() {
        return this.name;
    }

    @NotNull
    public final Forecast copy(@NotNull Main main, @NotNull List<Weather> weather, @NotNull String date2, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)main, (String)"main");
        Intrinsics.checkParameterIsNotNull(weather, (String)"weather");
        Intrinsics.checkParameterIsNotNull((Object)date2, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new Forecast(main, weather, date2, name);
    }

    public static /* synthetic */ Forecast copy$default(Forecast forecast, Main main, List list, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            main = forecast.main;
        }
        if ((n & 2) != 0) {
            list = forecast.weather;
        }
        if ((n & 4) != 0) {
            string2 = forecast.date;
        }
        if ((n & 8) != 0) {
            string3 = forecast.name;
        }
        return forecast.copy(main, list, string2, string3);
    }

    @NotNull
    public String toString() {
        return "Forecast(main=" + this.main + ", weather=" + this.weather + ", date=" + this.date + ", name=" + this.name + ")";
    }

    public int hashCode() {
        Main main = this.main;
        List<Weather> list = this.weather;
        String string2 = this.date;
        String string3 = this.name;
        return (((main != null ? ((Object)main).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Forecast)) break block3;
                Forecast forecast = (Forecast)object;
                if (!Intrinsics.areEqual((Object)this.main, (Object)forecast.main) || !Intrinsics.areEqual(this.weather, forecast.weather) || !Intrinsics.areEqual((Object)this.date, (Object)forecast.date) || !Intrinsics.areEqual((Object)this.name, (Object)forecast.name)) break block3;
            }
            return true;
        }
        return false;
    }
}

