/*
 * Decompiled with CFR 0.152.
 */
package com.bornfight.demo.weather.repository.weather;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.bornfight.demo.weather.model.Forecast;
import com.bornfight.demo.weather.model.Main;
import com.bornfight.demo.weather.model.Weather;
import com.bornfight.demo.weather.model.WeatherConverter;
import com.bornfight.demo.weather.model.WeatherResponse;
import com.bornfight.demo.weather.repository.weather.WeatherDao;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class WeatherDao_Impl
implements WeatherDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<WeatherResponse> __insertionAdapterOfWeatherResponse;
    private final WeatherConverter __weatherConverter = new WeatherConverter();
    private final EntityInsertionAdapter<Forecast> __insertionAdapterOfForecast;
    private final SharedSQLiteStatement __preparedStmtOfClearForecastTable;

    public WeatherDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfWeatherResponse = new EntityInsertionAdapter<WeatherResponse>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `WeatherResponse` (`id`,`weather`,`name`,`date`,`temp`,`minTemp`,`maxTemp`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, WeatherResponse value) {
                stmt.bindLong(1, (long)value.getId());
                String _tmp = WeatherDao_Impl.this.__weatherConverter.fromWeatherList(value.getWeather());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                stmt.bindLong(4, value.getDate());
                Main _tmpMain = value.getMain();
                if (_tmpMain != null) {
                    stmt.bindDouble(5, _tmpMain.getTemp());
                    stmt.bindDouble(6, _tmpMain.getMinTemp());
                    stmt.bindDouble(7, _tmpMain.getMaxTemp());
                } else {
                    stmt.bindNull(5);
                    stmt.bindNull(6);
                    stmt.bindNull(7);
                }
            }
        };
        this.__insertionAdapterOfForecast = new EntityInsertionAdapter<Forecast>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Forecast` (`weather`,`date`,`name`,`temp`,`minTemp`,`maxTemp`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Forecast value) {
                String _tmp = WeatherDao_Impl.this.__weatherConverter.fromWeatherList(value.getWeather());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getDate() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDate());
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                Main _tmpMain = value.getMain();
                if (_tmpMain != null) {
                    stmt.bindDouble(4, _tmpMain.getTemp());
                    stmt.bindDouble(5, _tmpMain.getMinTemp());
                    stmt.bindDouble(6, _tmpMain.getMaxTemp());
                } else {
                    stmt.bindNull(4);
                    stmt.bindNull(5);
                    stmt.bindNull(6);
                }
            }
        };
        this.__preparedStmtOfClearForecastTable = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Forecast";
                return "DELETE FROM Forecast";
            }
        };
    }

    @Override
    public void saveWeatherData(WeatherResponse weather) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfWeatherResponse.insert((Object)weather);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void saveForecastData(List<Forecast> forecast) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfForecast.insert(forecast);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clearForecastTable() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClearForecastTable.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClearForecastTable.release(_stmt);
        }
    }

    @Override
    public Observable<WeatherResponse> getWeatherData(String city) {
        String _sql = "SELECT * FROM WeatherResponse WHERE name = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM WeatherResponse WHERE name = ?", (int)1);
        int _argIndex = 1;
        if (city == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, city);
        }
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"WeatherResponse"}, (Callable)new Callable<WeatherResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WeatherResponse call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)WeatherDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    WeatherResponse _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfWeather = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"weather");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
                    int _cursorIndexOfTemp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"temp");
                    int _cursorIndexOfMinTemp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minTemp");
                    int _cursorIndexOfMaxTemp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxTemp");
                    if (_cursor.moveToFirst()) {
                        Main _tmpMain;
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        String _tmp = _cursor.getString(_cursorIndexOfWeather);
                        List<Weather> _tmpWeather = WeatherDao_Impl.this.__weatherConverter.toWeatherList(_tmp);
                        String _tmpName = _cursor.getString(_cursorIndexOfName);
                        long _tmpDate = _cursor.getLong(_cursorIndexOfDate);
                        if (!(_cursor.isNull(_cursorIndexOfTemp) && _cursor.isNull(_cursorIndexOfMinTemp) && _cursor.isNull(_cursorIndexOfMaxTemp))) {
                            double _tmpTemp = _cursor.getDouble(_cursorIndexOfTemp);
                            double _tmpMinTemp = _cursor.getDouble(_cursorIndexOfMinTemp);
                            double _tmpMaxTemp = _cursor.getDouble(_cursorIndexOfMaxTemp);
                            _tmpMain = new Main(_tmpTemp, _tmpMinTemp, _tmpMaxTemp);
                        } else {
                            _tmpMain = null;
                        }
                        _result = new WeatherResponse(_tmpId, _tmpWeather, _tmpMain, _tmpName, _tmpDate);
                    } else {
                        _result = null;
                    }
                    WeatherResponse weatherResponse = _result;
                    return weatherResponse;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Observable<List<Forecast>> getForecastData(String city) {
        String _sql = "SELECT * FROM Forecast WHERE name = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Forecast WHERE name = ?", (int)1);
        int _argIndex = 1;
        if (city == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, city);
        }
        return RxRoom.createObservable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"Forecast"}, (Callable)new Callable<List<Forecast>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Forecast> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)WeatherDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfWeather = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"weather");
                    int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfTemp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"temp");
                    int _cursorIndexOfMinTemp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"minTemp");
                    int _cursorIndexOfMaxTemp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxTemp");
                    ArrayList<Forecast> _result = new ArrayList<Forecast>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        Main _tmpMain;
                        String _tmp = _cursor.getString(_cursorIndexOfWeather);
                        List<Weather> _tmpWeather = WeatherDao_Impl.this.__weatherConverter.toWeatherList(_tmp);
                        String _tmpDate = _cursor.getString(_cursorIndexOfDate);
                        String _tmpName = _cursor.getString(_cursorIndexOfName);
                        if (!(_cursor.isNull(_cursorIndexOfTemp) && _cursor.isNull(_cursorIndexOfMinTemp) && _cursor.isNull(_cursorIndexOfMaxTemp))) {
                            double _tmpTemp = _cursor.getDouble(_cursorIndexOfTemp);
                            double _tmpMinTemp = _cursor.getDouble(_cursorIndexOfMinTemp);
                            double _tmpMaxTemp = _cursor.getDouble(_cursorIndexOfMaxTemp);
                            _tmpMain = new Main(_tmpTemp, _tmpMinTemp, _tmpMaxTemp);
                        } else {
                            _tmpMain = null;
                        }
                        Forecast _item = new Forecast(_tmpMain, _tmpWeather, _tmpDate, _tmpName);
                        _result.add(_item);
                    }
                    ArrayList<Forecast> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

