/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.examples.helloworld;

import com.salesforce.reactivegrpc.common.BiConsumer;
import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.rxgrpc.stub.ClientCalls;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.examples.helloworld.GreeterGrpc;
import io.grpc.examples.helloworld.HelloReply;
import io.grpc.examples.helloworld.HelloRequest;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.reactivex.Flowable;
import io.reactivex.Single;

public final class RxGreeterGrpc {
    private static final int METHODID_SAY_HELLO = 0;
    private static final int METHODID_SAY_HELLO_AGAIN = 1;
    private static final int METHODID_SAY_HELLO_STREAM = 2;
    private static final int METHODID_TEST_SINGLE_MESSAGE_SINGLE_RESPONSE = 3;
    private static final int METHODID_TEST_SINGLE_MESSAGE_STREAM_RESPONSE = 4;
    private static final int METHODID_TEST_STREAM_SINGLE_MESSAGE_RESPONSE = 5;
    private static final int METHODID_TEST_STREAM_STREAM_RESPONSE = 6;

    private RxGreeterGrpc() {
    }

    public static RxGreeterStub newRxStub(Channel channel) {
        return new RxGreeterStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final GreeterImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(GreeterImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((HelloRequest)request), responseObserver, (Function)new Function<Single<HelloRequest>, Single<HelloReply>>(){

                        public Single<HelloReply> apply(Single<HelloRequest> single) {
                            return serviceImpl.sayHello(single);
                        }
                    });
                    break;
                }
                case 1: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((HelloRequest)request), responseObserver, (Function)new Function<Single<HelloRequest>, Single<HelloReply>>(){

                        public Single<HelloReply> apply(Single<HelloRequest> single) {
                            return serviceImpl.sayHelloAgain(single);
                        }
                    });
                    break;
                }
                case 2: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToMany((Object)((HelloRequest)request), responseObserver, (Function)new Function<Single<HelloRequest>, Flowable<HelloReply>>(){

                        public Flowable<HelloReply> apply(Single<HelloRequest> single) {
                            return serviceImpl.sayHelloStream(single);
                        }
                    });
                    break;
                }
                case 3: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((HelloRequest)request), responseObserver, (Function)new Function<Single<HelloRequest>, Single<HelloReply>>(){

                        public Single<HelloReply> apply(Single<HelloRequest> single) {
                            return serviceImpl.testSingleMessageSingleResponse(single);
                        }
                    });
                    break;
                }
                case 4: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToMany((Object)((HelloRequest)request), responseObserver, (Function)new Function<Single<HelloRequest>, Flowable<HelloReply>>(){

                        public Flowable<HelloReply> apply(Single<HelloRequest> single) {
                            return serviceImpl.testSingleMessageStreamResponse(single);
                        }
                    });
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 5: {
                    return com.salesforce.rxgrpc.stub.ServerCalls.manyToOne(responseObserver, this.serviceImpl::testStreamSingleMessageResponse);
                }
                case 6: {
                    return com.salesforce.rxgrpc.stub.ServerCalls.manyToMany(responseObserver, this.serviceImpl::testStreamStreamResponse);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class GreeterImplBase
    implements BindableService {
        public Single<HelloReply> sayHello(Single<HelloRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<HelloReply> sayHelloAgain(Single<HelloRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flowable<HelloReply> sayHelloStream(Single<HelloRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<HelloReply> testSingleMessageSingleResponse(Single<HelloRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flowable<HelloReply> testSingleMessageStreamResponse(Single<HelloRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<HelloReply> testStreamSingleMessageResponse(Flowable<HelloRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Flowable<HelloReply> testStreamStreamResponse(Flowable<HelloRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)GreeterGrpc.getServiceDescriptor()).addMethod(GreeterGrpc.getSayHelloMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(GreeterGrpc.getSayHelloAgainMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(GreeterGrpc.getSayHelloStreamMethod(), ServerCalls.asyncServerStreamingCall(new MethodHandlers(this, 2))).addMethod(GreeterGrpc.getTestSingleMessageSingleResponseMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3))).addMethod(GreeterGrpc.getTestSingleMessageStreamResponseMethod(), ServerCalls.asyncServerStreamingCall(new MethodHandlers(this, 4))).addMethod(GreeterGrpc.getTestStreamSingleMessageResponseMethod(), ServerCalls.asyncClientStreamingCall(new MethodHandlers(this, 5))).addMethod(GreeterGrpc.getTestStreamStreamResponseMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 6))).build();
        }
    }

    public static final class RxGreeterStub
    extends AbstractStub<RxGreeterStub> {
        private GreeterGrpc.GreeterStub delegateStub;

        private RxGreeterStub(Channel channel) {
            super(channel);
            this.delegateStub = GreeterGrpc.newStub(channel);
        }

        private RxGreeterStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = GreeterGrpc.newStub(channel).build(channel, callOptions);
        }

        protected RxGreeterStub build(Channel channel, CallOptions callOptions) {
            return new RxGreeterStub(channel, callOptions);
        }

        public Single<HelloReply> sayHello(Single<HelloRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<HelloRequest, StreamObserver<HelloReply>>(){

                public void accept(HelloRequest request, StreamObserver<HelloReply> observer) {
                    delegateStub.sayHello(request, observer);
                }
            });
        }

        public Single<HelloReply> sayHelloAgain(Single<HelloRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<HelloRequest, StreamObserver<HelloReply>>(){

                public void accept(HelloRequest request, StreamObserver<HelloReply> observer) {
                    delegateStub.sayHelloAgain(request, observer);
                }
            });
        }

        public Flowable<HelloReply> sayHelloStream(Single<HelloRequest> rxRequest) {
            return ClientCalls.oneToMany(rxRequest, (BiConsumer)new BiConsumer<HelloRequest, StreamObserver<HelloReply>>(){

                public void accept(HelloRequest request, StreamObserver<HelloReply> observer) {
                    delegateStub.sayHelloStream(request, observer);
                }
            });
        }

        public Single<HelloReply> testSingleMessageSingleResponse(Single<HelloRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<HelloRequest, StreamObserver<HelloReply>>(){

                public void accept(HelloRequest request, StreamObserver<HelloReply> observer) {
                    delegateStub.testSingleMessageSingleResponse(request, observer);
                }
            });
        }

        public Flowable<HelloReply> testSingleMessageStreamResponse(Single<HelloRequest> rxRequest) {
            return ClientCalls.oneToMany(rxRequest, (BiConsumer)new BiConsumer<HelloRequest, StreamObserver<HelloReply>>(){

                public void accept(HelloRequest request, StreamObserver<HelloReply> observer) {
                    delegateStub.testSingleMessageStreamResponse(request, observer);
                }
            });
        }

        public Single<HelloReply> testStreamSingleMessageResponse(Flowable<HelloRequest> rxRequest) {
            return ClientCalls.manyToOne(rxRequest, (Function)new Function<StreamObserver<HelloReply>, StreamObserver<HelloRequest>>(){

                public StreamObserver<HelloRequest> apply(StreamObserver<HelloReply> observer) {
                    return delegateStub.testStreamSingleMessageResponse(observer);
                }
            });
        }

        public Flowable<HelloReply> testStreamStreamResponse(Flowable<HelloRequest> rxRequest) {
            return ClientCalls.manyToMany(rxRequest, (Function)new Function<StreamObserver<HelloReply>, StreamObserver<HelloRequest>>(){

                public StreamObserver<HelloRequest> apply(StreamObserver<HelloReply> observer) {
                    return delegateStub.testStreamStreamResponse(observer);
                }
            });
        }

        public Single<HelloReply> sayHello(HelloRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<HelloRequest, StreamObserver<HelloReply>>(){

                public void accept(HelloRequest request, StreamObserver<HelloReply> observer) {
                    delegateStub.sayHello(request, observer);
                }
            });
        }

        public Single<HelloReply> sayHelloAgain(HelloRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<HelloRequest, StreamObserver<HelloReply>>(){

                public void accept(HelloRequest request, StreamObserver<HelloReply> observer) {
                    delegateStub.sayHelloAgain(request, observer);
                }
            });
        }

        public Flowable<HelloReply> sayHelloStream(HelloRequest rxRequest) {
            return ClientCalls.oneToMany((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<HelloRequest, StreamObserver<HelloReply>>(){

                public void accept(HelloRequest request, StreamObserver<HelloReply> observer) {
                    delegateStub.sayHelloStream(request, observer);
                }
            });
        }

        public Single<HelloReply> testSingleMessageSingleResponse(HelloRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<HelloRequest, StreamObserver<HelloReply>>(){

                public void accept(HelloRequest request, StreamObserver<HelloReply> observer) {
                    delegateStub.testSingleMessageSingleResponse(request, observer);
                }
            });
        }

        public Flowable<HelloReply> testSingleMessageStreamResponse(HelloRequest rxRequest) {
            return ClientCalls.oneToMany((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<HelloRequest, StreamObserver<HelloReply>>(){

                public void accept(HelloRequest request, StreamObserver<HelloReply> observer) {
                    delegateStub.testSingleMessageStreamResponse(request, observer);
                }
            });
        }
    }
}

