/*
 * Decompiled with CFR 0.152.
 */
package com.bornfight.common.dagger.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.bornfight.common.dagger.components.StreamLayerComponent;
import com.bornfight.common.dagger.modules.ApiServiceModule;
import com.bornfight.common.dagger.modules.ApiServiceModule_ApiServiceFactory;
import com.bornfight.common.dagger.modules.ApiServiceModule_RetrofitFactory;
import com.bornfight.common.dagger.modules.ContextModule;
import com.bornfight.common.dagger.modules.ContextModule_ContextFactory;
import com.bornfight.common.dagger.modules.DatabaseModule;
import com.bornfight.common.dagger.modules.DatabaseModule_DatabaseFactory;
import com.bornfight.common.dagger.modules.GrpcServiceModule;
import com.bornfight.common.dagger.modules.GrpcServiceModule_GrpcFactory;
import com.bornfight.common.dagger.modules.NetworkModule;
import com.bornfight.common.dagger.modules.NetworkModule_OkHttpClientFactory;
import com.bornfight.common.dagger.modules.NetworkModule_RequestInterceptorFactory;
import com.bornfight.common.dagger.modules.RepositoryModule;
import com.bornfight.common.dagger.modules.RepositoryModule_ProvidesCurrentGrpcrepoFactory;
import com.bornfight.common.dagger.modules.RepositoryModule_ProvidesCurrentWeatherRepoFactory;
import com.bornfight.common.dagger.modules.RepositoryModule_ProvidesSearchSuggestionRepoFactory;
import com.bornfight.common.dagger.modules.ViewModelFactoryModule;
import com.bornfight.common.dagger.modules.ViewModelFactoryModule_ProvideViewModelFactoryFactory;
import com.bornfight.common.data.database.AppDatabase;
import com.bornfight.common.data.grpc.GrpcService;
import com.bornfight.common.data.retrofit.ApiInterface;
import com.bornfight.common.mvvm.ViewModelFactory;
import com.bornfight.common.mvvm.ViewModelFactory_Factory;
import com.bornfight.common.scheduler.AndroidSchedulerProvider_Factory;
import com.bornfight.common.scheduler.SchedulerProvider;
import com.bornfight.common.session.DevicePreferences;
import com.bornfight.common.session.DevicePreferences_Factory;
import com.bornfight.common.session.SessionPrefImpl;
import com.bornfight.common.session.SessionPrefImpl_Factory;
import com.bornfight.demo.weather.intro.IntroViewModel;
import com.bornfight.demo.weather.intro.IntroViewModel_Factory;
import com.bornfight.demo.weather.repository.grpc.GrpcRepo;
import com.bornfight.demo.weather.repository.grpc.GrpcRepoImpl;
import com.bornfight.demo.weather.repository.grpc.GrpcRepoImpl_Factory;
import com.bornfight.demo.weather.repository.mock.MockRepo;
import com.bornfight.demo.weather.repository.searchsuggestion.SearchSuggestionRepo;
import com.bornfight.demo.weather.repository.searchsuggestion.SearchSuggestionRepoImpl;
import com.bornfight.demo.weather.repository.searchsuggestion.SearchSuggestionRepoImpl_Factory;
import com.bornfight.demo.weather.repository.weather.WeatherRepo;
import com.bornfight.demo.weather.repository.weather.WeatherRepoImpl;
import com.bornfight.demo.weather.repository.weather.WeatherRepoImpl_Factory;
import com.bornfight.demo.weather.weather.WeatherViewModel;
import com.bornfight.demo.weather.weather.WeatherViewModel_Factory;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import java.util.Map;
import javax.inject.Provider;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public final class DaggerStreamLayerComponent
implements StreamLayerComponent {
    private final ViewModelFactoryModule viewModelFactoryModule;
    private Provider<Context> contextProvider;
    private Provider<DevicePreferences> devicePreferencesProvider;
    private Provider<SessionPrefImpl> sessionPrefImplProvider;
    private Provider<Interceptor> requestInterceptorProvider;
    private Provider<OkHttpClient> okHttpClientProvider;
    private Provider<Retrofit> retrofitProvider;
    private Provider<ApiInterface> apiServiceProvider;
    private Provider<GrpcService> grpcProvider;
    private Provider<AppDatabase> databaseProvider;
    private Provider<SearchSuggestionRepoImpl> searchSuggestionRepoImplProvider;
    private Provider<SearchSuggestionRepo> providesSearchSuggestionRepoProvider;
    private Provider<GrpcRepoImpl> grpcRepoImplProvider;
    private Provider<GrpcRepo> providesCurrentGrpcrepoProvider;
    private Provider<IntroViewModel> introViewModelProvider;
    private Provider<WeatherRepoImpl> weatherRepoImplProvider;
    private Provider<WeatherRepo> providesCurrentWeatherRepoProvider;
    private Provider<WeatherViewModel> weatherViewModelProvider;
    private Provider<Map<Class<? extends ViewModel>, Provider<ViewModel>>> mapOfClassOfAndProviderOfViewModelProvider;
    private Provider<ViewModelFactory> viewModelFactoryProvider;

    private DaggerStreamLayerComponent(ApiServiceModule apiServiceModuleParam, NetworkModule networkModuleParam, ContextModule contextModuleParam, GrpcServiceModule grpcServiceModuleParam, DatabaseModule databaseModuleParam, RepositoryModule repositoryModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam) {
        this.viewModelFactoryModule = viewModelFactoryModuleParam;
        this.initialize(apiServiceModuleParam, networkModuleParam, contextModuleParam, grpcServiceModuleParam, databaseModuleParam, repositoryModuleParam, viewModelFactoryModuleParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(ApiServiceModule apiServiceModuleParam, NetworkModule networkModuleParam, ContextModule contextModuleParam, GrpcServiceModule grpcServiceModuleParam, DatabaseModule databaseModuleParam, RepositoryModule repositoryModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam) {
        this.contextProvider = DoubleCheck.provider((Provider)ContextModule_ContextFactory.create(contextModuleParam));
        this.devicePreferencesProvider = DoubleCheck.provider((Provider)DevicePreferences_Factory.create(this.contextProvider));
        this.sessionPrefImplProvider = DoubleCheck.provider((Provider)SessionPrefImpl_Factory.create(this.contextProvider, this.devicePreferencesProvider));
        this.requestInterceptorProvider = DoubleCheck.provider((Provider)NetworkModule_RequestInterceptorFactory.create(networkModuleParam, this.sessionPrefImplProvider));
        this.okHttpClientProvider = DoubleCheck.provider((Provider)NetworkModule_OkHttpClientFactory.create(networkModuleParam, this.requestInterceptorProvider));
        this.retrofitProvider = DoubleCheck.provider((Provider)ApiServiceModule_RetrofitFactory.create(apiServiceModuleParam, this.okHttpClientProvider, this.sessionPrefImplProvider));
        this.apiServiceProvider = DoubleCheck.provider((Provider)ApiServiceModule_ApiServiceFactory.create(apiServiceModuleParam, this.retrofitProvider));
        this.grpcProvider = DoubleCheck.provider((Provider)GrpcServiceModule_GrpcFactory.create(grpcServiceModuleParam, this.sessionPrefImplProvider));
        this.databaseProvider = DoubleCheck.provider((Provider)DatabaseModule_DatabaseFactory.create(databaseModuleParam, this.contextProvider));
        this.searchSuggestionRepoImplProvider = SearchSuggestionRepoImpl_Factory.create(this.databaseProvider, this.apiServiceProvider, this.sessionPrefImplProvider, this.devicePreferencesProvider);
        this.providesSearchSuggestionRepoProvider = DoubleCheck.provider((Provider)RepositoryModule_ProvidesSearchSuggestionRepoFactory.create(repositoryModuleParam, this.searchSuggestionRepoImplProvider));
        this.grpcRepoImplProvider = GrpcRepoImpl_Factory.create(this.databaseProvider, this.apiServiceProvider, this.grpcProvider, this.sessionPrefImplProvider, this.devicePreferencesProvider);
        this.providesCurrentGrpcrepoProvider = DoubleCheck.provider((Provider)RepositoryModule_ProvidesCurrentGrpcrepoFactory.create(repositoryModuleParam, this.grpcRepoImplProvider));
        this.introViewModelProvider = IntroViewModel_Factory.create((Provider<SchedulerProvider>)AndroidSchedulerProvider_Factory.create(), this.providesSearchSuggestionRepoProvider, this.providesCurrentGrpcrepoProvider, this.sessionPrefImplProvider, this.apiServiceProvider);
        this.weatherRepoImplProvider = WeatherRepoImpl_Factory.create(this.databaseProvider, this.apiServiceProvider, this.sessionPrefImplProvider, this.devicePreferencesProvider);
        this.providesCurrentWeatherRepoProvider = DoubleCheck.provider((Provider)RepositoryModule_ProvidesCurrentWeatherRepoFactory.create(repositoryModuleParam, this.weatherRepoImplProvider));
        this.weatherViewModelProvider = WeatherViewModel_Factory.create((Provider<SchedulerProvider>)AndroidSchedulerProvider_Factory.create(), this.providesCurrentWeatherRepoProvider, this.providesCurrentGrpcrepoProvider, this.sessionPrefImplProvider, this.apiServiceProvider);
        this.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)2).put(IntroViewModel.class, this.introViewModelProvider).put(WeatherViewModel.class, this.weatherViewModelProvider).build();
        this.viewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactory_Factory.create(this.mapOfClassOfAndProviderOfViewModelProvider));
    }

    @Override
    public Context getContext() {
        return (Context)this.contextProvider.get();
    }

    @Override
    public ApiInterface getApiInterface() {
        return (ApiInterface)this.apiServiceProvider.get();
    }

    @Override
    public GrpcService getGrpcService() {
        return (GrpcService)this.grpcProvider.get();
    }

    @Override
    public AppDatabase getDatabase() {
        return (AppDatabase)((Object)this.databaseProvider.get());
    }

    @Override
    public SessionPrefImpl getSessionPrefImpl() {
        return (SessionPrefImpl)this.sessionPrefImplProvider.get();
    }

    @Override
    public DevicePreferences getDevicePrefs() {
        return (DevicePreferences)this.devicePreferencesProvider.get();
    }

    @Override
    public ViewModelProvider.Factory getViewModelFactoryProvider() {
        return ViewModelFactoryModule_ProvideViewModelFactoryFactory.provideViewModelFactory(this.viewModelFactoryModule, (ViewModelFactory)this.viewModelFactoryProvider.get());
    }

    @Override
    public MockRepo getMockRepo() {
        return new MockRepo((AppDatabase)((Object)this.databaseProvider.get()), (ApiInterface)this.apiServiceProvider.get(), (SessionPrefImpl)this.sessionPrefImplProvider.get());
    }

    public static final class Builder {
        private ApiServiceModule apiServiceModule;
        private NetworkModule networkModule;
        private ContextModule contextModule;
        private GrpcServiceModule grpcServiceModule;
        private DatabaseModule databaseModule;
        private RepositoryModule repositoryModule;
        private ViewModelFactoryModule viewModelFactoryModule;

        private Builder() {
        }

        public Builder apiServiceModule(ApiServiceModule apiServiceModule) {
            this.apiServiceModule = (ApiServiceModule)Preconditions.checkNotNull((Object)apiServiceModule);
            return this;
        }

        public Builder networkModule(NetworkModule networkModule) {
            this.networkModule = (NetworkModule)Preconditions.checkNotNull((Object)networkModule);
            return this;
        }

        public Builder contextModule(ContextModule contextModule) {
            this.contextModule = (ContextModule)Preconditions.checkNotNull((Object)contextModule);
            return this;
        }

        public Builder grpcServiceModule(GrpcServiceModule grpcServiceModule) {
            this.grpcServiceModule = (GrpcServiceModule)Preconditions.checkNotNull((Object)grpcServiceModule);
            return this;
        }

        public Builder databaseModule(DatabaseModule databaseModule) {
            this.databaseModule = (DatabaseModule)Preconditions.checkNotNull((Object)databaseModule);
            return this;
        }

        public Builder repositoryModule(RepositoryModule repositoryModule) {
            this.repositoryModule = (RepositoryModule)Preconditions.checkNotNull((Object)repositoryModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public StreamLayerComponent build() {
            if (this.apiServiceModule == null) {
                this.apiServiceModule = new ApiServiceModule();
            }
            if (this.networkModule == null) {
                this.networkModule = new NetworkModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.contextModule, ContextModule.class);
            if (this.grpcServiceModule == null) {
                this.grpcServiceModule = new GrpcServiceModule();
            }
            if (this.databaseModule == null) {
                this.databaseModule = new DatabaseModule();
            }
            if (this.repositoryModule == null) {
                this.repositoryModule = new RepositoryModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            return new DaggerStreamLayerComponent(this.apiServiceModule, this.networkModule, this.contextModule, this.grpcServiceModule, this.databaseModule, this.repositoryModule, this.viewModelFactoryModule);
        }
    }
}

