/*
 * Decompiled with CFR 0.152.
 */
package com.bornfight.common.dagger.modules;

import com.bornfight.common.dagger.modules.NetworkModule;
import com.bornfight.common.data.retrofit.ApiInterface;
import com.bornfight.common.data.retrofit.RxErrorHandlingCallAdapterFactory;
import com.bornfight.common.session.SessionPrefImpl;
import com.bornfight.utils.GsonUtil;
import com.google.gson.Gson;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;

@Module(includes={NetworkModule.class})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/bornfight/common/dagger/modules/ApiServiceModule;", "", "()V", "apiService", "Lcom/bornfight/common/data/retrofit/ApiInterface;", "retrofit", "Lretrofit2/Retrofit;", "client", "Lokhttp3/OkHttpClient;", "sessionPref", "Lcom/bornfight/common/session/SessionPrefImpl;", "sdk_release"})
public final class ApiServiceModule {
    @Provides
    @Singleton
    @NotNull
    public final ApiInterface apiService(@NotNull Retrofit retrofit) {
        Intrinsics.checkParameterIsNotNull((Object)retrofit, (String)"retrofit");
        Object object = retrofit.create(ApiInterface.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"retrofit.create(ApiInterface::class.java)");
        return (ApiInterface)object;
    }

    @Provides
    @Singleton
    @NotNull
    public final Retrofit retrofit(@NotNull OkHttpClient client, @NotNull SessionPrefImpl sessionPref) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)sessionPref, (String)"sessionPref");
        Gson gson = GsonUtil.INSTANCE.getDefaultGson();
        String baseUrl = sessionPref.apiBaseUrl();
        Retrofit.Builder builder = new Retrofit.Builder().client(client);
        String string = baseUrl;
        if (string == null) {
            string = "https://api.openweathermap.org/data/2.5/";
        }
        Retrofit retrofit = builder.baseUrl(string).addCallAdapterFactory(RxErrorHandlingCallAdapterFactory.Companion.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"Retrofit.Builder()\n     \u2026e())\n            .build()");
        return retrofit;
    }
}

