/*
 * Decompiled with CFR 0.152.
 */
package com.bornfight.common.dagger.modules;

import android.content.Context;
import com.bornfight.common.dagger.modules.ContextModule;
import com.bornfight.common.session.SessionPrefImpl;
import dagger.Module;
import dagger.Provides;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Module(includes={ContextModule.class})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/bornfight/common/dagger/modules/NetworkModule;", "", "()V", "addCacheInterceptor", "", "context", "Landroid/content/Context;", "client", "Lokhttp3/OkHttpClient$Builder;", "okHttpClient", "Lokhttp3/OkHttpClient;", "requestInterceptor", "Lokhttp3/Interceptor;", "sessionPref", "Lcom/bornfight/common/session/SessionPrefImpl;", "sdk_release"})
public final class NetworkModule {
    @Provides
    @Singleton
    @NotNull
    public final Interceptor requestInterceptor(@NotNull SessionPrefImpl sessionPref) {
        Intrinsics.checkParameterIsNotNull((Object)sessionPref, (String)"sessionPref");
        Interceptor.Companion this_$iv = Interceptor.Companion;
        boolean $i$f$invoke = false;
        return new Interceptor(sessionPref){
            final /* synthetic */ SessionPrefImpl $sessionPref$inlined;
            {
                this.$sessionPref$inlined = sessionPrefImpl;
            }

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                Request original = chain2.request();
                HttpUrl authUrl = original.url().newBuilder().addQueryParameter("appid", "58ec2965ac00044167274743ab560872").build();
                Request.Builder requestBuilder = original.newBuilder().url(authUrl).header("Accept", "application/json").method(original.method(), original.body());
                CharSequence charSequence = this.$sessionPref$inlined.getToken();
                boolean bl2 = false;
                if (charSequence.length() > 0 && !chain2.request().url().pathSegments().contains("login")) {
                    requestBuilder.addHeader("Authorization", "58ec2965ac00044167274743ab560872");
                }
                Request request = requestBuilder.build();
                return chain2.proceed(request);
            }
        };
    }

    @Provides
    @Singleton
    @NotNull
    public final OkHttpClient okHttpClient(@NotNull Interceptor requestInterceptor) {
        Intrinsics.checkParameterIsNotNull((Object)requestInterceptor, (String)"requestInterceptor");
        OkHttpClient.Builder client = new OkHttpClient.Builder();
        client.addInterceptor(requestInterceptor);
        return client.build();
    }

    private final void addCacheInterceptor(Context context, OkHttpClient.Builder client) {
        Interceptor.Companion this_$iv = Interceptor.Companion;
        boolean $i$f$invoke = false;
        Interceptor cacheInterceptor = new Interceptor(){

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                Response response = chain2.proceed(chain2.request());
                CacheControl cacheControl = new CacheControl.Builder().maxAge(2, TimeUnit.MINUTES).build();
                return response.newBuilder().header("Cache-Control", cacheControl.toString()).build();
            }
        };
        Cache cache = new Cache(new File(context.getCacheDir(), "http-cache"), (long)0xA00000);
        client.addNetworkInterceptor(cacheInterceptor);
        client.cache(cache);
    }
}

