/*
 * Decompiled with CFR 0.152.
 */
package com.bornfight.common.session;

import android.content.Context;
import android.content.SharedPreferences;
import com.bornfight.common.session.DevicePreferences;
import com.bornfight.common.session.Session;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0001\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\rH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0015\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010\rJ\u0018\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010(\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\u0018\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\bH\u0016J\u0018\u0010,\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010-\u001a\u00020\bH\u0016J\u0010\u0010.\u001a\u00020\b2\u0006\u0010*\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006/"}, d2={"Lcom/bornfight/common/session/SessionPrefImpl;", "Lcom/bornfight/common/session/Session;", "context", "Landroid/content/Context;", "devicePreferences", "Lcom/bornfight/common/session/DevicePreferences;", "(Landroid/content/Context;Lcom/bornfight/common/session/DevicePreferences;)V", "isLoggedIn", "", "()Z", "mSharedPreferences", "Landroid/content/SharedPreferences;", "token", "", "getToken", "()Ljava/lang/String;", "setToken", "(Ljava/lang/String;)V", "userId", "", "getUserId", "()J", "setUserId", "(J)V", "apiBasePort", "", "apiBaseUrl", "checkPermissionAsked", "permission", "isTipsShown", "tipSet", "logout", "", "setApiBasePort", "basePort", "(Ljava/lang/Integer;)V", "setApiBaseUrl", "baseUrl", "setLoggedIn", "loggedIn", "setPermissionAsked", "setSkipOnboardingStep", "stepName", "skip", "setTipsShown", "shown", "shouldSkipOnboardingStep", "sdk_release"})
public final class SessionPrefImpl
implements Session {
    private final SharedPreferences mSharedPreferences;
    private final DevicePreferences devicePreferences;

    @Override
    public boolean isLoggedIn() {
        return this.mSharedPreferences.getBoolean("logged_in", false);
    }

    @Override
    public long getUserId() {
        return this.mSharedPreferences.getLong("user_id", 0L);
    }

    @Override
    public void setUserId(long userId) {
        this.mSharedPreferences.edit().putLong("user_id", userId).apply();
    }

    @Override
    @NotNull
    public String getToken() {
        String string2 = this.mSharedPreferences.getString("session_token", "");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @Override
    public void setToken(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        this.mSharedPreferences.edit().putString("session_token", "Bearer " + token).apply();
    }

    @Override
    public void setLoggedIn(boolean loggedIn, long userId) {
        this.mSharedPreferences.edit().putBoolean("logged_in", loggedIn).putLong("user_id", userId).apply();
    }

    @Override
    public void logout() {
        this.setLoggedIn(false, 0L);
        this.setToken("");
    }

    @Override
    public boolean checkPermissionAsked(@NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        return this.mSharedPreferences.contains("PERMISSION_ASKED_" + permission);
    }

    @Override
    public void setPermissionAsked(@NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        this.mSharedPreferences.edit().putBoolean("PERMISSION_ASKED_" + permission, true).apply();
    }

    @Override
    public boolean shouldSkipOnboardingStep(@NotNull String stepName) {
        Intrinsics.checkParameterIsNotNull((Object)stepName, (String)"stepName");
        return this.mSharedPreferences.getBoolean("onboarding_step_skip_" + stepName, false);
    }

    @Override
    public void setSkipOnboardingStep(@NotNull String stepName, boolean skip) {
        Intrinsics.checkParameterIsNotNull((Object)stepName, (String)"stepName");
        this.mSharedPreferences.edit().putBoolean("onboarding_step_skip_" + stepName, skip).apply();
    }

    @Override
    public boolean isTipsShown(@NotNull String tipSet) {
        Intrinsics.checkParameterIsNotNull((Object)tipSet, (String)"tipSet");
        return this.mSharedPreferences.getBoolean(tipSet + "_tips_shown", false);
    }

    @Override
    public void setTipsShown(@NotNull String tipSet, boolean shown) {
        Intrinsics.checkParameterIsNotNull((Object)tipSet, (String)"tipSet");
        this.mSharedPreferences.edit().putBoolean(tipSet + "_tips_shown", shown).apply();
    }

    @Nullable
    public final String apiBaseUrl() {
        return this.mSharedPreferences.getString("abu", null);
    }

    public final void setApiBaseUrl(@Nullable String baseUrl) {
        if (baseUrl != null) {
            this.mSharedPreferences.edit().putString("abu", baseUrl).apply();
        } else {
            this.mSharedPreferences.edit().remove("abu").apply();
        }
    }

    public final int apiBasePort() {
        return this.mSharedPreferences.getInt("abp", 0);
    }

    public final void setApiBasePort(@Nullable Integer basePort) {
        if (basePort != null) {
            this.mSharedPreferences.edit().putInt("abp", basePort.intValue()).apply();
        } else {
            this.mSharedPreferences.edit().remove("abp").apply();
        }
    }

    @Inject
    public SessionPrefImpl(@NotNull Context context, @NotNull DevicePreferences devicePreferences) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)devicePreferences, (String)"devicePreferences");
        this.devicePreferences = devicePreferences;
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.bornfight.streamlayersdk_session", 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026xt.MODE_PRIVATE\n        )");
        this.mSharedPreferences = sharedPreferences;
    }
}

