/*
 * Decompiled with CFR 0.152.
 */
package com.bornfight.demo.weather.model;

import androidx.room.TypeConverter;
import com.bornfight.demo.weather.model.Weather;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/bornfight/demo/weather/model/WeatherConverter;", "", "()V", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "fromWeatherList", "", "weather", "", "Lcom/bornfight/demo/weather/model/Weather;", "toWeatherList", "sdk_release"})
public final class WeatherConverter {
    @NotNull
    private final Gson gson = new Gson();

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    @TypeConverter
    @NotNull
    public final String fromWeatherList(@NotNull List<Weather> weather) {
        Intrinsics.checkParameterIsNotNull(weather, (String)"weather");
        String string2 = this.gson.toJson(weather);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gson.toJson(weather)");
        return string2;
    }

    @TypeConverter
    @NotNull
    public final List<Weather> toWeatherList(@Nullable String weather) {
        CharSequence charSequence = weather;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            boolean bl3 = false;
            return CollectionsKt.emptyList();
        }
        Type listType2 = new TypeToken<List<? extends Weather>>(){}.getType();
        Object object = this.gson.fromJson(weather, listType2);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(weather, listType)");
        return (List)object;
    }
}

