/*
 * Decompiled with CFR 0.152.
 */
package com.bornfight.common.data.database;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.bornfight.common.data.database.AppDatabase;
import com.bornfight.demo.weather.repository.grpc.GrpcDao;
import com.bornfight.demo.weather.repository.grpc.GrpcDao_Impl;
import com.bornfight.demo.weather.repository.searchsuggestion.SearchSuggestionDao;
import com.bornfight.demo.weather.repository.searchsuggestion.SearchSuggestionDao_Impl;
import com.bornfight.demo.weather.repository.weather.WeatherDao;
import com.bornfight.demo.weather.repository.weather.WeatherDao_Impl;
import java.util.HashMap;
import java.util.HashSet;

public final class AppDatabase_Impl
extends AppDatabase {
    private volatile SearchSuggestionDao _searchSuggestionDao;
    private volatile WeatherDao _weatherDao;
    private volatile GrpcDao _grpcDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `SearchSuggestion` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `suggestion` TEXT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `WeatherResponse` (`id` INTEGER NOT NULL, `weather` TEXT NOT NULL, `name` TEXT NOT NULL, `date` INTEGER NOT NULL, `temp` REAL NOT NULL, `minTemp` REAL NOT NULL, `maxTemp` REAL NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Forecast` (`weather` TEXT NOT NULL, `date` TEXT NOT NULL, `name` TEXT NOT NULL, `temp` REAL NOT NULL, `minTemp` REAL NOT NULL, `maxTemp` REAL NOT NULL, PRIMARY KEY(`date`, `name`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `HelloResponse` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `message` TEXT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '646c3b85a644238fa163f39192ab808b')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `SearchSuggestion`");
                _db.execSQL("DROP TABLE IF EXISTS `WeatherResponse`");
                _db.execSQL("DROP TABLE IF EXISTS `Forecast`");
                _db.execSQL("DROP TABLE IF EXISTS `HelloResponse`");
                if (AppDatabase_Impl.this.mCallbacks != null) {
                    int _size = AppDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (AppDatabase_Impl.this.mCallbacks != null) {
                    int _size = AppDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                AppDatabase_Impl.this.mDatabase = _db;
                AppDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (AppDatabase_Impl.this.mCallbacks != null) {
                    int _size = AppDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsSearchSuggestion = new HashMap<String, TableInfo.Column>(2);
                _columnsSearchSuggestion.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsSearchSuggestion.put("suggestion", new TableInfo.Column("suggestion", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysSearchSuggestion = new HashSet(0);
                HashSet _indicesSearchSuggestion = new HashSet(0);
                TableInfo _infoSearchSuggestion = new TableInfo("SearchSuggestion", _columnsSearchSuggestion, _foreignKeysSearchSuggestion, _indicesSearchSuggestion);
                TableInfo _existingSearchSuggestion = TableInfo.read((SupportSQLiteDatabase)_db, (String)"SearchSuggestion");
                if (!_infoSearchSuggestion.equals((Object)_existingSearchSuggestion)) {
                    return new RoomOpenHelper.ValidationResult(false, "SearchSuggestion(com.bornfight.demo.weather.model.SearchSuggestion).\n Expected:\n" + _infoSearchSuggestion + "\n Found:\n" + _existingSearchSuggestion);
                }
                HashMap<String, TableInfo.Column> _columnsWeatherResponse = new HashMap<String, TableInfo.Column>(7);
                _columnsWeatherResponse.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsWeatherResponse.put("weather", new TableInfo.Column("weather", "TEXT", true, 0, null, 1));
                _columnsWeatherResponse.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsWeatherResponse.put("date", new TableInfo.Column("date", "INTEGER", true, 0, null, 1));
                _columnsWeatherResponse.put("temp", new TableInfo.Column("temp", "REAL", true, 0, null, 1));
                _columnsWeatherResponse.put("minTemp", new TableInfo.Column("minTemp", "REAL", true, 0, null, 1));
                _columnsWeatherResponse.put("maxTemp", new TableInfo.Column("maxTemp", "REAL", true, 0, null, 1));
                HashSet _foreignKeysWeatherResponse = new HashSet(0);
                HashSet _indicesWeatherResponse = new HashSet(0);
                TableInfo _infoWeatherResponse = new TableInfo("WeatherResponse", _columnsWeatherResponse, _foreignKeysWeatherResponse, _indicesWeatherResponse);
                TableInfo _existingWeatherResponse = TableInfo.read((SupportSQLiteDatabase)_db, (String)"WeatherResponse");
                if (!_infoWeatherResponse.equals((Object)_existingWeatherResponse)) {
                    return new RoomOpenHelper.ValidationResult(false, "WeatherResponse(com.bornfight.demo.weather.model.WeatherResponse).\n Expected:\n" + _infoWeatherResponse + "\n Found:\n" + _existingWeatherResponse);
                }
                HashMap<String, TableInfo.Column> _columnsForecast = new HashMap<String, TableInfo.Column>(6);
                _columnsForecast.put("weather", new TableInfo.Column("weather", "TEXT", true, 0, null, 1));
                _columnsForecast.put("date", new TableInfo.Column("date", "TEXT", true, 1, null, 1));
                _columnsForecast.put("name", new TableInfo.Column("name", "TEXT", true, 2, null, 1));
                _columnsForecast.put("temp", new TableInfo.Column("temp", "REAL", true, 0, null, 1));
                _columnsForecast.put("minTemp", new TableInfo.Column("minTemp", "REAL", true, 0, null, 1));
                _columnsForecast.put("maxTemp", new TableInfo.Column("maxTemp", "REAL", true, 0, null, 1));
                HashSet _foreignKeysForecast = new HashSet(0);
                HashSet _indicesForecast = new HashSet(0);
                TableInfo _infoForecast = new TableInfo("Forecast", _columnsForecast, _foreignKeysForecast, _indicesForecast);
                TableInfo _existingForecast = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Forecast");
                if (!_infoForecast.equals((Object)_existingForecast)) {
                    return new RoomOpenHelper.ValidationResult(false, "Forecast(com.bornfight.demo.weather.model.Forecast).\n Expected:\n" + _infoForecast + "\n Found:\n" + _existingForecast);
                }
                HashMap<String, TableInfo.Column> _columnsHelloResponse = new HashMap<String, TableInfo.Column>(2);
                _columnsHelloResponse.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsHelloResponse.put("message", new TableInfo.Column("message", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysHelloResponse = new HashSet(0);
                HashSet _indicesHelloResponse = new HashSet(0);
                TableInfo _infoHelloResponse = new TableInfo("HelloResponse", _columnsHelloResponse, _foreignKeysHelloResponse, _indicesHelloResponse);
                TableInfo _existingHelloResponse = TableInfo.read((SupportSQLiteDatabase)_db, (String)"HelloResponse");
                if (!_infoHelloResponse.equals((Object)_existingHelloResponse)) {
                    return new RoomOpenHelper.ValidationResult(false, "HelloResponse(com.bornfight.demo.weather.model.grpc.HelloResponse).\n Expected:\n" + _infoHelloResponse + "\n Found:\n" + _existingHelloResponse);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "646c3b85a644238fa163f39192ab808b", "122bc59ba59b8a8ad2da118b2f810f4c");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"SearchSuggestion", "WeatherResponse", "Forecast", "HelloResponse"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `SearchSuggestion`");
            _db.execSQL("DELETE FROM `WeatherResponse`");
            _db.execSQL("DELETE FROM `Forecast`");
            _db.execSQL("DELETE FROM `HelloResponse`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchSuggestionDao searchSuggestionDao() {
        if (this._searchSuggestionDao != null) {
            return this._searchSuggestionDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (this._searchSuggestionDao == null) {
                this._searchSuggestionDao = new SearchSuggestionDao_Impl(this);
            }
            return this._searchSuggestionDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WeatherDao weatherDao() {
        if (this._weatherDao != null) {
            return this._weatherDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (this._weatherDao == null) {
                this._weatherDao = new WeatherDao_Impl(this);
            }
            return this._weatherDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GrpcDao grpcDao() {
        if (this._grpcDao != null) {
            return this._grpcDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (this._grpcDao == null) {
                this._grpcDao = new GrpcDao_Impl(this);
            }
            return this._grpcDao;
        }
    }
}

