/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ListValue;
import com.google.protobuf.MessageLite;
import com.google.protobuf.NullValue;
import com.google.protobuf.Parser;
import com.google.protobuf.Struct;
import com.google.protobuf.ValueOrBuilder;
import java.io.IOException;
import java.io.InputStream;

public final class Value
extends GeneratedMessageLite<Value, Builder>
implements ValueOrBuilder {
    private int kindCase_ = 0;
    private Object kind_;
    public static final int NULL_VALUE_FIELD_NUMBER = 1;
    public static final int NUMBER_VALUE_FIELD_NUMBER = 2;
    public static final int STRING_VALUE_FIELD_NUMBER = 3;
    public static final int BOOL_VALUE_FIELD_NUMBER = 4;
    public static final int STRUCT_VALUE_FIELD_NUMBER = 5;
    public static final int LIST_VALUE_FIELD_NUMBER = 6;
    private static final Value DEFAULT_INSTANCE = new Value();
    private static volatile Parser<Value> PARSER;

    private Value() {
    }

    @Override
    public KindCase getKindCase() {
        return KindCase.forNumber(this.kindCase_);
    }

    private void clearKind() {
        this.kindCase_ = 0;
        this.kind_ = null;
    }

    @Override
    public int getNullValueValue() {
        if (this.kindCase_ == 1) {
            return (Integer)this.kind_;
        }
        return 0;
    }

    @Override
    public NullValue getNullValue() {
        if (this.kindCase_ == 1) {
            NullValue result = NullValue.forNumber((Integer)this.kind_);
            return result == null ? NullValue.UNRECOGNIZED : result;
        }
        return NullValue.NULL_VALUE;
    }

    private void setNullValueValue(int value) {
        this.kindCase_ = 1;
        this.kind_ = value;
    }

    private void setNullValue(NullValue value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.kindCase_ = 1;
        this.kind_ = value.getNumber();
    }

    private void clearNullValue() {
        if (this.kindCase_ == 1) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    @Override
    public double getNumberValue() {
        if (this.kindCase_ == 2) {
            return (Double)this.kind_;
        }
        return 0.0;
    }

    private void setNumberValue(double value) {
        this.kindCase_ = 2;
        this.kind_ = value;
    }

    private void clearNumberValue() {
        if (this.kindCase_ == 2) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    @Override
    public String getStringValue() {
        String ref = "";
        if (this.kindCase_ == 3) {
            ref = (String)this.kind_;
        }
        return ref;
    }

    @Override
    public ByteString getStringValueBytes() {
        String ref = "";
        if (this.kindCase_ == 3) {
            ref = (String)this.kind_;
        }
        return ByteString.copyFromUtf8((String)ref);
    }

    private void setStringValue(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.kindCase_ = 3;
        this.kind_ = value;
    }

    private void clearStringValue() {
        if (this.kindCase_ == 3) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    private void setStringValueBytes(ByteString value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Value.checkByteStringIsUtf8((ByteString)value);
        this.kindCase_ = 3;
        this.kind_ = value.toStringUtf8();
    }

    @Override
    public boolean getBoolValue() {
        if (this.kindCase_ == 4) {
            return (Boolean)this.kind_;
        }
        return false;
    }

    private void setBoolValue(boolean value) {
        this.kindCase_ = 4;
        this.kind_ = value;
    }

    private void clearBoolValue() {
        if (this.kindCase_ == 4) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    @Override
    public Struct getStructValue() {
        if (this.kindCase_ == 5) {
            return (Struct)this.kind_;
        }
        return Struct.getDefaultInstance();
    }

    private void setStructValue(Struct value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.kind_ = value;
        this.kindCase_ = 5;
    }

    private void setStructValue(Struct.Builder builderForValue) {
        this.kind_ = builderForValue.build();
        this.kindCase_ = 5;
    }

    private void mergeStructValue(Struct value) {
        this.kind_ = this.kindCase_ == 5 && this.kind_ != Struct.getDefaultInstance() ? ((Struct.Builder)Struct.newBuilder((Struct)this.kind_).mergeFrom(value)).buildPartial() : value;
        this.kindCase_ = 5;
    }

    private void clearStructValue() {
        if (this.kindCase_ == 5) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    @Override
    public ListValue getListValue() {
        if (this.kindCase_ == 6) {
            return (ListValue)this.kind_;
        }
        return ListValue.getDefaultInstance();
    }

    private void setListValue(ListValue value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.kind_ = value;
        this.kindCase_ = 6;
    }

    private void setListValue(ListValue.Builder builderForValue) {
        this.kind_ = builderForValue.build();
        this.kindCase_ = 6;
    }

    private void mergeListValue(ListValue value) {
        this.kind_ = this.kindCase_ == 6 && this.kind_ != ListValue.getDefaultInstance() ? ((ListValue.Builder)ListValue.newBuilder((ListValue)this.kind_).mergeFrom(value)).buildPartial() : value;
        this.kindCase_ = 6;
    }

    private void clearListValue() {
        if (this.kindCase_ == 6) {
            this.kindCase_ = 0;
            this.kind_ = null;
        }
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.kindCase_ == 1) {
            output.writeEnum(1, ((Integer)this.kind_).intValue());
        }
        if (this.kindCase_ == 2) {
            output.writeDouble(2, ((Double)this.kind_).doubleValue());
        }
        if (this.kindCase_ == 3) {
            output.writeString(3, this.getStringValue());
        }
        if (this.kindCase_ == 4) {
            output.writeBool(4, ((Boolean)this.kind_).booleanValue());
        }
        if (this.kindCase_ == 5) {
            output.writeMessage(5, (MessageLite)((Struct)this.kind_));
        }
        if (this.kindCase_ == 6) {
            output.writeMessage(6, (MessageLite)((ListValue)this.kind_));
        }
    }

    public int getSerializedSize() {
        int size = this.memoizedSerializedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.kindCase_ == 1) {
            size += CodedOutputStream.computeEnumSize((int)1, (int)((Integer)this.kind_));
        }
        if (this.kindCase_ == 2) {
            size += CodedOutputStream.computeDoubleSize((int)2, (double)((Double)this.kind_));
        }
        if (this.kindCase_ == 3) {
            size += CodedOutputStream.computeStringSize((int)3, (String)this.getStringValue());
        }
        if (this.kindCase_ == 4) {
            size += CodedOutputStream.computeBoolSize((int)4, (boolean)((Boolean)this.kind_));
        }
        if (this.kindCase_ == 5) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((Struct)this.kind_));
        }
        if (this.kindCase_ == 6) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((ListValue)this.kind_));
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    public static Value parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data);
    }

    public static Value parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (ByteString)data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Value parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data);
    }

    public static Value parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (byte[])data, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Value parseFrom(InputStream input) throws IOException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static Value parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Value parseDelimitedFrom(InputStream input) throws IOException {
        return (Value)Value.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input);
    }

    public static Value parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Value)Value.parseDelimitedFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Value parseFrom(CodedInputStream input) throws IOException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input);
    }

    public static Value parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Value)GeneratedMessageLite.parseFrom((GeneratedMessageLite)DEFAULT_INSTANCE, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Builder newBuilder() {
        return (Builder)DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Value prototype) {
        return (Builder)((Builder)DEFAULT_INSTANCE.toBuilder()).mergeFrom(prototype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Object dynamicMethod(GeneratedMessageLite.MethodToInvoke method, Object arg0, Object arg1) {
        switch (method) {
            case NEW_MUTABLE_INSTANCE: {
                return new Value();
            }
            case IS_INITIALIZED: {
                return DEFAULT_INSTANCE;
            }
            case MAKE_IMMUTABLE: {
                return null;
            }
            case NEW_BUILDER: {
                return new Builder();
            }
            case VISIT: {
                GeneratedMessageLite.Visitor visitor = (GeneratedMessageLite.Visitor)arg0;
                Value other = (Value)arg1;
                switch (other.getKindCase()) {
                    case NULL_VALUE: {
                        this.kind_ = visitor.visitOneofInt(this.kindCase_ == 1, this.kind_, other.kind_);
                        break;
                    }
                    case NUMBER_VALUE: {
                        this.kind_ = visitor.visitOneofDouble(this.kindCase_ == 2, this.kind_, other.kind_);
                        break;
                    }
                    case STRING_VALUE: {
                        this.kind_ = visitor.visitOneofString(this.kindCase_ == 3, this.kind_, other.kind_);
                        break;
                    }
                    case BOOL_VALUE: {
                        this.kind_ = visitor.visitOneofBoolean(this.kindCase_ == 4, this.kind_, other.kind_);
                        break;
                    }
                    case STRUCT_VALUE: {
                        this.kind_ = visitor.visitOneofMessage(this.kindCase_ == 5, this.kind_, other.kind_);
                        break;
                    }
                    case LIST_VALUE: {
                        this.kind_ = visitor.visitOneofMessage(this.kindCase_ == 6, this.kind_, other.kind_);
                        break;
                    }
                    case KIND_NOT_SET: {
                        visitor.visitOneofNotSet(this.kindCase_ != 0);
                    }
                }
                if (visitor != GeneratedMessageLite.MergeFromVisitor.INSTANCE || other.kindCase_ == 0) return this;
                this.kindCase_ = other.kindCase_;
                return this;
            }
            case MERGE_FROM_STREAM: {
                CodedInputStream input = (CodedInputStream)arg0;
                ExtensionRegistryLite extensionRegistry = (ExtensionRegistryLite)arg1;
                try {
                    boolean done = false;
                    block36: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block36;
                            }
                            default: {
                                if (input.skipField(tag)) continue block36;
                                done = true;
                                continue block36;
                            }
                            case 8: {
                                int rawValue = input.readEnum();
                                this.kindCase_ = 1;
                                this.kind_ = rawValue;
                                continue block36;
                            }
                            case 17: {
                                this.kindCase_ = 2;
                                this.kind_ = input.readDouble();
                                continue block36;
                            }
                            case 26: {
                                String s = input.readStringRequireUtf8();
                                this.kindCase_ = 3;
                                this.kind_ = s;
                                continue block36;
                            }
                            case 32: {
                                this.kindCase_ = 4;
                                this.kind_ = input.readBool();
                                continue block36;
                            }
                            case 42: {
                                Struct.Builder subBuilder = null;
                                if (this.kindCase_ == 5) {
                                    subBuilder = (Struct.Builder)((Struct)this.kind_).toBuilder();
                                }
                                this.kind_ = input.readMessage(Struct.parser(), extensionRegistry);
                                if (subBuilder != null) {
                                    subBuilder.mergeFrom((Struct)this.kind_);
                                    this.kind_ = subBuilder.buildPartial();
                                }
                                this.kindCase_ = 5;
                                continue block36;
                            }
                            case 50: 
                        }
                        ListValue.Builder subBuilder = null;
                        if (this.kindCase_ == 6) {
                            subBuilder = (ListValue.Builder)((ListValue)this.kind_).toBuilder();
                        }
                        this.kind_ = input.readMessage(ListValue.parser(), extensionRegistry);
                        if (subBuilder != null) {
                            subBuilder.mergeFrom((ListValue)this.kind_);
                            this.kind_ = subBuilder.buildPartial();
                        }
                        this.kindCase_ = 6;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e.setUnfinishedMessage((MessageLite)this));
                }
                catch (IOException e) {
                    throw new RuntimeException(new InvalidProtocolBufferException(e.getMessage()).setUnfinishedMessage((MessageLite)this));
                }
            }
            case GET_DEFAULT_INSTANCE: {
                return DEFAULT_INSTANCE;
            }
            case GET_PARSER: {
                if (PARSER != null) return PARSER;
                Class<Value> clazz = Value.class;
                synchronized (Value.class) {
                    if (PARSER != null) return PARSER;
                    PARSER = new GeneratedMessageLite.DefaultInstanceBasedParser((GeneratedMessageLite)DEFAULT_INSTANCE);
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    return PARSER;
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Value getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Value> parser() {
        return DEFAULT_INSTANCE.getParserForType();
    }

    static {
        DEFAULT_INSTANCE.makeImmutable();
    }

    public static final class Builder
    extends GeneratedMessageLite.Builder<Value, Builder>
    implements ValueOrBuilder {
        private Builder() {
            super((GeneratedMessageLite)DEFAULT_INSTANCE);
        }

        @Override
        public KindCase getKindCase() {
            return ((Value)this.instance).getKindCase();
        }

        public Builder clearKind() {
            this.copyOnWrite();
            ((Value)this.instance).clearKind();
            return this;
        }

        @Override
        public int getNullValueValue() {
            return ((Value)this.instance).getNullValueValue();
        }

        public Builder setNullValueValue(int value) {
            this.copyOnWrite();
            ((Value)this.instance).setNullValueValue(value);
            return this;
        }

        @Override
        public NullValue getNullValue() {
            return ((Value)this.instance).getNullValue();
        }

        public Builder setNullValue(NullValue value) {
            this.copyOnWrite();
            ((Value)this.instance).setNullValue(value);
            return this;
        }

        public Builder clearNullValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearNullValue();
            return this;
        }

        @Override
        public double getNumberValue() {
            return ((Value)this.instance).getNumberValue();
        }

        public Builder setNumberValue(double value) {
            this.copyOnWrite();
            ((Value)this.instance).setNumberValue(value);
            return this;
        }

        public Builder clearNumberValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearNumberValue();
            return this;
        }

        @Override
        public String getStringValue() {
            return ((Value)this.instance).getStringValue();
        }

        @Override
        public ByteString getStringValueBytes() {
            return ((Value)this.instance).getStringValueBytes();
        }

        public Builder setStringValue(String value) {
            this.copyOnWrite();
            ((Value)this.instance).setStringValue(value);
            return this;
        }

        public Builder clearStringValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearStringValue();
            return this;
        }

        public Builder setStringValueBytes(ByteString value) {
            this.copyOnWrite();
            ((Value)this.instance).setStringValueBytes(value);
            return this;
        }

        @Override
        public boolean getBoolValue() {
            return ((Value)this.instance).getBoolValue();
        }

        public Builder setBoolValue(boolean value) {
            this.copyOnWrite();
            ((Value)this.instance).setBoolValue(value);
            return this;
        }

        public Builder clearBoolValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearBoolValue();
            return this;
        }

        @Override
        public Struct getStructValue() {
            return ((Value)this.instance).getStructValue();
        }

        public Builder setStructValue(Struct value) {
            this.copyOnWrite();
            ((Value)this.instance).setStructValue(value);
            return this;
        }

        public Builder setStructValue(Struct.Builder builderForValue) {
            this.copyOnWrite();
            ((Value)this.instance).setStructValue(builderForValue);
            return this;
        }

        public Builder mergeStructValue(Struct value) {
            this.copyOnWrite();
            ((Value)this.instance).mergeStructValue(value);
            return this;
        }

        public Builder clearStructValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearStructValue();
            return this;
        }

        @Override
        public ListValue getListValue() {
            return ((Value)this.instance).getListValue();
        }

        public Builder setListValue(ListValue value) {
            this.copyOnWrite();
            ((Value)this.instance).setListValue(value);
            return this;
        }

        public Builder setListValue(ListValue.Builder builderForValue) {
            this.copyOnWrite();
            ((Value)this.instance).setListValue(builderForValue);
            return this;
        }

        public Builder mergeListValue(ListValue value) {
            this.copyOnWrite();
            ((Value)this.instance).mergeListValue(value);
            return this;
        }

        public Builder clearListValue() {
            this.copyOnWrite();
            ((Value)this.instance).clearListValue();
            return this;
        }
    }

    public static enum KindCase implements Internal.EnumLite
    {
        NULL_VALUE(1),
        NUMBER_VALUE(2),
        STRING_VALUE(3),
        BOOL_VALUE(4),
        STRUCT_VALUE(5),
        LIST_VALUE(6),
        KIND_NOT_SET(0);

        private final int value;

        private KindCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static KindCase valueOf(int value) {
            return KindCase.forNumber(value);
        }

        public static KindCase forNumber(int value) {
            switch (value) {
                case 1: {
                    return NULL_VALUE;
                }
                case 2: {
                    return NUMBER_VALUE;
                }
                case 3: {
                    return STRING_VALUE;
                }
                case 4: {
                    return BOOL_VALUE;
                }
                case 5: {
                    return STRUCT_VALUE;
                }
                case 6: {
                    return LIST_VALUE;
                }
                case 0: {
                    return KIND_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }
}

