/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.data.retrofit;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;
import retrofit2.Retrofit;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00060\u0001j\u0002`\u0002:\u0002\u0017\u0018BC\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lio/streamlayer/common/data/retrofit/RetrofitException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "url", "response", "Lretrofit2/Response;", "kind", "Lio/streamlayer/common/data/retrofit/RetrofitException$Kind;", "exception", "", "retrofit", "Lretrofit2/Retrofit;", "(Ljava/lang/String;Ljava/lang/String;Lretrofit2/Response;Lio/streamlayer/common/data/retrofit/RetrofitException$Kind;Ljava/lang/Throwable;Lretrofit2/Retrofit;)V", "getResponse", "()Lretrofit2/Response;", "getRetrofit", "()Lretrofit2/Retrofit;", "getUrl", "()Ljava/lang/String;", "processNetworkError", "", "Companion", "Kind", "sdk_release"})
public final class RetrofitException
extends RuntimeException {
    @Nullable
    private final String url;
    @Nullable
    private final Response<?> response;
    private final Kind kind;
    @Nullable
    private final Retrofit retrofit;
    public static final Companion Companion = new Companion(null);

    public final boolean processNetworkError() {
        return this.kind == Kind.NETWORK;
    }

    @Nullable
    public final String getUrl() {
        return this.url;
    }

    @Nullable
    public final Response<?> getResponse() {
        return this.response;
    }

    @Nullable
    public final Retrofit getRetrofit() {
        return this.retrofit;
    }

    public RetrofitException(@NotNull String message, @Nullable String url, @Nullable Response<?> response, @NotNull Kind kind, @Nullable Throwable exception, @Nullable Retrofit retrofit) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
        super(message, exception);
        this.url = url;
        this.response = response;
        this.kind = kind;
        this.retrofit = retrofit;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/common/data/retrofit/RetrofitException$Kind;", "", "(Ljava/lang/String;I)V", "NETWORK", "HTTP", "UNEXPECTED", "sdk_release"})
    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind NETWORK;
        public static final /* enum */ Kind HTTP;
        public static final /* enum */ Kind UNEXPECTED;
        private static final /* synthetic */ Kind[] $VALUES;

        static {
            Kind[] kindArray = new Kind[3];
            Kind[] kindArray2 = kindArray;
            kindArray[0] = NETWORK = new Kind();
            kindArray[1] = HTTP = new Kind();
            kindArray[2] = UNEXPECTED = new Kind();
            $VALUES = kindArray;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String string) {
            return Enum.valueOf(Kind.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lio/streamlayer/common/data/retrofit/RetrofitException$Companion;", "", "()V", "httpError", "Lio/streamlayer/common/data/retrofit/RetrofitException;", "url", "", "response", "Lretrofit2/Response;", "retrofit", "Lretrofit2/Retrofit;", "networkError", "exception", "Ljava/io/IOException;", "unexpectedError", "", "sdk_release"})
    public static final class Companion {
        @NotNull
        public final RetrofitException httpError(@NotNull String url, @Nullable Response<?> response, @NotNull Retrofit retrofit) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)retrofit, (String)"retrofit");
            Response<?> response2 = response;
            Response<?> response3 = response;
            String message = "Code: " + String.valueOf(response2 != null ? Integer.valueOf(response2.code()) : null) + " " + (response3 != null ? response3.message() : null);
            return new RetrofitException(message, url, response, Kind.HTTP, null, retrofit);
        }

        @NotNull
        public final RetrofitException networkError(@NotNull IOException exception) {
            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            return new RetrofitException(string, null, null, Kind.NETWORK, exception, null);
        }

        @NotNull
        public final RetrofitException unexpectedError(@NotNull Throwable exception) {
            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            return new RetrofitException(string, null, null, Kind.UNEXPECTED, exception, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

