/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.mvvm;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.greysonparrelli.permiso.Permiso;
import io.streamlayer.common.dagger.components.ActivityComponent;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.mvvm.BaseView;
import io.streamlayer.common.session.DevicePreferences;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.R;
import io.streamlayer.utils.DialogUtil;
import java.util.HashMap;
import java.util.Locale;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0015\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001f\u0010\u001c\u001a\u00020\u00172\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u001e\"\u00020\u0019\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\"\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010)H\u0014J\u0012\u0010*\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u00010,H\u0014J\b\u0010-\u001a\u00020!H\u0016J+\u0010.\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e2\u0006\u0010/\u001a\u000200H\u0016\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020!H\u0014J\u0012\u00103\u001a\u00020!2\b\b\u0001\u00104\u001a\u00020&H\u0016J\b\u00105\u001a\u00020!H\u0002J\u0010\u00106\u001a\u00020!2\u0006\u00107\u001a\u00020&H\u0016J\u0010\u00106\u001a\u00020!2\u0006\u00108\u001a\u00020\u0019H\u0016J&\u00109\u001a\u00020!2\b\b\u0001\u0010:\u001a\u00020&2\b\b\u0001\u0010;\u001a\u00020&2\b\b\u0001\u0010<\u001a\u00020&H\u0016J&\u00109\u001a\u00020!2\b\u0010=\u001a\u0004\u0018\u00010\u00192\b\u0010>\u001a\u0004\u0018\u00010\u00192\b\u0010<\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u00020\u0017H\u0016J\u0018\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u00020\u00172\u0006\u0010A\u001a\u00020\u0017H\u0016J\u0010\u0010B\u001a\u00020!2\u0006\u0010@\u001a\u00020\u0017H\u0016J\u0010\u0010C\u001a\u00020!2\u0006\u00107\u001a\u00020&H\u0016J\u0010\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020\u0019H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0004@\u0004X\u0085.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lio/streamlayer/common/mvvm/BaseActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lio/streamlayer/common/mvvm/BaseView;", "()V", "devicePrefs", "Lio/streamlayer/common/session/DevicePreferences;", "getDevicePrefs", "()Lio/streamlayer/common/session/DevicePreferences;", "setDevicePrefs", "(Lio/streamlayer/common/session/DevicePreferences;)V", "pd", "Landroid/app/Dialog;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "getSession", "()Lio/streamlayer/common/session/SessionPrefImpl;", "setSession", "(Lio/streamlayer/common/session/SessionPrefImpl;)V", "toolbar", "Landroidx/appcompat/widget/Toolbar;", "toolbarProgressCircle", "Landroid/widget/ProgressBar;", "checkPermissionDenied", "", "permission", "", "checkPermissionDeniedForGood", "checkPermissionGranted", "checkPermissionsGranted", "permissions", "", "([Ljava/lang/String;)Z", "hideKeyboard", "", "view", "Landroid/view/View;", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onLogout", "onRequestPermissionsResult", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "setContentView", "layoutResID", "setLanguage", "showError", "stringResourceId", "errorMessage", "showInfoDialog", "titleResourceId", "descriptionResourceId", "buttonText", "title", "description", "showLoader", "show", "cancelable", "showProgressCircle", "showShortInfo", "info", "sdk_release"})
public abstract class BaseActivity
extends AppCompatActivity
implements BaseView {
    @Inject
    @NotNull
    public SessionPrefImpl session;
    @Inject
    @NotNull
    protected DevicePreferences devicePrefs;
    private Dialog pd;
    private Toolbar toolbar;
    private ProgressBar toolbarProgressCircle;
    private HashMap _$_findViewCache;

    @NotNull
    public final SessionPrefImpl getSession() {
        SessionPrefImpl sessionPrefImpl = this.session;
        if (sessionPrefImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        return sessionPrefImpl;
    }

    public final void setSession(@NotNull SessionPrefImpl sessionPrefImpl) {
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"<set-?>");
        this.session = sessionPrefImpl;
    }

    @NotNull
    protected final DevicePreferences getDevicePrefs() {
        DevicePreferences devicePreferences = this.devicePrefs;
        if (devicePreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"devicePrefs");
        }
        return devicePreferences;
    }

    protected final void setDevicePrefs(@NotNull DevicePreferences devicePreferences) {
        Intrinsics.checkParameterIsNotNull((Object)devicePreferences, (String)"<set-?>");
        this.devicePrefs = devicePreferences;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        ActivityComponent.Companion.inject$sdk_release(this);
        super.onCreate(savedInstanceState);
        Permiso.getInstance().setActivity((Activity)this);
        this.pd = DialogUtil.INSTANCE.buildLoaderDialog((Activity)this, this.getString(R.string.please_wait));
    }

    protected void onResume() {
        super.onResume();
        Permiso.getInstance().setActivity((Activity)this);
    }

    public final boolean checkPermissionGranted(@NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)((Context)this), (String)permission) == 0;
    }

    public final boolean checkPermissionsGranted(String ... permissions) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        for (String permission : permissions) {
            if (this.checkPermissionGranted(permission)) continue;
            return false;
        }
        return true;
    }

    public final boolean checkPermissionDenied(@NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)((Context)this), (String)permission) == -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean checkPermissionDeniedForGood(@NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (ContextCompat.checkSelfPermission((Context)((Context)this), (String)permission) != -1) return false;
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)this), (String)permission)) return false;
        SessionPrefImpl sessionPrefImpl = this.session;
        if (sessionPrefImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        if (!sessionPrefImpl.checkPermissionAsked(permission)) return false;
        return true;
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        Permiso.getInstance().setActivity((Activity)this);
        for (String permission : permissions) {
            SessionPrefImpl sessionPrefImpl = this.session;
            if (sessionPrefImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            }
            sessionPrefImpl.setPermissionAsked(permission);
        }
    }

    public void setContentView(@LayoutRes int layoutResID) {
        super.setContentView(layoutResID);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.toolbarProgressCircle = (ProgressBar)this.findViewById(R.id.toolbarProgressCircle);
    }

    @Override
    public void showError(@NotNull String errorMessage) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        this.showShortInfo(errorMessage);
    }

    @Override
    public void showError(int stringResourceId) {
        String string2 = this.getString(stringResourceId);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(stringResourceId)");
        this.showError(string2);
    }

    @Override
    public void showShortInfo(@NotNull String info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Toast.makeText((Context)((Context)this), (CharSequence)info, (int)0).show();
    }

    @Override
    public void showShortInfo(int stringResourceId) {
        String string2 = this.getString(stringResourceId);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(stringResourceId)");
        this.showShortInfo(string2);
    }

    @Override
    public void showProgressCircle(boolean show) {
        ProgressBar progressBar = this.toolbarProgressCircle;
        if (progressBar != null) {
            ExtensionsKt.visibleIf((View)progressBar, show);
        } else {
            this.showLoader(show);
        }
    }

    @Override
    public void showLoader(boolean show) {
        if (show) {
            Dialog dialog = this.pd;
            if (dialog == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pd");
            }
            dialog.show();
        } else {
            Dialog dialog = this.pd;
            if (dialog == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pd");
            }
            dialog.dismiss();
        }
        if (!show) {
            Dialog dialog = this.pd;
            if (dialog == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pd");
            }
            dialog.setCancelable(true);
        }
    }

    @Override
    public void showLoader(boolean show, boolean cancelable) {
        Dialog dialog = this.pd;
        if (dialog == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pd");
        }
        dialog.setCancelable(cancelable);
        this.showLoader(show);
    }

    @Override
    public void hideKeyboard(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Object object = this.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        ((InputMethodManager)object).hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    @Override
    public void showInfoDialog(@Nullable String title, @Nullable String description, @Nullable String buttonText) {
        DialogUtil.buildInfoDialog$default(DialogUtil.INSTANCE, (Activity)this, title, description, buttonText, null, 16, null).show();
    }

    @Override
    public void showInfoDialog(@StringRes int titleResourceId, @StringRes int descriptionResourceId, @StringRes int buttonText) {
        this.showInfoDialog(titleResourceId != 0 ? this.getString(titleResourceId) : null, descriptionResourceId != 0 ? this.getString(descriptionResourceId) : null, buttonText != 0 ? this.getString(buttonText) : null);
    }

    private final void setLanguage() {
        Locale locale = new Locale("hr", "HR");
        Locale.setDefault(locale);
        Configuration config = new Configuration();
        config.locale = locale;
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        context.getResources().updateConfiguration(config, null);
    }

    @Override
    public void onLogout() {
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Permiso.getInstance().setActivity((Activity)this);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

