/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import androidx.appcompat.app.AppCompatActivity;
import io.streamlayer.sdk.StreamLayer;
import io.streamlayer.sdk.main.StreamLayerFragment;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/streamlayer/sdk/StreamLayerPushClient;", "", "()V", "DEEP_LINK_NAV_GRAPH_DATA", "", "buildDeepLinkIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "destinationUri", "Landroid/net/Uri;", "buildDeepLinkIntent$sdk_originalRelease", "findHostFragment", "Lio/streamlayer/sdk/main/StreamLayerFragment;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "getDeepLinkUri", "intent", "handleDeepLinkIntent", "", "handleStreamLayerPush", "data", "", "uploadDeviceFCMToken", "", "token", "sdk_originalRelease"})
public final class StreamLayerPushClient {
    @NotNull
    public static final String DEEP_LINK_NAV_GRAPH_DATA = "deep_link_graph_data";
    public static final StreamLayerPushClient INSTANCE = new StreamLayerPushClient();

    private final StreamLayerFragment findHostFragment(AppCompatActivity appCompatActivity) {
        return (StreamLayerFragment)appCompatActivity.getSupportFragmentManager().findFragmentByTag("StreamLayerFragment");
    }

    private final Uri getDeepLinkUri(Intent intent) {
        return (Uri)intent.getParcelableExtra(DEEP_LINK_NAV_GRAPH_DATA);
    }

    private StreamLayerPushClient() {
    }

    public final void uploadDeviceFCMToken(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"token");
        StreamLayer.INSTANCE.uploadDeviceFCMToken$sdk_originalRelease(string2);
    }

    public final boolean handleStreamLayerPush(@NotNull Map<String, String> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"data");
        return StreamLayer.INSTANCE.handleStreamLayerPush$sdk_originalRelease(map2);
    }

    public final boolean handleDeepLinkIntent(@NotNull Intent intent, @NotNull AppCompatActivity object) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"activity");
        Uri uri = intent.getData();
        if (Intrinsics.areEqual((Object)(uri != null ? uri.getScheme() : null), (Object)"streamlayer")) {
            if ((object = this.findHostFragment((AppCompatActivity)object)) != null) {
                StreamLayerFragment.triggerDeepLink$default((StreamLayerFragment)((Object)object), this.getDeepLinkUri(intent), false, 2, null);
                return true;
            }
            throw new IllegalStateException("StreamLayerFragment not found! Please add android:tag=\"StreamLayerFragment\" to your FragmentContainerView");
        }
        return false;
    }

    @NotNull
    public final Intent buildDeepLinkIntent$sdk_originalRelease(@NotNull Context context, @Nullable Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("streamlayer://" + context.getPackageName())));
        intent.putExtra(DEEP_LINK_NAV_GRAPH_DATA, (Parcelable)uri);
        return intent;
    }
}

