/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.notifications;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.streamlayer.common.mvvm.BaseViewModel;
import io.streamlayer.common.mvvm.basemodels.ResourceState;
import io.streamlayer.common.mvvm.basemodels.Status;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.notifications.Notification;
import io.streamlayer.sdk.model.notifications.NotificationType;
import io.streamlayer.sdk.notifications.NotificationsViewModel;
import io.streamlayer.sdk.repository.notifications.NotificationRepo;
import io.streamlayer.utils.RingtonePlayer;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fJ\b\u0010\u0018\u001a\u00020\u0015H\u0002R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/streamlayer/sdk/notifications/NotificationsViewModel;", "Lio/streamlayer/common/mvvm/BaseViewModel;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "notifsRepo", "Lio/streamlayer/sdk/repository/notifications/NotificationRepo;", "ringtonePlayer", "Lio/streamlayer/utils/RingtonePlayer;", "schedulers", "Lio/streamlayer/common/scheduler/SchedulerProvider;", "(Lio/streamlayer/common/session/SessionPrefImpl;Lio/streamlayer/sdk/repository/notifications/NotificationRepo;Lio/streamlayer/utils/RingtonePlayer;Lio/streamlayer/common/scheduler/SchedulerProvider;)V", "_notificationsData", "Landroidx/lifecycle/MutableLiveData;", "Lio/streamlayer/common/mvvm/basemodels/ResourceState;", "", "Lio/streamlayer/sdk/model/notifications/Notification;", "notificationsData", "Landroidx/lifecycle/LiveData;", "getNotificationsData", "()Landroidx/lifecycle/LiveData;", "dismissAllNotifications", "", "dismissNotification", "notification", "getNotifications", "sdk_originalRelease"})
public final class NotificationsViewModel
extends BaseViewModel {
    private final MutableLiveData<ResourceState<List<Notification>>> _notificationsData;
    @NotNull
    private final LiveData<ResourceState<List<Notification>>> notificationsData;
    private final NotificationRepo notifsRepo;
    private final RingtonePlayer ringtonePlayer;

    private final void getNotifications() {
        NotificationsViewModel notificationsViewModel2 = this;
        BaseViewModel.observableCall$default(notificationsViewModel2, notificationsViewModel2._notificationsData, (Function0)new Function0<Observable<ResourceState<? extends List<? extends Notification>>>>(this){
            final /* synthetic */ NotificationsViewModel this$0;
            {
                this.this$0 = notificationsViewModel2;
                super(0);
            }

            public final Observable<ResourceState<List<Notification>>> invoke() {
                Observable observable = NotificationsViewModel.access$getNotifsRepo$p(this.this$0).getNotifications().doOnNext(new Consumer<ResourceState<? extends List<? extends Notification>>>(this){
                    final /* synthetic */ getNotifications.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void accept(ResourceState<? extends List<Notification>> iterator) {
                        if (((ResourceState)((Object)iterator)).getStatus() != Status.SUCCESS) return;
                        if ((iterator = (List)((ResourceState)((Object)iterator)).getData()) == null) {
                            iterator = CollectionsKt.emptyList();
                        }
                        if (iterator instanceof Collection && iterator.isEmpty()) {
                            return;
                        }
                        iterator = iterator.iterator();
                        do {
                            if (!iterator.hasNext()) return;
                        } while (!(((Notification)iterator.next()).getType() == NotificationType.Call));
                        boolean bl = true;
                        if (!bl) return;
                        NotificationsViewModel.access$getRingtonePlayer$p(this.this$0.this$0).ring();
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"notifsRepo.getNotificati\u2026      }\n                }");
                return observable;
            }
        }, null, null, null, 28, null);
    }

    @Inject
    public NotificationsViewModel(@NotNull SessionPrefImpl sessionPrefImpl, @NotNull NotificationRepo notificationRepo, @NotNull RingtonePlayer ringtonePlayer, @NotNull SchedulerProvider schedulerProvider) {
        NotificationsViewModel notificationsViewModel2 = this;
        SchedulerProvider schedulerProvider2 = schedulerProvider;
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)notificationRepo, (String)"notifsRepo");
        Intrinsics.checkParameterIsNotNull((Object)ringtonePlayer, (String)"ringtonePlayer");
        Intrinsics.checkParameterIsNotNull((Object)schedulerProvider2, (String)"schedulers");
        super(schedulerProvider2);
        this.notifsRepo = notificationRepo;
        notificationsViewModel2.ringtonePlayer = ringtonePlayer;
        notificationsViewModel2._notificationsData = new MutableLiveData();
        LiveData liveData = Transformations.distinctUntilChanged(notificationsViewModel2._notificationsData);
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"Transformations.distinctUntilChanged(this)");
        notificationsViewModel2.notificationsData = liveData;
        notificationsViewModel2.getNotifications();
    }

    public static final /* synthetic */ NotificationRepo access$getNotifsRepo$p(NotificationsViewModel notificationsViewModel2) {
        return notificationsViewModel2.notifsRepo;
    }

    public static final /* synthetic */ RingtonePlayer access$getRingtonePlayer$p(NotificationsViewModel notificationsViewModel2) {
        return notificationsViewModel2.ringtonePlayer;
    }

    @NotNull
    public final LiveData<ResourceState<List<Notification>>> getNotificationsData() {
        return this.notificationsData;
    }

    public final void dismissNotification(@NotNull Notification notification) {
        NotificationsViewModel notificationsViewModel2 = this;
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        BaseViewModel.completableCall$default(notificationsViewModel2, notificationsViewModel2._notificationsData, (Function0)new Function0<Completable>(this, notification){
            final /* synthetic */ NotificationsViewModel this$0;
            final /* synthetic */ Notification $notification;
            {
                this.this$0 = notificationsViewModel2;
                this.$notification = notification;
                super(0);
            }

            public final Completable invoke() {
                Completable completable = NotificationsViewModel.access$getNotifsRepo$p(this.this$0).deleteNotification(this.$notification).doOnComplete(new Action(this){
                    final /* synthetic */ dismissNotification.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        if (this.this$0.$notification.getType() == NotificationType.Call) {
                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                            function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                private CoroutineScope p$;
                                int label;
                                final /* synthetic */ dismissNotification.1 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(2, continuation);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    if (this.label == 0) {
                                        ResultKt.throwOnFailure((Object)object);
                                        NotificationsViewModel.access$getRingtonePlayer$p(this.this$0.this$0.this$0).dismiss();
                                        return Unit.INSTANCE;
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object object, @NotNull Continuation<?> continuation) {
                                    Intrinsics.checkParameterIsNotNull(continuation, (String)"completion");
                                    new /* invalid duplicate definition of identical inner class */.p$ = (CoroutineScope)object;
                                    return new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            };
                            BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this.this$0.this$0), (CoroutineContext)Dispatchers.getMain(), null, (Function2)function22, (int)2, null);
                        }
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"notifsRepo.deleteNotific\u2026          }\n            }");
                return completable;
            }
        }, null, null, null, 28, null);
    }

    public final void dismissAllNotifications() {
        this.notifsRepo.deleteAllNotifications();
    }
}

