/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.sdk.repository.messaging;

import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.room.Update;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.streamlayer.sdk.model.messaging.Chat;
import io.streamlayer.sdk.model.messaging.ChatKt;
import io.streamlayer.sdk.model.messaging.ChatMessage;
import io.streamlayer.sdk.model.messaging.ChatMessageKt;
import io.streamlayer.sdk.model.messaging.ChatMessageRelation;
import io.streamlayer.sdk.model.messaging.ChatMessageStatus;
import io.streamlayer.sdk.model.messaging.ChatMessageUpdate;
import io.streamlayer.sdk.model.messaging.ChatParticipantCrossRef;
import io.streamlayer.sdk.model.messaging.ChatRelation;
import io.streamlayer.sdk.model.tinodecontact.TinodeContact;
import io.streamlayer.sdk.repository.messaging.MessagingDao;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\ba\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\b\u0010\u0006\u001a\u00020\u0003H'J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH'J4\u0010\f\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r2\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00050\u00050\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H'Jq\u0010\u0017\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0005 \u000f*\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00180\u0018 \u000f*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0005 \u000f*\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00180\u0018\u0018\u00010\r0\r2\u0006\u0010\u0012\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001cJ;\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u0006\u0010\u0012\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001eJ,\u0010\u001f\u001a\u001e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00140\u0014\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00050\u00050 2\u0006\u0010\u0012\u001a\u00020\tH\u0016JA\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00180\r2\u0006\u0010\u0012\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u0014H'\u00a2\u0006\u0002\u0010\u001cJ;\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u0012\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\u0014H'\u00a2\u0006\u0002\u0010\u001eJ\u001c\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160 2\u0006\u0010\u0012\u001a\u00020\tH'J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\r2\u0006\u0010\b\u001a\u00020\tH'JN\u0010&\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e \u000f*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00180\u0018 \u000f*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000e \u000f*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00180\u0018\u0018\u00010\r0\r2\b\b\u0002\u0010'\u001a\u00020(H\u0016J\u0014\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u00180\rH'J\u0018\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00112\u0006\u0010\u0012\u001a\u00020\tH'J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0016\u0010-\u001a\u00020\u00032\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H'J\u0016\u0010/\u001a\u00020\u00032\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000\u0018H'J\u001e\u00101\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0018H\u0017J\u0016\u00104\u001a\u00020\u00032\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0017J\u0010\u00105\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u00106\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u000207H'J\u0016\u00108\u001a\u00020\u00032\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H'\u00a8\u00069"}, d2={"Lio/streamlayer/sdk/repository/messaging/MessagingDao;", "", "deleteChatMessage", "", "item", "Lio/streamlayer/sdk/model/messaging/ChatMessage;", "deleteChats", "deleteMessages", "chatId", "", "status", "Lio/streamlayer/sdk/model/messaging/ChatMessageStatus;", "getChat", "Lio/reactivex/Observable;", "Lio/streamlayer/sdk/model/messaging/Chat;", "kotlin.jvm.PlatformType", "getChatMessage", "Lio/reactivex/Maybe;", "topicId", "seq", "", "getChatMessageRelation", "Lio/streamlayer/sdk/model/messaging/ChatMessageRelation;", "getChatMessages", "", "beforeSeqId", "sinceSeqId", "limit", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;I)Lio/reactivex/Observable;", "getChatMessagesList", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;I)Ljava/util/List;", "getChatMessagesLiveData", "Landroidx/paging/DataSource$Factory;", "getChatMessagesRelation", "getChatMessagesRelationList", "getChatMessagesRelationLiveData", "getChatRelation", "Lio/streamlayer/sdk/model/messaging/ChatRelation;", "getChats", "isVoice", "", "getChatsRelation", "getLastSeqId", "saveChatMessage", "", "saveChatMessages", "items", "saveChatParticipantCrossRefs", "Lio/streamlayer/sdk/model/messaging/ChatParticipantCrossRef;", "saveChatParticipants", "participants", "Lio/streamlayer/sdk/model/tinodecontact/TinodeContact;", "saveChats", "saveOrUpdateChatMessage", "updateChatMessage", "Lio/streamlayer/sdk/model/messaging/ChatMessageUpdate;", "weakSaveChats", "sdk_originalRelease"})
@Dao
public interface MessagingDao {
    @Insert(onConflict=5)
    public long saveChatMessage(@NotNull ChatMessage var1);

    @Insert(onConflict=1)
    public void saveChatMessages(@NotNull List<ChatMessage> var1);

    @Update(entity=ChatMessage.class)
    public void updateChatMessage(@NotNull ChatMessageUpdate var1);

    public void saveOrUpdateChatMessage(@NotNull ChatMessage var1);

    @Query(value="DELETE FROM ChatMessage WHERE chatMessageTopicId = :chatId AND status = :status")
    public void deleteMessages(@NotNull String var1, @NotNull ChatMessageStatus var2);

    @Query(value="SELECT ChatMessage.chatMessageSeq FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = :topicId ORDER BY ChatMessage.chatMessageSeq DESC LIMIT 1")
    @NotNull
    public Maybe<Integer> getLastSeqId(@NotNull String var1);

    @Transaction
    @Query(value="SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = :topicId AND ChatMessage.chatMessageSeq = :seq")
    @NotNull
    public Maybe<ChatMessageRelation> getChatMessageRelation(@NotNull String var1, int var2);

    @NotNull
    public Maybe<ChatMessage> getChatMessage(@NotNull String var1, int var2);

    @Delete
    public void deleteChatMessage(@NotNull ChatMessage var1);

    @Transaction
    @Query(value="SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = :topicId ORDER BY ChatMessage.chatMessageSeq DESC")
    @NotNull
    public DataSource.Factory<Integer, ChatMessageRelation> getChatMessagesRelationLiveData(@NotNull String var1);

    @NotNull
    public DataSource.Factory<Integer, ChatMessage> getChatMessagesLiveData(@NotNull String var1);

    @Transaction
    @Query(value="SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = :topicId AND (chatMessageSeq < :beforeSeqId OR :beforeSeqId IS NULL) AND (chatMessageSeq >= :sinceSeqId OR :sinceSeqId IS NULL) ORDER BY ChatMessage.chatMessageSeq DESC LIMIT :limit")
    @NotNull
    public List<ChatMessageRelation> getChatMessagesRelationList(@NotNull String var1, @Nullable Integer var2, @Nullable Integer var3, int var4);

    @NotNull
    public List<ChatMessage> getChatMessagesList(@NotNull String var1, @Nullable Integer var2, @Nullable Integer var3, int var4);

    @Transaction
    @Query(value="SELECT * FROM ChatMessage WHERE ChatMessage.chatMessageTopicId = :topicId AND (chatMessageSeq < :beforeSeqId OR :beforeSeqId IS NULL) AND (chatMessageSeq >= :sinceSeqId OR :sinceSeqId IS NULL) ORDER BY ChatMessage.chatMessageSeq DESC LIMIT :limit")
    @NotNull
    public Observable<List<ChatMessageRelation>> getChatMessagesRelation(@NotNull String var1, @Nullable Integer var2, @Nullable Integer var3, int var4);

    public Observable<List<ChatMessage>> getChatMessages(@NotNull String var1, @Nullable Integer var2, @Nullable Integer var3, int var4);

    @Transaction
    @Query(value="SELECT * FROM Chat ORDER BY Chat.updatedAt DESC")
    @NotNull
    public Observable<List<ChatRelation>> getChatsRelation();

    public Observable<List<Chat>> getChats(boolean var1);

    @Transaction
    public void saveChats(@NotNull List<Chat> var1);

    @Insert(onConflict=1)
    public void weakSaveChats(@NotNull List<Chat> var1);

    @Query(value="DELETE FROM Chat")
    public void deleteChats();

    @Transaction
    @Query(value="SELECT * FROM Chat WHERE Chat.chatId = :chatId")
    @NotNull
    public Observable<ChatRelation> getChatRelation(@NotNull String var1);

    public Observable<Chat> getChat(@NotNull String var1);

    @Transaction
    public void saveChatParticipants(@NotNull String var1, @NotNull List<TinodeContact> var2);

    @Insert(onConflict=1)
    public void saveChatParticipantCrossRefs(@NotNull List<ChatParticipantCrossRef> var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static void saveOrUpdateChatMessage(MessagingDao messagingDao, @NotNull ChatMessage chatMessage) {
            ChatMessage chatMessage2 = chatMessage;
            Intrinsics.checkParameterIsNotNull((Object)chatMessage2, (String)"item");
            if (messagingDao.saveChatMessage(chatMessage2) == -1L) {
                messagingDao.updateChatMessage(ChatMessageKt.toUpdateEntity(chatMessage));
            }
        }

        @NotNull
        public static Maybe<ChatMessage> getChatMessage(MessagingDao messagingDao, @NotNull String string2, int n) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
            Maybe maybe = messagingDao.getChatMessageRelation(string2, n).map((Function)getChatMessage.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"getChatMessageRelation(t\u2026eq).map { it.toDomain() }");
            return maybe;
        }

        @NotNull
        public static DataSource.Factory<Integer, ChatMessage> getChatMessagesLiveData(MessagingDao messagingDao, @NotNull String string2) {
            String string3 = string2;
            Intrinsics.checkParameterIsNotNull((Object)string3, (String)"topicId");
            DataSource.Factory factory = messagingDao.getChatMessagesRelationLiveData(string3).map((androidx.arch.core.util.Function)getChatMessagesLiveData.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)factory, (String)"getChatMessagesRelationL\u2026Id).map { it.toDomain() }");
            return factory;
        }

        public static /* synthetic */ List getChatMessagesRelationList$default(MessagingDao messagingDao, String string2, Integer n, Integer n2, int n3, int n4, Object object) {
            if (object == null) {
                if ((n4 & 2) != 0) {
                    n = null;
                }
                if ((n4 & 4) != 0) {
                    n2 = null;
                }
                return messagingDao.getChatMessagesRelationList(string2, n, n2, n3);
            }
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChatMessagesRelationList");
        }

        @NotNull
        public static List<ChatMessage> getChatMessagesList(MessagingDao iterator, @NotNull String object, @Nullable Integer n, @Nullable Integer n2, int n3) {
            ArrayList arrayList;
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"topicId");
            iterator = iterator.getChatMessagesRelationList((String)object, n, n2, n3);
            object = arrayList;
            arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object.add(ChatMessageKt.toDomain((ChatMessageRelation)iterator.next()));
            }
            return object;
        }

        public static /* synthetic */ List getChatMessagesList$default(MessagingDao messagingDao, String string2, Integer n, Integer n2, int n3, int n4, Object object) {
            if (object == null) {
                if ((n4 & 2) != 0) {
                    n = null;
                }
                if ((n4 & 4) != 0) {
                    n2 = null;
                }
                return messagingDao.getChatMessagesList(string2, n, n2, n3);
            }
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChatMessagesList");
        }

        public static /* synthetic */ Observable getChatMessagesRelation$default(MessagingDao messagingDao, String string2, Integer n, Integer n2, int n3, int n4, Object object) {
            if (object == null) {
                if ((n4 & 2) != 0) {
                    n = null;
                }
                if ((n4 & 4) != 0) {
                    n2 = null;
                }
                return messagingDao.getChatMessagesRelation(string2, n, n2, n3);
            }
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChatMessagesRelation");
        }

        public static Observable<List<ChatMessage>> getChatMessages(MessagingDao messagingDao, @NotNull String string2, @Nullable Integer n, @Nullable Integer n2, int n3) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"topicId");
            return messagingDao.getChatMessagesRelation(string2, n, n2, n3).map((Function)getChatMessages.1.INSTANCE);
        }

        public static /* synthetic */ Observable getChatMessages$default(MessagingDao messagingDao, String string2, Integer n, Integer n2, int n3, int n4, Object object) {
            if (object == null) {
                if ((n4 & 2) != 0) {
                    n = null;
                }
                if ((n4 & 4) != 0) {
                    n2 = null;
                }
                return messagingDao.getChatMessages(string2, n, n2, n3);
            }
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChatMessages");
        }

        public static Observable<List<Chat>> getChats(MessagingDao messagingDao, boolean bl) {
            return messagingDao.getChatsRelation().map(new Function<T, R>(bl){
                final /* synthetic */ boolean $isVoice;
                {
                    this.$isVoice = bl;
                }

                @NotNull
                public final List<Chat> apply(@NotNull List<ChatRelation> object) {
                    ArrayList<E> arrayList;
                    ArrayList<Chat> arrayList2;
                    List<ChatRelation> list = object;
                    Intrinsics.checkParameterIsNotNull(list, (String)"it");
                    Object object2 = arrayList2;
                    arrayList2 = new ArrayList<Chat>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
                    object = list.iterator();
                    while (object.hasNext()) {
                        object2.add(ChatKt.toDomain((ChatRelation)object.next()));
                    }
                    object = arrayList;
                    arrayList = new ArrayList<E>();
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        E e = object2.next();
                        Chat chat = (Chat)e;
                        if (!(this.$isVoice ? chat.isVoiceChat() : !chat.isVoiceChat())) continue;
                        object.add(e);
                    }
                    return CollectionsKt.sortedWith((Iterable)object, new Comparator<T>(){

                        public final int compare(T object, T object2) {
                            Object object3 = (Chat)object2;
                            if ((object2 = ((Chat)object3).getLastMessage()) == null || (object2 = ((ChatMessage)object2).getDate()) == null) {
                                object2 = ((Chat)object3).getTouchedAt();
                            }
                            object3 = (Chat)object;
                            object = ((Chat)object3).getLastMessage();
                            if (object == null || (object = ((ChatMessage)object).getDate()) == null) {
                                object = ((Chat)object3).getTouchedAt();
                            }
                            return ComparisonsKt.compareValues((Comparable)object2, (Comparable)object);
                        }
                    });
                }
            });
        }

        public static /* synthetic */ Observable getChats$default(MessagingDao messagingDao, boolean bl, int n, Object object) {
            if (object == null) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                return messagingDao.getChats(bl);
            }
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getChats");
        }

        @Transaction
        public static void saveChats(MessagingDao messagingDao, @NotNull List<Chat> list) {
            List<Chat> list2 = list;
            Intrinsics.checkParameterIsNotNull(list2, (String)"items");
            messagingDao.weakSaveChats(list2);
        }

        public static Observable<Chat> getChat(MessagingDao messagingDao, @NotNull String string2) {
            String string3 = string2;
            Intrinsics.checkParameterIsNotNull((Object)string3, (String)"chatId");
            return messagingDao.getChatRelation(string3).map((Function)getChat.1.INSTANCE);
        }

        @Transaction
        public static void saveChatParticipants(MessagingDao messagingDao, @NotNull String string2, @NotNull List<TinodeContact> object) {
            ArrayList<ChatParticipantCrossRef> arrayList;
            List<TinodeContact> list = object;
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"chatId");
            Intrinsics.checkParameterIsNotNull(list, (String)"participants");
            ArrayList<ChatParticipantCrossRef> arrayList2 = arrayList;
            arrayList = new ArrayList<ChatParticipantCrossRef>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
            for (TinodeContact tinodeContact : list) {
                arrayList2.add(new ChatParticipantCrossRef(string2, tinodeContact.getChatUserId()));
            }
            messagingDao.saveChatParticipantCrossRefs(arrayList2);
        }
    }
}

