/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.session;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.lifecycle.LiveData;
import com.google.gson.reflect.TypeToken;
import io.reactivex.Observable;
import io.streamlayer.common.session.LiveDataSession;
import io.streamlayer.common.session.Session;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.model.auth.User;
import io.streamlayer.sdk.model.sdksettings.OrganizationSettings;
import io.streamlayer.utils.GsonUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0001\u0018\u0000 <2\u00020\u0001:\u0001<B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0016J\u0014\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0$0#H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020&0#H\u0016J\b\u0010'\u001a\u00020 H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020 0)H\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u0006H\u0016J\b\u0010,\u001a\u00020\u001aH\u0016J\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020&H\u0016J\u0015\u0010/\u001a\u00020\u001a2\b\u00100\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u00101J\u0010\u00102\u001a\u00020\u001a2\b\u00103\u001a\u0004\u0018\u00010\u0006J\u001c\u00104\u001a\u00020\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u00105\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0006H\u0016J\u0018\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020 H\u0016J\u0018\u00109\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010:\u001a\u00020 H\u0016J\u0010\u0010;\u001a\u00020 2\u0006\u00107\u001a\u00020\u0006H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\t\"\u0004\b\u0010\u0010\u000bR\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\tR(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006="}, d2={"Lio/streamlayer/common/session/SessionPrefImpl;", "Lio/streamlayer/common/session/Session;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "value", "", "firebaseToken", "getFirebaseToken", "()Ljava/lang/String;", "setFirebaseToken", "(Ljava/lang/String;)V", "mSharedPreferences", "Landroid/content/SharedPreferences;", "sdkKey", "getSdkKey", "setSdkKey", "token", "getToken", "user", "Lio/streamlayer/sdk/model/auth/User;", "getUser", "()Lio/streamlayer/sdk/model/auth/User;", "setUser", "(Lio/streamlayer/sdk/model/auth/User;)V", "addInvitedContact", "", "contactId", "", "apiBasePort", "apiBaseUrl", "checkPermissionAsked", "", "permission", "getInvitedContactIds", "Lio/reactivex/Observable;", "", "getOrganizationSettings", "Lio/streamlayer/sdk/model/sdksettings/OrganizationSettings;", "isLoggedIn", "isLoggedInListener", "Landroidx/lifecycle/LiveData;", "isTipsShown", "tipSet", "logout", "saveOrganizationSettings", "settings", "setApiBasePort", "basePort", "(Ljava/lang/Integer;)V", "setApiBaseUrl", "baseUrl", "setLoggedIn", "setPermissionAsked", "setSkipOnboardingStep", "stepName", "skip", "setTipsShown", "shown", "shouldSkipOnboardingStep", "Companion", "sdk_release"})
public final class SessionPrefImpl
implements Session {
    private static final String KEY_USER = "session_user";
    private static final String KEY_TOKEN = "session_token";
    public static final Companion Companion = new Companion(null);
    private final SharedPreferences mSharedPreferences;

    @Inject
    public SessionPrefImpl(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SharedPreferences sharedPreferences = context.getSharedPreferences("io.streamlayer.sdk_session", 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026xt.MODE_PRIVATE\n        )");
        this.mSharedPreferences = sharedPreferences;
    }

    public static final /* synthetic */ SharedPreferences access$getMSharedPreferences$p(SessionPrefImpl sessionPrefImpl) {
        return sessionPrefImpl.mSharedPreferences;
    }

    @Override
    @Nullable
    public String getSdkKey() {
        return this.mSharedPreferences.getString("sdk_key", null);
    }

    @Override
    public void setSdkKey(@Nullable String string2) {
        this.mSharedPreferences.edit().putString("sdk_key", string2).apply();
    }

    @Override
    @Nullable
    public String getToken() {
        return this.mSharedPreferences.getString(KEY_TOKEN, null);
    }

    @Override
    @Nullable
    public User getUser() {
        return (User)GsonUtil.INSTANCE.getDefaultGson().fromJson(this.mSharedPreferences.getString(KEY_USER, null), User.class);
    }

    @Override
    public void setUser(@Nullable User user) {
        this.mSharedPreferences.edit().putString(KEY_USER, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)user)).apply();
    }

    @Override
    @NotNull
    public String getFirebaseToken() {
        Object object = ((SessionPrefImpl)object).mSharedPreferences.getString("firebase_token", "");
        if (object == null) {
            object = "";
        }
        return object;
    }

    @Override
    public void setFirebaseToken(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"value");
        this.mSharedPreferences.edit().putString("firebase_token", string2).apply();
    }

    @Override
    public void setLoggedIn(@Nullable String string2, @Nullable User user) {
        this.mSharedPreferences.edit().putString(KEY_TOKEN, string2).putString(KEY_USER, GsonUtil.INSTANCE.getDefaultGson().toJson((Object)user)).apply();
    }

    @Override
    public boolean isLoggedIn() {
        String string2 = this.getToken();
        return !(string2 == null || string2.length() == 0) && this.getUser() != null;
    }

    @Override
    @NotNull
    public LiveData<Boolean> isLoggedInListener() {
        return new LiveDataSession<String, Boolean>(this.mSharedPreferences, KEY_TOKEN, isLoggedInListener.1.INSTANCE);
    }

    @Override
    public void logout() {
        this.setLoggedIn(null, null);
    }

    @Override
    public boolean checkPermissionAsked(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"permission");
        return this.mSharedPreferences.contains("PERMISSION_ASKED_" + string2);
    }

    @Override
    public void setPermissionAsked(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"permission");
        this.mSharedPreferences.edit().putBoolean("PERMISSION_ASKED_" + string2, true).apply();
    }

    @Override
    public boolean shouldSkipOnboardingStep(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"stepName");
        return this.mSharedPreferences.getBoolean("onboarding_step_skip_" + string2, false);
    }

    @Override
    public void setSkipOnboardingStep(@NotNull String string2, boolean bl) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"stepName");
        this.mSharedPreferences.edit().putBoolean("onboarding_step_skip_" + string2, bl).apply();
    }

    @Override
    public boolean isTipsShown(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"tipSet");
        return this.mSharedPreferences.getBoolean(string2 + "_tips_shown", false);
    }

    @Override
    public void setTipsShown(@NotNull String string2, boolean bl) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"tipSet");
        this.mSharedPreferences.edit().putBoolean(string2 + "_tips_shown", bl).apply();
    }

    @Nullable
    public final String apiBaseUrl() {
        return this.mSharedPreferences.getString("abu", null);
    }

    public final void setApiBaseUrl(@Nullable String string2) {
        if (string2 != null) {
            this.mSharedPreferences.edit().putString("abu", string2).apply();
        } else {
            this.mSharedPreferences.edit().remove("abu").apply();
        }
    }

    public final int apiBasePort() {
        return this.mSharedPreferences.getInt("abp", 0);
    }

    public final void setApiBasePort(@Nullable Integer n) {
        if (n != null) {
            this.mSharedPreferences.edit().putInt("abp", n.intValue()).apply();
        } else {
            this.mSharedPreferences.edit().remove("abp").apply();
        }
    }

    @Override
    @NotNull
    public Observable<OrganizationSettings> getOrganizationSettings() {
        SessionPrefImpl sessionPrefImpl;
        if (sessionPrefImpl.mSharedPreferences.contains("organization_settings")) {
            sessionPrefImpl = Observable.just((Object)GsonUtil.INSTANCE.getDefaultGson().fromJson(sessionPrefImpl.mSharedPreferences.getString("organization_settings", "[]"), OrganizationSettings.class));
            Intrinsics.checkExpressionValueIsNotNull((Object)sessionPrefImpl, (String)"Observable.just(\n       \u2026          )\n            )");
        } else {
            sessionPrefImpl = Observable.empty();
            Intrinsics.checkExpressionValueIsNotNull((Object)sessionPrefImpl, (String)"Observable.empty()");
        }
        return sessionPrefImpl;
    }

    @Override
    public void saveOrganizationSettings(@NotNull OrganizationSettings organizationSettings) {
        Intrinsics.checkParameterIsNotNull((Object)organizationSettings, (String)"settings");
        this.mSharedPreferences.edit().putString("organization_settings", GsonUtil.INSTANCE.getDefaultGson().toJson((Object)organizationSettings)).apply();
    }

    @Override
    @NotNull
    public Observable<List<Integer>> getInvitedContactIds() {
        SessionPrefImpl sessionPrefImpl;
        if (sessionPrefImpl.mSharedPreferences.contains("invited_contact_ids")) {
            Type type2 = new TypeToken<ArrayList<Integer>>(){}.getType();
            sessionPrefImpl = Observable.fromCallable(new Callable<T>(sessionPrefImpl, type2){
                final /* synthetic */ SessionPrefImpl this$0;
                final /* synthetic */ Type $type;
                {
                    this.this$0 = sessionPrefImpl;
                    this.$type = type2;
                }

                public final List<Integer> call() {
                    return (List)GsonUtil.INSTANCE.getDefaultGson().fromJson(SessionPrefImpl.access$getMSharedPreferences$p(this.this$0).getString("invited_contact_ids", "[]"), this.$type);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)sessionPrefImpl, (String)"Observable.fromCallable<\u2026[]\"), type)\n            }");
        } else {
            sessionPrefImpl = Observable.empty();
            Intrinsics.checkExpressionValueIsNotNull((Object)sessionPrefImpl, (String)"Observable.empty()");
        }
        return sessionPrefImpl;
    }

    @Override
    public void addInvitedContact(int n) {
        ArrayList<Integer> arrayList;
        Object object = arrayList;
        arrayList = new ArrayList<Integer>();
        if (this.mSharedPreferences.contains("invited_contact_ids")) {
            object = new TypeToken<ArrayList<Integer>>(){}.getType();
            object = GsonUtil.INSTANCE.getDefaultGson().fromJson(this.mSharedPreferences.getString("invited_contact_ids", "[]"), (Type)object);
            if (object != null) {
                object = (ArrayList)object;
            } else {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.ArrayList<kotlin.Int> /* = java.util.ArrayList<kotlin.Int> */");
            }
        }
        ((ArrayList)object).add(n);
        this.mSharedPreferences.edit().putString("invited_contact_ids", GsonUtil.INSTANCE.getDefaultGson().toJson(object)).apply();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/streamlayer/common/session/SessionPrefImpl$Companion;", "", "()V", "KEY_TOKEN", "", "KEY_USER", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

