/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.demo.weather.model;

import androidx.room.Embedded;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.google.gson.annotations.SerializedName;
import io.streamlayer.demo.weather.model.Main;
import io.streamlayer.demo.weather.model.Weather;
import io.streamlayer.demo.weather.model.WeatherConverter;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0081\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\fH\u00c6\u0003JA\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010!\u001a\u00020\nJ\u0006\u0010\"\u001a\u00020\nJ\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\t\u0010$\u001a\u00020\nH\u00d6\u0001R\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lio/streamlayer/demo/weather/model/WeatherResponse;", "", "id", "", "weather", "", "Lio/streamlayer/demo/weather/model/Weather;", "main", "Lio/streamlayer/demo/weather/model/Main;", "name", "", "date", "", "(ILjava/util/List;Lio/streamlayer/demo/weather/model/Main;Ljava/lang/String;J)V", "getDate", "()J", "getId", "()I", "getMain", "()Lio/streamlayer/demo/weather/model/Main;", "getName", "()Ljava/lang/String;", "getWeather", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "getDateTimeString", "getImageUrl", "hashCode", "toString", "sdk_release"})
@Entity
@TypeConverters(value={WeatherConverter.class})
public final class WeatherResponse {
    @SerializedName(value="id")
    @PrimaryKey
    private final int id;
    @SerializedName(value="weather")
    @NotNull
    private final List<Weather> weather;
    @SerializedName(value="main")
    @Embedded
    @NotNull
    private final Main main;
    @SerializedName(value="name")
    @NotNull
    private final String name;
    @SerializedName(value="dt")
    private final long date;

    public WeatherResponse(int n, @NotNull List<Weather> list, @NotNull Main main, @NotNull String string2, long l) {
        Intrinsics.checkParameterIsNotNull(list, (String)"weather");
        Intrinsics.checkParameterIsNotNull((Object)main, (String)"main");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        this.id = n;
        this.weather = list;
        this.main = main;
        this.name = string2;
        this.date = l;
    }

    public static /* synthetic */ WeatherResponse copy$default(WeatherResponse weatherResponse, int n, List list, Main main, String string2, long l, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = weatherResponse.id;
        }
        if ((n2 & 2) != 0) {
            list = weatherResponse.weather;
        }
        if ((n2 & 4) != 0) {
            main = weatherResponse.main;
        }
        if ((n2 & 8) != 0) {
            string2 = weatherResponse.name;
        }
        if ((n2 & 0x10) != 0) {
            l = weatherResponse.date;
        }
        return weatherResponse.copy(n, list, main, string2, l);
    }

    @NotNull
    public final String getImageUrl() {
        return "https://openweathermap.org/img/w/" + this.weather.get(0).getIcon() + ".png";
    }

    @NotNull
    public final String getDateTimeString() {
        String string2 = new SimpleDateFormat("dd.MM. HH:mm", Locale.US).format(this.date * (long)1000);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"format.format(date * 1000)");
        return string2;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final List<Weather> getWeather() {
        return this.weather;
    }

    @NotNull
    public final Main getMain() {
        return this.main;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getDate() {
        return this.date;
    }

    public final int component1() {
        return this.id;
    }

    @NotNull
    public final List<Weather> component2() {
        return this.weather;
    }

    @NotNull
    public final Main component3() {
        return this.main;
    }

    @NotNull
    public final String component4() {
        return this.name;
    }

    public final long component5() {
        return this.date;
    }

    @NotNull
    public final WeatherResponse copy(int n, @NotNull List<Weather> list, @NotNull Main main, @NotNull String string2, long l) {
        Intrinsics.checkParameterIsNotNull(list, (String)"weather");
        Intrinsics.checkParameterIsNotNull((Object)main, (String)"main");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"name");
        return new WeatherResponse(n, list, main, string2, l);
    }

    @NotNull
    public String toString() {
        return "WeatherResponse(id=" + this.id + ", weather=" + this.weather + ", main=" + this.main + ", name=" + this.name + ", date=" + this.date + ")";
    }

    public int hashCode() {
        WeatherResponse weatherResponse = this;
        int n = Integer.hashCode(weatherResponse.id) * 31;
        List<Weather> list = weatherResponse.weather;
        int n2 = list != null ? ((Object)list).hashCode() : 0;
        n = (n + n2) * 31;
        Main main = this.main;
        int n3 = main != null ? main.hashCode() : 0;
        n = (n + n3) * 31;
        String string2 = this.name;
        int n4 = string2 != null ? string2.hashCode() : 0;
        return (n + n4) * 31 + Long.hashCode(this.date);
    }

    public boolean equals(@Nullable Object object) {
        block2: {
            block3: {
                if (this == object) break block2;
                if (!(object instanceof WeatherResponse)) break block3;
                object = (WeatherResponse)object;
                if (this.id == ((WeatherResponse)object).id && Intrinsics.areEqual(this.weather, ((WeatherResponse)object).weather) && Intrinsics.areEqual((Object)this.main, (Object)((WeatherResponse)object).main) && Intrinsics.areEqual((Object)this.name, (Object)((WeatherResponse)object).name) && this.date == ((WeatherResponse)object).date) break block2;
            }
            return false;
        }
        return true;
    }
}

