/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.dagger.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DoubleCheck;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import io.streamlayer.common.dagger.components.StreamLayerComponent;
import io.streamlayer.common.dagger.modules.ApiServiceModule;
import io.streamlayer.common.dagger.modules.ApiServiceModule_ApiServiceFactory;
import io.streamlayer.common.dagger.modules.ApiServiceModule_RetrofitFactory;
import io.streamlayer.common.dagger.modules.ContextModule;
import io.streamlayer.common.dagger.modules.ContextModule_ContextFactory;
import io.streamlayer.common.dagger.modules.DatabaseModule;
import io.streamlayer.common.dagger.modules.DatabaseModule_DatabaseFactory;
import io.streamlayer.common.dagger.modules.GrpcServiceModule;
import io.streamlayer.common.dagger.modules.GrpcServiceModule_GrpcFactory;
import io.streamlayer.common.dagger.modules.NetworkModule;
import io.streamlayer.common.dagger.modules.NetworkModule_OkHttpClientFactory;
import io.streamlayer.common.dagger.modules.NetworkModule_RequestInterceptorFactory;
import io.streamlayer.common.dagger.modules.RepositoryModule;
import io.streamlayer.common.dagger.modules.RepositoryModule_ProvidesCurrentWeatherRepoFactory;
import io.streamlayer.common.dagger.modules.RepositoryModule_ProvidesSdkSettingsRepoFactory;
import io.streamlayer.common.dagger.modules.RepositoryModule_ProvidesTwitterRepoFactory;
import io.streamlayer.common.dagger.modules.ViewModelFactoryModule;
import io.streamlayer.common.dagger.modules.ViewModelFactoryModule_ProvideViewModelFactoryFactory;
import io.streamlayer.common.data.database.AppDatabase;
import io.streamlayer.common.data.grpc.GrpcInterceptor;
import io.streamlayer.common.data.grpc.GrpcInterceptor_Factory;
import io.streamlayer.common.data.grpc.GrpcService;
import io.streamlayer.common.data.retrofit.ApiInterface;
import io.streamlayer.common.mvvm.ViewModelFactory;
import io.streamlayer.common.mvvm.ViewModelFactory_Factory;
import io.streamlayer.common.scheduler.AndroidSchedulerProvider_Factory;
import io.streamlayer.common.scheduler.SchedulerProvider;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.common.session.SessionPrefImpl_Factory;
import io.streamlayer.demo.weather.repository.mock.MockRepo;
import io.streamlayer.demo.weather.repository.weather.WeatherRepo;
import io.streamlayer.demo.weather.repository.weather.WeatherRepoImpl;
import io.streamlayer.demo.weather.repository.weather.WeatherRepoImpl_Factory;
import io.streamlayer.demo.weather.weather.WeatherViewModel;
import io.streamlayer.demo.weather.weather.WeatherViewModel_Factory;
import io.streamlayer.sdk.main.StreamLayerViewModel;
import io.streamlayer.sdk.main.StreamLayerViewModel_Factory;
import io.streamlayer.sdk.repository.sdksettings.SdkSettingsRepo;
import io.streamlayer.sdk.repository.sdksettings.SdkSettingsRepoImpl;
import io.streamlayer.sdk.repository.sdksettings.SdkSettingsRepoImpl_Factory;
import io.streamlayer.sdk.repository.twitter.TwitterRepo;
import io.streamlayer.sdk.repository.twitter.TwitterRepoImpl;
import io.streamlayer.sdk.repository.twitter.TwitterRepoImpl_Factory;
import io.streamlayer.sdk.twitter.TwitterViewModel;
import io.streamlayer.sdk.twitter.TwitterViewModel_Factory;
import java.util.Map;
import javax.inject.Provider;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public final class DaggerStreamLayerComponent
implements StreamLayerComponent {
    private final ViewModelFactoryModule viewModelFactoryModule;
    private Provider<Context> contextProvider;
    private Provider<SessionPrefImpl> sessionPrefImplProvider;
    private Provider<Interceptor> requestInterceptorProvider;
    private Provider<OkHttpClient> okHttpClientProvider;
    private Provider<Retrofit> retrofitProvider;
    private Provider<ApiInterface> apiServiceProvider;
    private Provider<GrpcInterceptor> grpcInterceptorProvider;
    private Provider<GrpcService> grpcProvider;
    private Provider<AppDatabase> databaseProvider;
    private Provider<WeatherRepoImpl> weatherRepoImplProvider;
    private Provider<WeatherRepo> providesCurrentWeatherRepoProvider;
    private Provider<WeatherViewModel> weatherViewModelProvider;
    private Provider<TwitterRepoImpl> twitterRepoImplProvider;
    private Provider<TwitterRepo> providesTwitterRepoProvider;
    private Provider<TwitterViewModel> twitterViewModelProvider;
    private Provider<SdkSettingsRepoImpl> sdkSettingsRepoImplProvider;
    private Provider<SdkSettingsRepo> providesSdkSettingsRepoProvider;
    private Provider<StreamLayerViewModel> streamLayerViewModelProvider;
    private Provider<Map<Class<? extends ViewModel>, Provider<ViewModel>>> mapOfClassOfAndProviderOfViewModelProvider;
    private Provider<ViewModelFactory> viewModelFactoryProvider;

    private DaggerStreamLayerComponent(ApiServiceModule apiServiceModule, NetworkModule networkModule, ContextModule contextModule, GrpcServiceModule grpcServiceModule, DatabaseModule databaseModule, RepositoryModule repositoryModule, ViewModelFactoryModule viewModelFactoryModule) {
        this.viewModelFactoryModule = viewModelFactoryModule;
        this.initialize(apiServiceModule, networkModule, contextModule, grpcServiceModule, databaseModule, repositoryModule, viewModelFactoryModule);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(ApiServiceModule apiServiceModule, NetworkModule networkModule, ContextModule contextModule, GrpcServiceModule grpcServiceModule, DatabaseModule databaseModule, RepositoryModule repositoryModule, ViewModelFactoryModule viewModelFactoryModule) {
        DaggerStreamLayerComponent daggerStreamLayerComponent = this;
        DaggerStreamLayerComponent daggerStreamLayerComponent2 = this;
        DaggerStreamLayerComponent daggerStreamLayerComponent3 = this;
        DaggerStreamLayerComponent daggerStreamLayerComponent4 = this;
        DaggerStreamLayerComponent daggerStreamLayerComponent5 = this;
        DaggerStreamLayerComponent daggerStreamLayerComponent6 = this;
        daggerStreamLayerComponent6.contextProvider = DoubleCheck.provider((Provider)ContextModule_ContextFactory.create(contextModule));
        daggerStreamLayerComponent6.sessionPrefImplProvider = DoubleCheck.provider((Provider)SessionPrefImpl_Factory.create(daggerStreamLayerComponent6.contextProvider));
        this.requestInterceptorProvider = DoubleCheck.provider((Provider)NetworkModule_RequestInterceptorFactory.create(networkModule, daggerStreamLayerComponent6.sessionPrefImplProvider));
        this.okHttpClientProvider = DoubleCheck.provider((Provider)NetworkModule_OkHttpClientFactory.create(networkModule, this.requestInterceptorProvider));
        this.retrofitProvider = DoubleCheck.provider((Provider)ApiServiceModule_RetrofitFactory.create(apiServiceModule, this.okHttpClientProvider, this.sessionPrefImplProvider));
        daggerStreamLayerComponent5.apiServiceProvider = DoubleCheck.provider((Provider)ApiServiceModule_ApiServiceFactory.create(apiServiceModule, this.retrofitProvider));
        daggerStreamLayerComponent5.grpcInterceptorProvider = GrpcInterceptor_Factory.create(daggerStreamLayerComponent5.sessionPrefImplProvider);
        this.grpcProvider = DoubleCheck.provider((Provider)GrpcServiceModule_GrpcFactory.create(grpcServiceModule, daggerStreamLayerComponent5.grpcInterceptorProvider));
        daggerStreamLayerComponent4.databaseProvider = DoubleCheck.provider((Provider)DatabaseModule_DatabaseFactory.create(databaseModule, this.contextProvider));
        daggerStreamLayerComponent4.weatherRepoImplProvider = WeatherRepoImpl_Factory.create(daggerStreamLayerComponent4.databaseProvider, this.apiServiceProvider, this.sessionPrefImplProvider);
        daggerStreamLayerComponent3.providesCurrentWeatherRepoProvider = DoubleCheck.provider((Provider)RepositoryModule_ProvidesCurrentWeatherRepoFactory.create(repositoryModule, daggerStreamLayerComponent4.weatherRepoImplProvider));
        daggerStreamLayerComponent3.weatherViewModelProvider = WeatherViewModel_Factory.create((Provider<SchedulerProvider>)AndroidSchedulerProvider_Factory.create(), this.providesCurrentWeatherRepoProvider, this.sessionPrefImplProvider, this.apiServiceProvider);
        daggerStreamLayerComponent3.twitterRepoImplProvider = TwitterRepoImpl_Factory.create(daggerStreamLayerComponent3.databaseProvider, this.apiServiceProvider, this.grpcProvider, this.sessionPrefImplProvider);
        daggerStreamLayerComponent2.providesTwitterRepoProvider = DoubleCheck.provider((Provider)RepositoryModule_ProvidesTwitterRepoFactory.create(repositoryModule, daggerStreamLayerComponent3.twitterRepoImplProvider));
        daggerStreamLayerComponent2.twitterViewModelProvider = TwitterViewModel_Factory.create(daggerStreamLayerComponent2.providesTwitterRepoProvider, (Provider<SchedulerProvider>)AndroidSchedulerProvider_Factory.create(), this.sessionPrefImplProvider, this.apiServiceProvider);
        daggerStreamLayerComponent2.sdkSettingsRepoImplProvider = SdkSettingsRepoImpl_Factory.create(daggerStreamLayerComponent2.databaseProvider, this.apiServiceProvider, this.grpcProvider, this.sessionPrefImplProvider);
        daggerStreamLayerComponent.providesSdkSettingsRepoProvider = DoubleCheck.provider((Provider)RepositoryModule_ProvidesSdkSettingsRepoFactory.create(repositoryModule, daggerStreamLayerComponent2.sdkSettingsRepoImplProvider));
        daggerStreamLayerComponent.streamLayerViewModelProvider = StreamLayerViewModel_Factory.create(daggerStreamLayerComponent.providesSdkSettingsRepoProvider, (Provider<SchedulerProvider>)AndroidSchedulerProvider_Factory.create(), this.sessionPrefImplProvider, this.apiServiceProvider);
        daggerStreamLayerComponent.mapOfClassOfAndProviderOfViewModelProvider = MapProviderFactory.builder((int)3).put(WeatherViewModel.class, this.weatherViewModelProvider).put(TwitterViewModel.class, this.twitterViewModelProvider).put(StreamLayerViewModel.class, this.streamLayerViewModelProvider).build();
        daggerStreamLayerComponent.viewModelFactoryProvider = DoubleCheck.provider((Provider)ViewModelFactory_Factory.create(daggerStreamLayerComponent.mapOfClassOfAndProviderOfViewModelProvider));
    }

    @Override
    public Context getContext() {
        return (Context)this.contextProvider.get();
    }

    @Override
    public ApiInterface getApiInterface() {
        return (ApiInterface)this.apiServiceProvider.get();
    }

    @Override
    public GrpcService getGrpcService() {
        return (GrpcService)this.grpcProvider.get();
    }

    @Override
    public AppDatabase getDatabase() {
        return (AppDatabase)((Object)this.databaseProvider.get());
    }

    @Override
    public SessionPrefImpl getSessionPrefImpl() {
        return (SessionPrefImpl)this.sessionPrefImplProvider.get();
    }

    @Override
    public ViewModelProvider.Factory getViewModelFactoryProvider() {
        return ViewModelFactoryModule_ProvideViewModelFactoryFactory.provideViewModelFactory(this.viewModelFactoryModule, (ViewModelFactory)this.viewModelFactoryProvider.get());
    }

    @Override
    public MockRepo getMockRepo() {
        return new MockRepo((AppDatabase)((Object)this.databaseProvider.get()), (ApiInterface)this.apiServiceProvider.get(), (SessionPrefImpl)this.sessionPrefImplProvider.get());
    }

    public static final class Builder {
        private ApiServiceModule apiServiceModule;
        private NetworkModule networkModule;
        private ContextModule contextModule;
        private GrpcServiceModule grpcServiceModule;
        private DatabaseModule databaseModule;
        private RepositoryModule repositoryModule;
        private ViewModelFactoryModule viewModelFactoryModule;

        private Builder() {
        }

        public Builder apiServiceModule(ApiServiceModule apiServiceModule) {
            this.apiServiceModule = (ApiServiceModule)Preconditions.checkNotNull((Object)apiServiceModule);
            return this;
        }

        public Builder networkModule(NetworkModule networkModule) {
            this.networkModule = (NetworkModule)Preconditions.checkNotNull((Object)networkModule);
            return this;
        }

        public Builder contextModule(ContextModule contextModule) {
            this.contextModule = (ContextModule)Preconditions.checkNotNull((Object)contextModule);
            return this;
        }

        public Builder grpcServiceModule(GrpcServiceModule grpcServiceModule) {
            this.grpcServiceModule = (GrpcServiceModule)Preconditions.checkNotNull((Object)grpcServiceModule);
            return this;
        }

        public Builder databaseModule(DatabaseModule databaseModule) {
            this.databaseModule = (DatabaseModule)Preconditions.checkNotNull((Object)databaseModule);
            return this;
        }

        public Builder repositoryModule(RepositoryModule repositoryModule) {
            this.repositoryModule = (RepositoryModule)Preconditions.checkNotNull((Object)repositoryModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public StreamLayerComponent build() {
            if (this.apiServiceModule == null) {
                this.apiServiceModule = new ApiServiceModule();
            }
            if (this.networkModule == null) {
                this.networkModule = new NetworkModule();
            }
            Builder builder = this;
            Preconditions.checkBuilderRequirement((Object)builder.contextModule, ContextModule.class);
            if (builder.grpcServiceModule == null) {
                this.grpcServiceModule = new GrpcServiceModule();
            }
            if (this.databaseModule == null) {
                this.databaseModule = new DatabaseModule();
            }
            if (this.repositoryModule == null) {
                this.repositoryModule = new RepositoryModule();
            }
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            return new DaggerStreamLayerComponent(this.apiServiceModule, this.networkModule, this.contextModule, this.grpcServiceModule, this.databaseModule, this.repositoryModule, this.viewModelFactoryModule);
        }
    }
}

