/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.mvvm;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.greysonparrelli.permiso.Permiso;
import io.streamlayer.common.dagger.components.ActivityComponent;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.mvvm.BaseView;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.R;
import io.streamlayer.utils.DialogUtil;
import java.util.HashMap;
import java.util.Locale;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0015\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001f\u0010\u0016\u001a\u00020\u00112\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0018\"\u00020\u0013\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0014J\u0012\u0010$\u001a\u00020\u001b2\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\b\u0010'\u001a\u00020\u001bH\u0016J+\u0010(\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00182\u0006\u0010)\u001a\u00020*H\u0016\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\u001bH\u0014J\u0012\u0010-\u001a\u00020\u001b2\b\b\u0001\u0010.\u001a\u00020 H\u0016J\b\u0010/\u001a\u00020\u001bH\u0002J\u0010\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u00020 H\u0016J\u0010\u00100\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u0013H\u0016J&\u00103\u001a\u00020\u001b2\b\b\u0001\u00104\u001a\u00020 2\b\b\u0001\u00105\u001a\u00020 2\b\b\u0001\u00106\u001a\u00020 H\u0016J&\u00103\u001a\u00020\u001b2\b\u00107\u001a\u0004\u0018\u00010\u00132\b\u00108\u001a\u0004\u0018\u00010\u00132\b\u00106\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u0011H\u0016J\u0018\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u00112\u0006\u0010;\u001a\u00020\u0011H\u0016J\u0010\u0010<\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u0011H\u0016J\u0010\u0010=\u001a\u00020\u001b2\u0006\u00101\u001a\u00020 H\u0016J\u0010\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lio/streamlayer/common/mvvm/BaseActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lio/streamlayer/common/mvvm/BaseView;", "()V", "pd", "Landroid/app/Dialog;", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "getSession", "()Lio/streamlayer/common/session/SessionPrefImpl;", "setSession", "(Lio/streamlayer/common/session/SessionPrefImpl;)V", "toolbar", "Landroidx/appcompat/widget/Toolbar;", "toolbarProgressCircle", "Landroid/widget/ProgressBar;", "checkPermissionDenied", "", "permission", "", "checkPermissionDeniedForGood", "checkPermissionGranted", "checkPermissionsGranted", "permissions", "", "([Ljava/lang/String;)Z", "hideKeyboard", "", "view", "Landroid/view/View;", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onLogout", "onRequestPermissionsResult", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "setContentView", "layoutResID", "setLanguage", "showError", "stringResourceId", "errorMessage", "showInfoDialog", "titleResourceId", "descriptionResourceId", "buttonText", "title", "description", "showLoader", "show", "cancelable", "showProgressCircle", "showShortInfo", "info", "sdk_release"})
public abstract class BaseActivity
extends AppCompatActivity
implements BaseView {
    @Inject
    @NotNull
    public SessionPrefImpl session;
    private Dialog pd;
    private Toolbar toolbar;
    private ProgressBar toolbarProgressCircle;
    private HashMap _$_findViewCache;

    private final void setLanguage() {
        Configuration configuration;
        Locale locale;
        BaseActivity baseActivity = locale2;
        Locale locale2 = locale;
        Locale.setDefault(new Locale("hr", "HR"));
        Configuration configuration2 = configuration;
        configuration2();
        configuration.locale = locale2;
        Context context = baseActivity.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        context.getResources().updateConfiguration(configuration2, null);
    }

    @NotNull
    public final SessionPrefImpl getSession() {
        SessionPrefImpl sessionPrefImpl = ((BaseActivity)((Object)sessionPrefImpl)).session;
        if (sessionPrefImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        return sessionPrefImpl;
    }

    public final void setSession(@NotNull SessionPrefImpl sessionPrefImpl) {
        SessionPrefImpl sessionPrefImpl2 = sessionPrefImpl;
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl2, (String)"<set-?>");
        this.session = sessionPrefImpl2;
    }

    protected void onCreate(@Nullable Bundle bundle) {
        ActivityComponent.Companion.inject$sdk_release(this);
        super.onCreate(bundle);
        Permiso.getInstance().setActivity((Activity)this);
        BaseActivity baseActivity = this;
        this.pd = DialogUtil.INSTANCE.buildLoaderDialog((Activity)baseActivity, baseActivity.getString(R.string.please_wait));
    }

    protected void onResume() {
        super.onResume();
        Permiso.getInstance().setActivity((Activity)this);
    }

    public final boolean checkPermissionGranted(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)this, (String)string3) == 0;
    }

    public final boolean checkPermissionsGranted(String ... stringArray) {
        Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"permissions");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.checkPermissionGranted(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean checkPermissionDenied(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)this, (String)string3) == -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean checkPermissionDeniedForGood(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"permission");
        if (ContextCompat.checkSelfPermission((Context)sessionPrefImpl, (String)string3) != -1) return false;
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)sessionPrefImpl, (String)string2)) return false;
        SessionPrefImpl sessionPrefImpl = ((BaseActivity)((Object)sessionPrefImpl)).session;
        if (sessionPrefImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        if (!sessionPrefImpl.checkPermissionAsked(string2)) return false;
        return true;
    }

    public void onRequestPermissionsResult(int n, @NotNull String[] stringArray, @NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"grantResults");
        super.onRequestPermissionsResult(n, stringArray, nArray);
        Permiso.getInstance().setActivity((Activity)this);
        for (String string2 : stringArray) {
            SessionPrefImpl sessionPrefImpl = this.session;
            if (sessionPrefImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            }
            sessionPrefImpl.setPermissionAsked(string2);
        }
    }

    public void setContentView(@LayoutRes int n) {
        BaseActivity baseActivity = this;
        super.setContentView(n);
        baseActivity.toolbar = (Toolbar)baseActivity.findViewById(R.id.toolbar);
        baseActivity.toolbarProgressCircle = (ProgressBar)baseActivity.findViewById(R.id.toolbarProgressCircle);
    }

    @Override
    public void showError(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"errorMessage");
        this.showShortInfo(string3);
    }

    @Override
    public void showError(int n) {
        BaseActivity baseActivity = this;
        String string2 = baseActivity.getString(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(stringResourceId)");
        baseActivity.showError(string2);
    }

    @Override
    public void showShortInfo(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkParameterIsNotNull((Object)string3, (String)"info");
        Toast.makeText((Context)this, (CharSequence)string3, (int)0).show();
    }

    @Override
    public void showShortInfo(int n) {
        BaseActivity baseActivity = this;
        String string2 = baseActivity.getString(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(stringResourceId)");
        baseActivity.showShortInfo(string2);
    }

    @Override
    public void showProgressCircle(boolean bl) {
        ProgressBar progressBar = this.toolbarProgressCircle;
        if (progressBar != null) {
            ExtensionsKt.visibleIf((View)progressBar, bl);
        } else {
            this.showLoader(bl);
        }
    }

    @Override
    public void showLoader(boolean bl) {
        if (bl) {
            Dialog dialog = baseActivity.pd;
            if (dialog == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pd");
            }
            dialog.show();
        } else {
            Dialog dialog = baseActivity.pd;
            if (dialog == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pd");
            }
            dialog.dismiss();
        }
        if (!bl) {
            BaseActivity baseActivity = baseActivity.pd;
            if (baseActivity == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pd");
            }
            baseActivity.setCancelable(true);
        }
    }

    @Override
    public void showLoader(boolean bl, boolean bl2) {
        Dialog dialog = this.pd;
        if (dialog == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pd");
        }
        dialog.setCancelable(bl2);
        this.showLoader(bl);
    }

    @Override
    public void hideKeyboard(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Object object = object.getSystemService("input_method");
        if (object != null) {
            ((InputMethodManager)object).hideSoftInputFromWindow(view.getWindowToken(), 0);
            return;
        }
        throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
    }

    @Override
    public void showInfoDialog(@Nullable String string2, @Nullable String string3, @Nullable String string4) {
        DialogUtil.buildInfoDialog$default(DialogUtil.INSTANCE, (Activity)this, string2, string3, string4, null, 16, null).show();
    }

    @Override
    public void showInfoDialog(@StringRes int n, @StringRes int n2, @StringRes int n3) {
        String string2 = n != 0 ? this.getString(n) : null;
        String string3 = n2 != 0 ? this.getString(n2) : null;
        String string4 = n3 != 0 ? this.getString(n3) : null;
        this.showInfoDialog(string2, string3, string4);
    }

    @Override
    public void onLogout() {
    }

    protected void onActivityResult(int n, int n2, @Nullable Intent intent) {
        super.onActivityResult(n, n2, intent);
        Permiso.getInstance().setActivity((Activity)this);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            BaseActivity baseActivity = this;
            view = baseActivity.findViewById(n);
            baseActivity._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        HashMap hashMap = ((BaseActivity)((Object)hashMap))._$_findViewCache;
        if (hashMap != null) {
            hashMap.clear();
        }
    }
}

