/*
 * Decompiled with CFR 0.152.
 */
package io.streamlayer.common.mvvm;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.StringRes;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import com.greysonparrelli.permiso.Permiso;
import io.streamlayer.common.dagger.components.FragmentComponent;
import io.streamlayer.common.kotlin.ExtensionsKt;
import io.streamlayer.common.mvvm.BaseView;
import io.streamlayer.common.session.SessionPrefImpl;
import io.streamlayer.sdk.R;
import io.streamlayer.utils.DialogUtil;
import java.util.HashMap;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0011\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001f\u0010\u0015\u001a\u00020\u00112\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0017\"\u00020\u0013\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u00020\u001a2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\b\u0010)\u001a\u00020\u001aH\u0016J+\u0010*\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010+\u001a\u00020,H\u0016\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001fH\u0016J\u0010\u0010.\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0013H\u0016J&\u00101\u001a\u00020\u001a2\b\b\u0001\u00102\u001a\u00020\u001f2\b\b\u0001\u00103\u001a\u00020\u001f2\b\b\u0001\u00104\u001a\u00020\u001fH\u0016J&\u00101\u001a\u00020\u001a2\b\u00105\u001a\u0004\u0018\u00010\u00132\b\u00106\u001a\u0004\u0018\u00010\u00132\b\u00104\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u0011H\u0016J\u0018\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u0011H\u0016J\u0010\u0010:\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u0011H\u0016J\u0010\u0010;\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001fH\u0016J\u0010\u0010;\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u0013H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006="}, d2={"Lio/streamlayer/common/mvvm/BaseFragment;", "Landroidx/fragment/app/Fragment;", "Lio/streamlayer/common/mvvm/BaseView;", "()V", "session", "Lio/streamlayer/common/session/SessionPrefImpl;", "getSession", "()Lio/streamlayer/common/session/SessionPrefImpl;", "setSession", "(Lio/streamlayer/common/session/SessionPrefImpl;)V", "viewModelFactory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "getViewModelFactory", "()Landroidx/lifecycle/ViewModelProvider$Factory;", "setViewModelFactory", "(Landroidx/lifecycle/ViewModelProvider$Factory;)V", "checkPermissionDeniedForGood", "", "permission", "", "checkPermissionGranted", "checkPermissionsGranted", "permissions", "", "([Ljava/lang/String;)Z", "hideKeyboard", "", "view", "Landroid/view/View;", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onAttach", "context", "Landroid/content/Context;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onLogout", "onRequestPermissionsResult", "grantResults", "", "(I[Ljava/lang/String;[I)V", "showError", "stringResourceId", "errorMessage", "showInfoDialog", "titleResourceId", "descriptionResourceId", "buttonText", "title", "description", "showLoader", "show", "cancelable", "showProgressCircle", "showShortInfo", "info", "sdk_release"})
public abstract class BaseFragment
extends Fragment
implements BaseView {
    @Inject
    @NotNull
    public ViewModelProvider.Factory viewModelFactory;
    @Inject
    @NotNull
    public SessionPrefImpl session;
    private HashMap _$_findViewCache;

    @NotNull
    public final ViewModelProvider.Factory getViewModelFactory() {
        BaseFragment baseFragment = baseFragment.viewModelFactory;
        if (baseFragment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModelFactory");
        }
        return baseFragment;
    }

    public final void setViewModelFactory(@NotNull ViewModelProvider.Factory factory) {
        ViewModelProvider.Factory factory2 = factory;
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"<set-?>");
        this.viewModelFactory = factory2;
    }

    @NotNull
    public final SessionPrefImpl getSession() {
        SessionPrefImpl sessionPrefImpl = ((BaseFragment)((Object)sessionPrefImpl)).session;
        if (sessionPrefImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        return sessionPrefImpl;
    }

    public final void setSession(@NotNull SessionPrefImpl sessionPrefImpl) {
        SessionPrefImpl sessionPrefImpl2 = sessionPrefImpl;
        Intrinsics.checkParameterIsNotNull((Object)sessionPrefImpl2, (String)"<set-?>");
        this.session = sessionPrefImpl2;
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
    }

    public void onAttach(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        FragmentComponent.Companion.inject$sdk_release(this);
        super.onAttach(context2);
    }

    public final boolean checkPermissionGranted(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)this.requireContext(), (String)string2) == 0;
    }

    public final boolean checkPermissionsGranted(String ... stringArray) {
        Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"permissions");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.checkPermissionGranted(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean checkPermissionDeniedForGood(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"permission");
        if (ContextCompat.checkSelfPermission((Context)sessionPrefImpl.requireContext(), (String)string2) != -1) return false;
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)sessionPrefImpl.requireActivity(), (String)string2)) return false;
        SessionPrefImpl sessionPrefImpl = ((BaseFragment)((Object)sessionPrefImpl)).session;
        if (sessionPrefImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"session");
        }
        if (!sessionPrefImpl.checkPermissionAsked(string2)) return false;
        return true;
    }

    public void onRequestPermissionsResult(int n, @NotNull String[] stringArray, @NotNull int[] nArray) {
        Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"grantResults");
        super.onRequestPermissionsResult(n, stringArray, nArray);
        Permiso.getInstance().setActivity((Activity)this.requireActivity());
        for (String string2 : stringArray) {
            SessionPrefImpl sessionPrefImpl = this.session;
            if (sessionPrefImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"session");
            }
            sessionPrefImpl.setPermissionAsked(string2);
        }
    }

    @Override
    public void showError(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"errorMessage");
        Toast.makeText((Context)this.requireContext(), (CharSequence)string2, (int)0).show();
    }

    @Override
    public void showError(int n) {
        Toast.makeText((Context)this.requireContext(), (int)n, (int)0).show();
    }

    @Override
    public void showShortInfo(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"info");
        Toast.makeText((Context)this.requireContext(), (CharSequence)string2, (int)0).show();
    }

    @Override
    public void showShortInfo(int n) {
        Toast.makeText((Context)this.requireContext(), (int)n, (int)0).show();
    }

    @Override
    public void showProgressCircle(boolean bl) {
        ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.toolbarProgressCircle);
        if (progressBar != null) {
            ExtensionsKt.visibleIf((View)progressBar, bl);
        } else {
            this.showLoader(bl);
        }
    }

    @Override
    public void showLoader(boolean bl) {
    }

    @Override
    public void showLoader(boolean bl, boolean bl2) {
    }

    @Override
    public void hideKeyboard(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Object object = object.requireContext().getSystemService("input_method");
        if (object != null) {
            ((InputMethodManager)object).hideSoftInputFromWindow(view.getWindowToken(), 0);
            return;
        }
        throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
    }

    @Override
    public void showInfoDialog(@Nullable String string2, @Nullable String string3, @Nullable String string4) {
        BaseFragment baseFragment = baseFragment.requireActivity();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseFragment, (String)"requireActivity()");
        DialogUtil.buildInfoDialog$default(DialogUtil.INSTANCE, (Activity)baseFragment, string2, string3, string4, null, 16, null).show();
    }

    @Override
    public void showInfoDialog(@StringRes int n, @StringRes int n2, @StringRes int n3) {
        String string2 = n != 0 ? this.getString(n) : null;
        String string3 = n2 != 0 ? this.getString(n2) : null;
        String string4 = n3 != 0 ? this.getString(n3) : null;
        this.showInfoDialog(string2, string3, string4);
    }

    @Override
    public void onLogout() {
    }

    public void onActivityResult(int n, int n2, @Nullable Intent intent) {
        super.onActivityResult(n, n2, intent);
        Permiso.getInstance().setActivity((Activity)this.requireActivity());
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.getView();
            if (view == null) {
                return null;
            }
            view = view.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        HashMap hashMap = ((BaseFragment)((Object)hashMap))._$_findViewCache;
        if (hashMap != null) {
            hashMap.clear();
        }
    }

    public /* synthetic */ void onDestroyView() {
        BaseFragment baseFragment = this;
        super.onDestroyView();
        baseFragment._$_clearFindViewByIdCache();
    }
}

